/****************************************************************************
**
**    Friendly FM - The Friendly FM Widget
**    Copyright (C) 2011 Percy Leonhardt
**
**    This program is free software: you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation, either version 3 of the License, or
**    (at your option) any later version.
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef FFMWIDGET_H
#define FFMWIDGET_H

#include "ffmsimplebutton.h"
#include "ffmtogglebutton.h"
#include "ffmdoublebutton.h"
#include "ffmsettingsdialog.h"

#include <QtGui>
#include <QtDBus/QDBusInterface>
#include <QtDBus/QDBusConnection>

class FFMWidget : public QWidget
{
    Q_OBJECT

public:
    FFMWidget();
    ~FFMWidget();

    QSize sizeHint() const;

    inline bool isFMBoostInstalled();
    inline bool isFMBoostActivated();
    inline uint getMinFrequency();
    inline uint getMaxFrequency();
    inline uint getPreset1();
    inline uint getPreset2();

public slots:
    void showSettingsDialog();
    void incrementFrequency();
    void decrementFrequency();
    void switchFMTransmitter();
    void switchBTRadio();
    void switchPreset();

    void fmPropertyChanged();
    void btPropertyChanged(QString property, QDBusVariant value);

protected:
    bool mBtOn, mTmOn;
    bool mFMBoostInstalled, mFMBoostActivated;
    uint mFreqStep, mFreqMin, mFreqMax, mFreqCurrent;
    uint mPreset1, mPreset2;

    FFMSimpleButton mLeftButton, mRightButton;
    FFMToggleButton mMiddleButton;
    FFMDoubleButton mTopButton;
    FFMSettingsDialog *mSettingsDlg;

    QSettings mSettings;
    QDBusConnection mSystemBus;
    QDBusInterface * mFMIface;
    QDBusInterface * mBTIface;
};


inline bool FFMWidget::isFMBoostInstalled()
{
    return mFMBoostInstalled;
}

inline bool FFMWidget::isFMBoostActivated()
{
    return mFMBoostActivated;
}

inline uint FFMWidget::getMinFrequency()
{
    return mFreqMin;
}

inline uint FFMWidget::getMaxFrequency()
{
    return mFreqMax;
}

inline uint FFMWidget::getPreset1()
{
    return mPreset1;
}

inline uint FFMWidget::getPreset2()
{
    return mPreset2;
}

#endif
