/****************************************************************************
**
**    Friendly FM - The Friendly FM Widget
**    Copyright (C) 2011 Percy Leonhardt
**
**    This program is free software: you can redistribute it and/or modify
**    it under the terms of the GNU General Public License as published by
**    the Free Software Foundation, either version 3 of the License, or
**    (at your option) any later version.
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef FFMDOUBLEBUTTON_H
#define FFMDOUBLEBUTTON_H

#include "ffmbutton.h"

#include <QtGui>

class FFMDoubleButton : public FFMButton
{
    Q_OBJECT

public:
    FFMDoubleButton(const char * backgroundPath, const char * backgroundPressedPath, const char * btIconPath, const char * btOnIconPath, const char * tmIconPath, const char * tmOnIconPath, QWidget *parent = 0);

    void setBtOn(bool on);
    void setTmOn(bool on);
    void setFrequency(int frequency);

signals:
    void btClicked();
    void tmClicked();

protected:
    void paintEvent(QPaintEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);

private:
    int mFrequency;
    bool mBtOn, mTmOn;
    QPoint mBtIconPos, mTmIconPos, mFreqPos;
    QPixmap mBtIcon, mBtOnIcon, mTmIcon, mTmOnIcon;
};

#endif // FFMDOUBLEBUTTON_H
