/*
 * This file is part of Maemo 5 Office UI for KOffice
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: Gopalakrishna Bhat A <gopalakbhat@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "InputUI.h"
#include "ui_FeedBackPlugin.h"

#include <QFileDialog>
#include <QMessageBox>
#include <QCloseEvent>
#include <QDebug>

InputUI::InputUI(QWidget *parent) :
        QWidget(parent),
        ui(new Ui::InputUI),
        isDirty(false),
        fileAttachmentDialog(0)
{
    ui->setupUi(this);
    ui->emailLineEdit->setInputMethodHints(Qt::ImhEmailCharactersOnly);
    ui->emailLineEdit->setInputMethodHints(Qt::ImhNoAutoUppercase);
    //ui->emailLineEdit->setInputMethodHints(Qt::ImhNoPredictiveText);
    ui->commentTextEdit->setTabChangesFocus(true);
    ui->progressBar->reset();
    ui->progressBar->setRange(0,100);
    connect(ui->pushButton,SIGNAL(clicked()),SLOT(editFilesList()));
    connect(ui->pushButton_2,SIGNAL(clicked()),SLOT(slotDoneClicked()));
    connect(ui->emailLineEdit,SIGNAL(textChanged(QString)),SLOT(setDirtyFlag(QString)));
    //connect(ui->attachFilePath,SIGNAL(textChanged(QString)),SLOT(setDirtyFlag(QString)));
    connect(ui->commentTextEdit,SIGNAL(textChanged()),SLOT(setDirtyFlag()));
}

InputUI::~InputUI()
{
    qDebug()<<Q_FUNC_INFO;
    delete ui;
}

void InputUI::slotDoneClicked()
{
    qDebug()<<Q_FUNC_INFO;
    emit feedBackDone(ui->emailLineEdit->text(),ui->commentTextEdit->toPlainText(),fileList);
}

void InputUI::closeEvent(QCloseEvent *event)
{
    qDebug()<<"dirty"<<isDirty;
    qDebug()<<"1"<<ui->commentTextEdit->toPlainText().isEmpty();
    qDebug()<<"2"<<ui->commentTextEdit->toPlainText().isNull();
    qDebug()<<"3"<<ui->commentTextEdit->toPlainText();
    qDebug()<<"not empty"<<(!(ui->emailLineEdit->text().isEmpty()) &&
                            (ui->commentTextEdit->toPlainText().isEmpty()||ui->commentTextEdit->toPlainText().isNull()));
    // (ui->attachFilePath->text().isEmpty()));
    if(isDirty && !((ui->emailLineEdit->text().isEmpty()) &&
                    (ui->commentTextEdit->toPlainText().isEmpty()) &&
       (fileList.size()==0)) &&
       QMessageBox::question(this, tr("Confirm close"),
                             tr("The feedback has not yet been submitted. Do you really want to discard?"),
                             QMessageBox::Yes,QMessageBox::No)==QMessageBox::No) {
        event->ignore();
    } else {
        emit abort();
        QWidget::closeEvent(event);
    }
}

void InputUI::setDirtyFlag(QString text)
{
    qDebug()<<"dirty";
    isDirty=true;
}

void InputUI::clearDirtyFlag()
{
    qDebug()<<"clean";
    isDirty=false;
}

void InputUI::uploadProgress(int value)
{
    ui->progressBar->setValue(value);
}

void InputUI::editFilesList()
{
    fileAttachmentDialog=new AttachFiles(this);
    connect(fileAttachmentDialog,SIGNAL(accepted()),SLOT(editFilesListDone()));
    connect(fileAttachmentDialog,SIGNAL(rejected()),SLOT(editFilesListDone()));
    fileAttachmentDialog->show();
}

void InputUI::editFilesListDone()
{
    if(fileAttachmentDialog) {
        delete fileAttachmentDialog;
    }

    fileAttachmentDialog=0;
}

QStringList InputUI::attachedFiles()
{
    return fileList;
}

void InputUI::setAttachedFiles(QStringList fileNames)
{
    fileList.clear();
    fileList.append(fileNames);
    ui->pushButton_3->setText(QString().setNum(fileNames.size()).append(" files attached"));
}
