/*
 * This file is part of Maemo 5 Office UI for KOffice
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: Gopalakrishna Bhat A <gopalakbhat@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef ATTACH_FILES_H
#define ATTACH_FILES_H

#include <QList>
#include <QDialog>

class QCheckBox;
class QGridLayout;
class QVBoxLayout;
class QScrollArea;
class QSpacerItem;
class QPushButton;

class InputUI;
class IndividualFile;

class AttachFiles: public QDialog
{
    Q_OBJECT

public:
    AttachFiles(InputUI *widget,QWidget *parent=0);
    ~AttachFiles();

public slots:
    void addFile();
    void onDoneClicked();

private:
    QList<IndividualFile *> fileList;
    QGridLayout *mainGridLayout;
    QVBoxLayout *verticalLayout;
    QScrollArea *scrollArea;
    QSpacerItem *verticalSpacer;
    QPushButton *doneButton;
    QPushButton *addMoreFiles;
    InputUI *m_ui;
    QWidget *scrollAreaWidgetContents;
};

#endif //ATTACH_FILES_H
