#ifndef VENUEDETAILS_H
#define VENUEDETAILS_H

#include <QWidget>
#include "foursquarecomm.h"
#include <QLabel>
#include "checkindetails.h"
#include "addtipdialog.h"
#include <QtConcurrentRun>
#include <QFutureWatcher>
#include <QMenu>

namespace Ui {
    class VenueDetails;
}

class VenueDetails : public QWidget
{
    Q_OBJECT

public:
    explicit VenueDetails(QWidget *parent = 0);
    ~VenueDetails();
public slots:
    void setVenue(f_venue v);
    void venueIsReady();
private:
    Ui::VenueDetails *ui;
    f_venue venue;
    void setLabelText(QLabel * l, QString s);
    FoursquareComm * fsc;
    ImageCache * ic;
    CheckinDetails * cd;
    AddTipDialog * atd;
    static f_venue getVenueDetails(QString id);

    QFuture<f_venue> *future;
    QFutureWatcher<f_venue> *watcher;
    QMenu * m;
    void doMark(QString markAs);


private slots:
    void on_pbMark_clicked();
    void on_pbAddTip_clicked();
    void on_pbCheckin_clicked();
    void mislocated_clicked();
    void closed_clicked();
    void duplicate_clicked();
};

#endif // VENUEDETAILS_H
