#include "CSms.h"
#include "dbus-strings.h"
#include <QtGui>

CSms * CSms::m_self = 0;

QTM_USE_NAMESPACE

CSms::CSms(QObject * parent)
: IRdsText(parent)
        ,format("%name% %message%")
        ,smsText("")
        ,timeout(30000)
        ,state(true)
{
    m_self = this;

    QSettings cfg;
    format = cfg.value("display/sms/format", format).toString();
    timeout = cfg.value("display/sms/timeout", timeout).toInt();
    state = cfg.value("main/sms", state).toBool();

    bConnect = false;
}

CSms::~CSms()
{
    QSettings cfg;
    cfg.setValue("display/sms/format", format);
    cfg.setValue("display/sms/timeout", timeout);
    cfg.setValue("main/sms", state);
}

void CSms::setFormat(QString value)
{
    format = value;
}

QString CSms::getFormat()
{
    return format;
}

void CSms::setTimeout(int value)
{
    timeout = value;
}

int CSms::getTimeout()
{
    return timeout;
}

void CSms::setEnable(bool value)
{
    if (value) {
        messageManager = new QMessageManager(this);
        connect(messageManager, SIGNAL(messageAdded(QMessageId,QMessageManager::NotificationFilterIdSet)), this, SLOT(slotMessageAdded(QMessageId,QMessageManager::NotificationFilterIdSet)));
        // - SMS filter
        // - InboxFolder filter
        m_notifFilterSet.insert(messageManager->registerNotificationFilter(
            QMessageFilter::byType(QMessage::Sms) &
            QMessageFilter::byStandardFolder(QMessage::InboxFolder)));
    } else {
        delete messageManager;
    }
    state = value;
    qDebug() << "Connected is " << value;
}

bool CSms::getEnable()
{
    return state && bConnect;
}

bool CSms::getState()
{
    return state;
}

void CSms::sendText(QString text)
{
    emit sigChanged(text,timeout);
}

void CSms::setConnect(int value)
{
    // If activate check before the internal plug state
    qDebug() << "SetConnect is " << value;
    if (value)
        setEnable(state);
    else {
        delete messageManager;
    }
    bConnect = value;
}

void CSms::slotMessageAdded(QMessageId Id, QMessageManager::NotificationFilterIdSet Filter)
{
    if (Filter.contains(m_notifFilterSet)) {
        QMessage message(Id)    ;
        QString msg = QString("%1 %2").arg(message.from().addressee()).arg(message.textContent());
        sendText( msg);
        qDebug() << msg;
    }

}
