#include "CSms.h"

#include <QtGui>

CSms * CSms::m_self = 0;

CSms::CSms(QObject * parent)
: IRdsText(parent)
        ,format("%name% %message%")
        ,smsText("")
        ,timeout(30000)
        ,state(true)
{
    m_self = this;

    smsManager = new QMessageManager();

    QSettings cfg;
    format = cfg.value("display/sms/format", format).toString();
    timeout = cfg.value("display/sms/timeout", timeout).toInt();
    state = cfg.value("main/sms", state).toBool();
    setConnect(state);
}

CSms::~CSms()
{
    QSettings cfg;
    cfg.setValue("display/sms/format", format);
    cfg.setValue("display/sms/timeout", timeout);
    cfg.setValue("main/sms", state);
}

void CSms::setFormat(QString value)
{
    format = value;
}

QString CSms::getFormat()
{
    return format;
}

void CSms::setTimeout(int value)
{
    timeout = value;
}

int CSms::getTimeout()
{
    return timeout;
}

void CSms::setEnable(bool value)
{
    if (value) {
       connect(smsManager, SIGNAL(messageAdded(QMessageId,QMessageManager::NotificationFilterIdSet)), this, SLOT(slotComingChanged(QMessageId,QMessageManager::NotificationFilterIdSet)));
    } else {
       disconnect(smsManager, SIGNAL(messageAdded(QMessageId,QMessageManager::NotificationFilterIdSet)), this, SLOT(slotComingChanged(QMessageId,QMessageManager::NotificationFilterIdSet)));
       state = value;
    }
}

bool CSms::getEnable()
{
    return state;
}

void CSms::slotComingChanged(QMessageId id,QMessageManager::NotificationFilterIdSet filters)
{
    // Init caller string to send
    QMessage *sms = new QMessage(id);
    QMessageAddress *from = new QMessageAddress(sms->from());
    QMessageContentContainerId *content = new QMessageContentContainerId(sms->bodyId());

    smsText.clear();
    smsText.append(format);

    smsText.replace("%name%", from->addressee());
    smsText.replace("%message%", content->toString());

    sendText(smsText);

    qDebug() << "Sms status received " << from->addressee();
}

void CSms::sendText(QString text)
{
    emit sigChanged(text,timeout);
}

void CSms::setConnect(int value)
{
    if (value) {
        // If activate check before the internal plug state
        setEnable(state);
    } else {
        disconnect(smsManager, SIGNAL(messageAdded(QMessageId,QMessageManager::NotificationFilterIdSet)), this, SLOT(slotComingChanged(QMessageId,QMessageManager::NotificationFilterIdSet)));
    }
}
