#!/bin/sh

#Made by sixwheeledbeast, Estel, Malkavian, peterleinchen and vi_

# Go root if not
if [ `id -u` != 0 ] ; then
              exec  | sudo gainroot <<EOF
exec sh $0 $*
EOF
              exit $?
fi

# Setup swap names for script

## Swap 0 - Backup internal swap location
swap0=/dev/mmcblk0p3
echo $swap0

## Swap 1 - First Main Swap Location
swap1=/dev/mmcblk1p2
echo $swap1

## Swap 2 - Second Main Swap Location
swap2=/dev/mmcblk1p3
echo $swap2

# Setup notification banner
banner(){
o=org
f=freedesktop
n=Notifications
run-standalone.sh dbus-send --type=method_call \
--dest=$o.$f.$n /$o/$f/$n $o.$f.$n.SystemNoteInfoprint string:"$1"
}

# Get and Print Current Swap Pre
swap=`cat /proc/swaps | awk '/dev/ {print $1}'`
echo $swap
banner "$swap"


sleep 4

#Logic
if [ "$swap" = "$swap1" ] ;
then
   nice -20 swapon $swap2
   nice -20 swapoff $swap1
elif [ "$swap" = "$swap2" ] ;
then
   nice -20 swapon $swap1
   nice -20 swapoff $swap2
elif [ "$swap" = "$swap0" ] ;
then
   nice -20 swapon $swap1
   nice -20 swapoff $swap0
sleep 5
# Get and Print Current Swap Post
swappost=`cat /proc/swaps | awk '/dev/ {print $1}'`
banner "$swappost"
else
   banner "Swap Switch Failed" && exit 1
fi
#End of Logic

sleep 2
#Get current swap from /proc/swaps
disk=$(cat /proc/swaps | awk '/dev/ {print $1}' | cut -d "/" -f 3)
#Get blocks used since boot from /proc/diskstats
ublocks=$(awk '{if ($3=="'"$disk"'") print $10}' /proc/diskstats)
echo $ublocks ublocks
#Multiply blocks by 512 to get used bytes
ubytes=$(($ublocks*512))
#Calculate used bytes into Kb, Mb and Gb
echo $ubytes ubytes
ukbytes=$(($ubytes/1024))
umbytes=$(($ubytes/1024/1024))
ugbytes=$(($ubytes/1024/1024/1024))
echo $ukbytes ukbytes, $umbytes umbytes, $ugbytes ugbytes
echo "$umbytes" > /tmp/flopswaplast && exit 1
