TARGET = scorecard
DESTDIR = bin
MOC_DIR = moc
OBJECTS_DIR = obj
UI_DIR = obj

QMAKE_CXXFLAGS += -Wno-return-type

CONFIG  += qt debug
TEMPLATE = app
QT      += xml maemo5

DEFINES += WANT_DEBUG

RESOURCES = scorecard.qrc

HEADERS  = \
src/score-common.h \
src/main-window.h \
src/score-dialog.h \
src/course-dialog.h \
src/settings-dialog.h \
src/table-model.h \
src/list-model.h \
src/stat-model.h \
src/xml-dom-parser.h \
src/data.h

SOURCES  = \
src/main.cpp \
src/main-window.cpp \
src/score-dialog.cpp \
src/course-dialog.cpp \
src/settings-dialog.cpp \
src/table-model.cpp \
src/list-model.cpp \
src/stat-model.cpp \
src/xml-dom-parser.cpp \
src/data.cpp

unix {
    #VARIABLES
    PREFIX = /opt/scorecard
    BINDIR = $$PREFIX/bin
    DATADIR = $$PREFIX/data
    IMGDIR = /usr/share/icons/hicolor
    MAEMODIR = /usr/share/applications/hildon

    DEFINES += DATADIR=\\\"$$DATADIR\\\" PKGDATADIR=\\\"$$PKGDATADIR\\\"

    #MAKE INSTALL    
    INSTALLS += target data desktop icon48

    target.path =$$BINDIR

    data.path = $$DATADIR
    data.files += data/club-master.xml
 
    desktop.path = $$MAEMODIR
    desktop.files += maemo/scorecard.desktop

    iconxpm.path = /usr/share/pixmap
    iconxpm.files += images/scorecard.xpm 

    icon48.path = $$IMGDIR/48x48/hildon
    icon48.files += images/scorecard-icon-48x48.png     
}
