#include "rename.h"
#include "ui_rename.h"
#include "qfileinfo.h"
#include "qdir.h"
#include "qsettings.h"


Rename::Rename(QWidget *parent, QString path, QString selected) :
    QDialog(parent),
    ui(new Ui::Rename)
{
    ui->setupUi(this);
    path1 = path;
    file1 = selected;

    if ( file1 == "filemanager-bookmark-plugin" )
    {
        QSettings settings("cepiperez","filemanager_bookmarks");
        QString name = path1;
        name.replace("/","_");
        QString name2 = settings.value(name, "").toString();
        if ( name2 == "" ) name2 = QFileInfo(path1).fileName();
        ui->lineEdit->setText(name2);
    }
    else
        ui->lineEdit->setText(file1);
    ui->errorlabel->setText("");

}

Rename::~Rename()
{
    delete ui;
}

void Rename::on_b_cancel_clicked()
{
    this->close();
}

void Rename::on_b_accept_clicked()
{
    if ( file1 == "filemanager-bookmark-plugin" )
    {
        QSettings settings("cepiperez","filemanager_bookmarks");
        QString name = path1;
        name.replace("/","_");
        settings.setValue(name, ui->lineEdit->text());
        this->close();
    }
    else
    {
        QSettings settings("cepiperez","filemanager");
        settings.setValue("NeedToRefresh", "No");
        QString realname = path1 + "/" + file1;
        QString newname = path1 + "/" + ui->lineEdit->text();
        QFileInfo sel = realname;
        if ( (sel.isDir()) && (sel.isWritable()) ) {
            QDir selected = realname;
            if ( selected.rename(realname, newname) ) {
                settings.setValue("NeedToRefresh", "Yes");
                this->close();
            } else {
                ui->errorlabel->setText( tr("Cannot rename. Try another name.") );
            }
        }
        if ( (sel.isFile()) && (sel.isWritable()) ) {
            QFile selected;
            if ( selected.rename(realname, newname) ) {
                settings.setValue("NeedToRefresh", "Yes");
                this->close();
            } else {
                ui->errorlabel->setText( tr("Cannot rename. Try another name.") );
            }
        }
        settings.sync();
    }
}
