#include <QItemDelegate>
#include <QStandardItemModel>
#include <QPainter>
#include <QDirModel>
#include <QDebug>

#include "filedelegate.h"

FileDelegate::FileDelegate(QObject *parent, int multiselection, QString col1, QString col2)
    : QAbstractItemDelegate(parent)
{
    multi = multiselection;
    color1 = col1;
    color2 = col2;
}

void FileDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option,
                          const QModelIndex &index) const
{
  QFontMetrics fm = option.fontMetrics;

  QString name = index.data(Qt::StatusTipRole).toString();
  QString desc = index.data(Qt::UserRole+1).toString();
  QString realname = index.data(Qt::UserRole+10).toString();

  painter->save();
  QRect r = option.rect;

  if(option.state & QStyle::State_Selected){
      QPixmap is1 = QPixmap("/etc/hildon/theme/images/TouchListBackgroundPressed.png");
      painter->drawTiledPixmap(r,is1);
  } else {
      QPixmap is1 = QPixmap("/etc/hildon/theme/images/TouchListBackgroundNormal.png" );
      painter->drawTiledPixmap(r,is1);
  }

  int space = 10;
  if ( multi == 1 )
  {
      QPixmap choff = QPixmap("/etc/hildon/theme/images/CheckButtonUnchecked.png" );
      QPixmap chon = QPixmap("/etc/hildon/theme/images/CheckButtonChecked.png" );
      int xi = index.data(Qt::UserRole+3).toInt();
      if ( xi == 1 )
          painter->drawPixmap( r.left()+6, r.top()+16, 38, 38, chon );
      else
          painter->drawPixmap( r.left()+6, r.top()+16, 38, 38, choff );
      space = 58;
  }

  QPixmap icon = QPixmap(index.data(Qt::UserRole+2).toString());
  painter->drawPixmap( r.left()+space, r.top()+11, 48, 48, icon );

  if ( index.data(Qt::UserRole+4).toString() != "" )
      painter->drawImage(r.left()+space, r.top()+11, QImage(index.data(Qt::UserRole+4).toString()));

  QColor base = QColor(color1);
  painter->setPen(base);

  r = option.rect;
  r.setRight( r.right()-4 );
  QFont f = painter->font();
  f.setBold(false);
  painter->setFont(f);

  if ( realname != "" )
      name = realname;

  name = fm.elidedText(name, Qt::ElideRight, r.width()-60-space);
  //desc = fm.elidedText(desc, Qt::ElideRight, r.width()-64-space);

  if ( desc == "" )
      painter->drawText(r.left()+60+space, r.top()+1, r.width()-12, r.height(), Qt::AlignVCenter|Qt::AlignLeft, name, &r);
  else
      painter->drawText(r.left()+60+space, r.top()+4, r.width()-12, r.height()-8, Qt::AlignTop|Qt::AlignLeft, name, &r);
  f.setBold(false);
  painter->setFont(f);


  base = QColor(color2);
  if ( desc == "brokenlink" ) { desc = tr("Broken Symlink"); painter->setPen(Qt::red); }
  else painter->setPen(base);
  f.setPointSize( f.pointSize()-4 );
  painter->setFont(f);
  r = option.rect;
  if ( desc != "" ) painter->drawText(r.left()+60+space, r.top(), r.width()-10, r.height()-8, Qt::AlignBottom|Qt::AlignLeft, desc, &r);

  painter->restore();

}


QSize FileDelegate::sizeHint(const QStyleOptionViewItem &,
                              const QModelIndex &) const
{
      return QSize(5, 70);
}
