#include "clipboard.h"
#include "ui_clipboard.h"
#include "qmaemo5rotator.h"

int SymPressed1;

Clipboard::Clipboard(QWidget *parent, QString selected) :
    QDialog(parent),
    ui(new Ui::Clipboard)
{
#ifdef Q_WS_MAEMO_5
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);
#endif
    ui->setupUi(this);

    clippath = selected;
    QSettings settings("cepiperez","filemanager");
    QString iconSet = settings.value("IconStyle", "Default").toString();
    settings.remove("FilesToCut");
    settings.remove("FilesToPaste");

    QIcon ic2;
    ui->label->setPixmap( QPixmap("/opt/filebox/icons/" + iconSet + "/clipboard.png") );
    ui->label_2->setText(tr("Clipboard"));

    ic2 = QPixmap("/opt/filebox/icons/" + iconSet + "/paste.png");
    ui->h_paste->setIcon( ic2 );
    ui->v_paste->setIcon( ic2 );
    ic2 = QPixmap("/opt/filebox/icons/" + iconSet + "/cut.png");
    ui->h_cut->setIcon( ic2 );
    ui->v_cut->setIcon( ic2 );
    ic2 = QPixmap("/opt/filebox/icons/" + iconSet + "/delete.png");
    ui->h_delete->setIcon( ic2 );
    ui->v_delete->setIcon( ic2 );
    ic2 = QPixmap("/opt/filebox/icons/" + iconSet + "/clear.png");
    ui->h_clear->setIcon( ic2 );
    ui->v_clear->setIcon( ic2 );

    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));

    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    orientationChanged();

    loadClipboard();

}

Clipboard::~Clipboard()
{
    delete ui;
}

void Clipboard::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
     if (screenGeometry.width() > screenGeometry.height())
     {
         ui->widget->setVisible(true);
         ui->widget_3->setVisible(false);
     }
     else
     {
         ui->widget->setVisible(false);
         ui->widget_3->setVisible(true);
     }

}

void Clipboard::loadClipboard()
{
    ui->listWidget->clear();
    QSettings fileicons("cepiperez","filemanager_icons");
    QSettings foldericons("cepiperez","filemanager_folders");
    QSettings settings("cepiperez","filemanager");

    QString iconSet = settings.value("IconStyle", "Default").toString();

    QStringList books;
    QStringList lista = settings.value("Clipboard","").toStringList();
    for (int j=0; j < lista.count(); ++j)
    {
        QFileInfo fileInfo1 = lista[j];
        if ( fileInfo1.exists() ) {
            if ( books.indexOf(lista[j]) ==-1 ) books.append( lista[j] );
        }
    }
    if ( books.count() > 0) settings.setValue( "Clipboard", books );
    else settings.remove( "Clipboard" );
    settings.sync();


    QStringList list = settings.value("Clipboard", QStringList()).toStringList();

    if ( list.count() > 0 )
    {

        for (int j=0; j < list.count(); ++j)
        {
            QFileInfo fileInfo = list[j];
            QIcon ic1;
            QListWidgetItem *item1 = new QListWidgetItem( ui->listWidget );
            item1->setData(Qt::DisplayRole, fileInfo.fileName());
            item1->setData(Qt::ToolTipRole, list[j]);

            if ( fileInfo.isDir() )
            {
                QString itemname = fileInfo.fileName();
                QString ficon = foldericons.value(itemname, "general_folder.png").toString();
                ic1 = QPixmap("/opt/filebox/icons/" + iconSet + "/folders/" + ficon );
                item1->setData(Qt::DecorationRole, ic1);
            }
            else
            {
                QString exten = fileInfo.fileName();
                int i = exten.lastIndexOf( "." );
                exten.remove ( 0, i );
                QString extension = fileicons.value( exten, "file_other.png").toString();
                ic1 = QPixmap(QString("/opt/filebox/icons/" + iconSet + "/mime/%1").arg(extension));
                item1->setData(Qt::DecorationRole, ic1);
            }
            item1->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEnabled);
            item1->setCheckState(Qt::Unchecked);
            ui->listWidget->insertItem( j, item1 );

        }
    }


    if ( ui->listWidget->count() > 0 )
    {
        QStringList lista2 = settings.value("ClipboardSelected","").toStringList();
        for ( int i=0; i < ui->listWidget->count(); ++i)
        {
            for (int j=0; j < lista2.count(); ++j)
            {
                if ( lista2[j] == ui->listWidget->item(i)->toolTip() )
                    ui->listWidget->item(i)->setCheckState(Qt::Checked);
            }
        }


        int seleccionados=0;
        for ( int ji=0; ji < ui->listWidget->count(); ++ji)
        {
            if ( ui->listWidget->item(ji)->checkState()==Qt::Checked ) seleccionados=seleccionados+1;
        }

        if ( seleccionados > 0 )
        {
            ui->h_paste->setEnabled(true); ui->v_paste->setEnabled(true);
            ui->h_cut->setEnabled(true); ui->v_cut->setEnabled(true);
            ui->h_delete->setEnabled(true); ui->v_delete->setEnabled(true);
        }
        else
        {
            ui->h_paste->setEnabled(false); ui->v_paste->setEnabled(false);
            ui->h_cut->setEnabled(false); ui->v_cut->setEnabled(false);
            ui->h_delete->setEnabled(false); ui->v_delete->setEnabled(false);
        }
        ui->h_clear->setEnabled(true); ui->v_clear->setEnabled(true);
    }
    else
    {
        ui->h_paste->setEnabled(false); ui->v_paste->setEnabled(false);
        ui->h_cut->setEnabled(false); ui->v_cut->setEnabled(false);
        ui->h_delete->setEnabled(false); ui->v_delete->setEnabled(false);
        ui->h_clear->setEnabled(false); ui->v_clear->setEnabled(false);
        settings.remove("ClipboardSelected");
    }


}

void Clipboard::on_h_delete_pressed()
{
    deleteClipboard(true);
}

void Clipboard::on_v_delete_pressed()
{
    deleteClipboard(true);
}

void Clipboard::deleteClipboard(bool refresh)
{
    QSettings settings("cepiperez","filemanager");
    for ( int i=0; i < ui->listWidget->count(); ++i )
    {
        if ( ui->listWidget->item(i)->checkState()==Qt::Checked )
        {
            QString sel = ui->listWidget->item(i)->toolTip();
            QStringList books;
            QStringList list = settings.value("Clipboard","").toStringList();
            for (int j=0; j < list.count(); ++j)
            {
                if ( list[j] != sel) {
                    books.append( list[j] );
                }
            }

            if ( books.count() > 0) settings.setValue( "Clipboard", books );
            else { settings.remove( "Clipboard" ); settings.remove("ClipboardSelected"); }
            settings.sync();
        }
    }
    /*if ( ui->listWidget->selectedItems().count() == 0 )
    {
        settings.remove("ClipboardSelected");
        return;
    }*/


    if (refresh) loadClipboard();

}

void Clipboard::on_h_clear_pressed()
{
    clearClipboard();
}

void Clipboard::on_v_clear_pressed()
{
    clearClipboard();
}

void Clipboard::clearClipboard()
{
    QSettings settings("cepiperez","filemanager");
    settings.remove("Clipboard");
    settings.remove("ClipboardSelected");
    settings.sync();
    loadClipboard();
}

void Clipboard::on_v_paste_pressed()
{
    pasteFile();
}

void Clipboard::on_h_paste_pressed()
{
    pasteFile();
}

void Clipboard::on_v_cut_pressed()
{
    cutFile();
}

void Clipboard::on_h_cut_pressed()
{
    cutFile();
}

void Clipboard::pasteFile()
{
    QStringList items;
    items.clear();
    for ( int i=0; i < ui->listWidget->count(); ++i)
    {
        if ( ui->listWidget->item(i)->checkState()==Qt::Checked )
        {
            items.append( ui->listWidget->item(i)->toolTip() );
        }
    }
    QSettings settings("cepiperez","filemanager");
    settings.setValue("FilesToPaste", items);
    this->close();

}

void Clipboard::cutFile()
{
    QStringList items;
    items.clear();
    for ( int i=0; i < ui->listWidget->count(); ++i)
    {
        if ( ui->listWidget->item(i)->checkState()==Qt::Checked )
        {
            items.append( ui->listWidget->item(i)->toolTip() );
        }
    }
    QSettings settings("cepiperez","filemanager");
    settings.setValue("FilesToCut", items);
    this->close();
}

void Clipboard::on_listWidget_itemClicked(QListWidgetItem*)
{
    if ( ui->listWidget->currentItem()->checkState()==Qt::Checked) ui->listWidget->currentItem()->setCheckState(Qt::Unchecked);
    else ui->listWidget->currentItem()->setCheckState(Qt::Checked);
    checkSelected();
}

void Clipboard::checkSelected()
{
    QSettings settings("cepiperez","filemanager");
    QStringList sels;
    int seleccionados=0;
    for ( int i=0; i < ui->listWidget->count(); ++i)
    {
        if ( ui->listWidget->item(i)->checkState()==Qt::Checked )
        {
            sels.append(ui->listWidget->item(i)->toolTip());
            seleccionados=seleccionados+1;
        }
    }
    settings.setValue("ClipboardSelected", sels);
    settings.sync();

    if ( seleccionados > 0 )
    {
        ui->h_paste->setEnabled(true); ui->v_paste->setEnabled(true);
        ui->h_cut->setEnabled(true); ui->v_cut->setEnabled(true);
        ui->h_delete->setEnabled(true); ui->v_delete->setEnabled(true);
    }
    else
    {
        settings.remove("ClipboardSelected");
        ui->h_paste->setEnabled(false); ui->v_paste->setEnabled(false);
        ui->h_cut->setEnabled(false); ui->v_cut->setEnabled(false);
        ui->h_delete->setEnabled(false); ui->v_delete->setEnabled(false);
    }
}


void Clipboard::keyPressEvent(QKeyEvent* k)
{
    if ( k->key() == 16777249 ) SymPressed1=1;
}

void Clipboard::keyReleaseEvent(QKeyEvent* k)
{
    if ( k->key() == 16777249 ) SymPressed1=0;

    if ( ( k->key() == 65 ) && ( SymPressed1==1 ) )
    {
        for ( int i=0; i < ui->listWidget->count(); ++i) {
            ui->listWidget->item(i)->setCheckState(Qt::Checked);
        }
        checkSelected();
    }
    else if ( ( k->key() == 68 ) && ( SymPressed1==1 ) )
    {
        for ( int i=0; i < ui->listWidget->count(); ++i) {
            ui->listWidget->item(i)->setCheckState(Qt::Unchecked);
        }
        checkSelected();
    }
}
