#include "permissions.h"
#include "ui_permissions.h"
#include "qfileinfo.h"


Permissions::Permissions(QWidget *parent, QString selected) :
    QDialog(parent),
    ui(new Ui::Permissions)
{
    ui->setupUi(this);
    file1 = selected;

    loadPermissions();

    this->setWindowTitle( QFile(file1).fileName() );

}

Permissions::~Permissions()
{
    delete ui;
}

void Permissions::loadPermissions()
{
    QFileInfo f(file1);
    if ( f.owner() == "root" ) ui->owner_root->setChecked(true);
    else ui->owner_user->setChecked(true);
    if ( f.group() == "root" ) ui->group_root->setChecked(true);
    else ui->group_user->setChecked(true);
    if ( f.permission(QFile::ReadUser) ) ui->owner_read->setChecked(true);
    if ( f.permission(QFile::WriteUser) ) ui->owner_write->setChecked(true);
    if ( f.permission(QFile::ExeUser) ) ui->owner_exec->setChecked(true);
    if ( f.permission(QFile::ReadGroup) ) ui->user_read->setChecked(true);
    if ( f.permission(QFile::WriteGroup) ) ui->user_write->setChecked(true);
    if ( f.permission(QFile::ExeGroup) ) ui->user_exec->setChecked(true);
    if ( f.permission(QFile::ReadOther) ) ui->group_read->setChecked(true);
    if ( f.permission(QFile::WriteOther) ) ui->group_write->setChecked(true);
    if ( f.permission(QFile::ExeOther) ) ui->group_exec->setChecked(true);

}

void Permissions::on_pushButton_2_clicked()
{
    this->close();
}

void Permissions::on_pushButton_clicked()
{
    /*QString extra = " ";
    if ( QFileInfo(file1).isDir() ) extra = " -R ";

    QString a = "";
    if ( ui->owner_root->isChecked() ) a += "root:";
    else a += "user:";
    if ( ui->group_root->isChecked() ) a += "root";
    else a += "users";

    QString sended = QString("chown%1%2 \"%3\"").arg(extra).arg(a).arg(file1);
    QByteArray ba = sended.toLatin1();
    const char *str1 = ba.data();
    system(str1);



    int i = 0;
    if ( ui->owner_read->isChecked() ) i=i+400;
    if ( ui->owner_write->isChecked() ) i=i+200;
    if ( ui->owner_exec->isChecked() ) i=i+100;
    if ( ui->user_read->isChecked() ) i=i+40;
    if ( ui->user_write->isChecked() ) i=i+20;
    if ( ui->user_exec->isChecked() ) i=i+10;
    if ( ui->group_read->isChecked() ) i=i+4;
    if ( ui->group_write->isChecked() ) i=i+2;
    if ( ui->group_exec->isChecked() ) i=i+1;

    sended = QString("chmod%1%2 \"%3\"").arg(extra).arg(i).arg(file1);
    ba = sended.toLatin1();
    const char *str2 = ba.data();
    system(str2);*/

    QFile f (file1);
    f.open(QIODevice::ReadWrite);
    if ( ui->owner_read->isChecked() ) f.setPermissions(QFile::ReadUser);
    if ( ui->owner_write->isChecked() ) f.setPermissions(QFile::WriteUser);
    if ( ui->owner_exec->isChecked() ) f.setPermissions(QFile::ExeUser);
    if ( ui->user_read->isChecked() ) f.setPermissions(QFile::ReadGroup);
    if ( ui->user_write->isChecked() ) f.setPermissions(QFile::WriteGroup);
    if ( ui->user_exec->isChecked() ) f.setPermissions(QFile::ExeGroup);
    if ( ui->group_read->isChecked() ) f.setPermissions(QFile::ReadOther);
    if ( ui->group_write->isChecked() ) f.setPermissions(QFile::WriteOther);
    if ( ui->group_exec->isChecked() ) f.setPermissions(QFile::ExeOther);
    f.close();



    loadPermissions();


}
