#include "askdialog.h"
#include "ui_askdialog.h"
#include "qsettings.h"

AskDialog::AskDialog(QWidget *parent, QStringList file, QString target) :
    QDialog(parent),
    ui(new Ui::AskDialog)
{
    ui->setupUi(this);
    target1 = target;

    if ( target1 == "DeleteAsk" )
    {
        this->setWindowTitle(tr("Deleting"));
        if ( file.count() > 1 )
            ui->label->setText( tr("Are you sure you want to delete selected files?") );
        else
            ui->label->setText( tr("Are you sure you want to delete %1?").arg(file[0]) );
    }
    else if ( target1 == "Subfolders" )
    {
        this->setWindowTitle(tr("Change icon"));
        ui->label->setText( tr("Apply to subfolders?") );
    }
}

AskDialog::~AskDialog()
{
    delete ui;
}

void AskDialog::on_pushButton_2_clicked()
{
    this->close();

}

void AskDialog::on_pushButton_clicked()
{
    QSettings settings("cepiperez","filemanager");
    settings.setValue(target1, "Yes");
    settings.sync();
    this->close();
}
