#include "settings.h"
#include "ui_settings.h"
#include "qmaemo5rotator.h"
#include "home.h"
#include "qfileinfo.h"

Settings::Settings(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Settings)
{
#ifdef Q_WS_MAEMO_5
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);
#endif
    ui->setupUi(this);
    QSettings settings("cepiperez","filemanager");

    QString iconSet = settings.value("IconStyle", "Humanity").toString();

    ui->label->setPixmap( QPixmap("/opt/filebox/icons/" + iconSet + "/settings.png") );
    ui->label_2->setText(tr("Settings"));

    QFileInfo dr = settings.value("Home","/home").toString();

    if ( QFileInfo("/home/user/.config/cepiperez/.rootenabled").exists() ) ui->ch_root->setChecked(true);
    if ( settings.value("ShowHiddenFiles", "No").toString() == "Yes" ) ui->ch_hidden->setChecked(true);
    if ( settings.value("DeleteOnPaste", "No").toString() == "Yes" ) ui->ch_paste->setChecked(true);
    if ( settings.value("Thumbnails", "No").toString() == "Yes" ) ui->ch_thumb->setChecked(true);
    if ( settings.value("Multiselection", "No").toString() == "Yes" ) ui->ch_multi->setChecked(true);
    if ( settings.value("FilesDetail", "No").toString() == "Yes" ) ui->ch_detail->setChecked(true);
    if ( settings.value("AutoSelect", "No").toString() == "Yes" ) ui->ch_autoselect->setChecked(true);
    settings.setValue("NeedToRefresh", "No");


    ui->button->setIcon( QPixmap("/opt/filebox/icons/" + iconSet + "/homefolder.png") );
    ui->button->setText( dr.fileName() );
    if ( dr.absoluteFilePath() == "/") ui->button->setText( "/" );
    ui->button->setValueText( dr.path() + "/" + dr.fileName() );
    if ( dr.absoluteFilePath() == "/") ui->button->setValueText( "" );

    QDir dir ( "/opt/filebox/icons", "*" );
    dir.setFilter( QDir::Dirs | QDir::NoDotAndDotDot );
    ui->comboicons->clear(); int selc=0;
    QStringList entries = dir.entryList();
    ui->comboicons->addItems( entries );
    for ( int i=0; i < entries.count(); ++i )
    {
        QIcon icc = QPixmap("/opt/filebox/icons/" + iconSet + "/homefolder.png");
        ui->comboicons->setItemIcon(i, icc);
        if ( entries[i] == iconSet ) selc = i;
    }
    ui->comboicons->setCurrentIndex(selc);


    ui->texteditor->clear();
    QStringList entries2;
    entries2.append(tr("Automatic")); entries2.append(tr("Landscape")); entries2.append(tr("Portrait"));
    ui->comboBox->addItems( entries2 );
    QIcon icc = QPixmap("/opt/filebox/icons/" + iconSet + "/orient_auto.png");
    ui->comboBox->setItemIcon(0, icc);
    icc = QPixmap("/opt/filebox/icons/" + iconSet + "/orient_landscape.png");
    ui->comboBox->setItemIcon(1, icc);
    icc = QPixmap("/opt/filebox/icons/" + iconSet + "/orient_portrait.png");
    ui->comboBox->setItemIcon(2, icc);

    if ( settings.value("Orientation", "Auto").toString()=="Portrait" )
         ui->comboBox->setCurrentIndex(2);
    else if ( settings.value("Orientation", "Auto").toString()=="Landscape" )
        ui->comboBox->setCurrentIndex(1);
    else
        ui->comboBox->setCurrentIndex(0);



    entries2.clear();
    entries2.append("Notes");
    if ( QFileInfo("/usr/bin/leafpad").exists() ) entries2.append("Leafpad");
    if ( QFileInfo("/usr/bin/pygtkeditor").exists() ) entries2.append("PyGTKEditor");
    if ( QFileInfo("/usr/bin/nano").exists() ) entries2.append("Nano");
    if ( QFileInfo("/usr/bin/vim").exists() ) entries2.append("Vim");
    entries2.append("Vi");

    //entries2 << "Leafpad" << "Nano" << "PyGTKEditor" << "Vi" << "Vim";
    ui->texteditor->addItems( entries2 );
    int xi = 1; int leafi, pyi, nanoi, vimi, vii;

    icc = QPixmap("/opt/filebox/icons/" + iconSet + "/notes.png");
    ui->texteditor->setItemIcon(0, icc);

    if ( QFileInfo("/usr/bin/leafpad").exists() )
    {
        icc = QPixmap("/opt/filebox/icons/" + iconSet + "/leafpad.png");
        ui->texteditor->setItemIcon(xi, icc); leafi=xi; xi=xi+1;
    }

    if ( QFileInfo("/usr/bin/pygtkeditor").exists() )
    {
        icc = QPixmap("/opt/filebox/icons/" + iconSet + "/pygtkeditor.png");
        ui->texteditor->setItemIcon(xi, icc); pyi=xi; xi=xi+1;
    }

    if ( QFileInfo("/usr/bin/nano").exists() )
    {
        icc = QPixmap("/opt/filebox/icons/" + iconSet + "/nano.png");
        ui->texteditor->setItemIcon(xi, icc); nanoi=xi; xi=xi+1;
    }

    if ( QFileInfo("/usr/bin/vim").exists() )
    {
        icc = QPixmap("/opt/filebox/icons/" + iconSet + "/vim.png");
        ui->texteditor->setItemIcon(xi, icc); vimi=xi; xi=xi+1;
    }

    icc = QPixmap("/opt/filebox/icons/" + iconSet + "/nano.png");
    ui->texteditor->setItemIcon(xi, icc); vii=xi;

    if ( settings.value("TextEditor", "-").toString() == "Leafpad" && QFileInfo("/usr/bin/leafpad").exists() ) ui->texteditor->setCurrentIndex(leafi);
    else if ( settings.value("TextEditor", "-").toString() == "PyGTKEditor" && QFileInfo("/usr/bin/pygtkeditor").exists() ) ui->texteditor->setCurrentIndex(pyi);
    else if ( settings.value("TextEditor", "-").toString() == "Nano" && QFileInfo("/usr/bin/nano").exists() ) ui->texteditor->setCurrentIndex(nanoi);
    else if ( settings.value("TextEditor", "-").toString() == "Vim" && QFileInfo("/usr/bin/vim").exists() ) ui->texteditor->setCurrentIndex(vimi);
    else if ( settings.value("TextEditor", "-").toString() == "Vi" ) ui->texteditor->setCurrentIndex(vii);
    else ui->texteditor->setCurrentIndex(0);

    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));

    //setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    orientationChanged();

}

Settings::~Settings()
{
    delete ui;
}

void Settings::orientationChanged()
{
     QCoreApplication::processEvents();
     QRect screenGeometry = QApplication::desktop()->screenGeometry();
     if (screenGeometry.width() > screenGeometry.height())
     { ui->ch_detail->setMaximumWidth(763); ui->ch_detail->setMinimumWidth(763); }
     else
     { ui->ch_detail->setMaximumWidth(443); ui->ch_detail->setMinimumWidth(443); }

     QCoreApplication::processEvents();
     QFontMetrics fm = ui->ch_detail->fontMetrics();
     ui->ch_root->setText(fm.elidedText(tr("Enable root access (restart needed)"), Qt::ElideRight, ui->ch_detail->width()-80));
     ui->ch_hidden->setText(fm.elidedText(tr("Show hidden files and folders"), Qt::ElideRight, ui->ch_detail->width()-80));
     ui->ch_paste->setText(fm.elidedText(tr("Delete items from clipboard on Paste"), Qt::ElideRight, ui->ch_detail->width()-80));
     ui->ch_thumb->setText(fm.elidedText(tr("Show thumbnails for images"), Qt::ElideRight, ui->ch_detail->width()-80));
     ui->ch_detail->setText(fm.elidedText(tr("Show details for files"), Qt::ElideRight, ui->ch_detail->width()-80));
     ui->ch_multi->setText(fm.elidedText(tr("Enable multiselection"), Qt::ElideRight, ui->ch_detail->width()-80));
     ui->ch_autoselect->setText(fm.elidedText(tr("Auto select items in clipboard"), Qt::ElideRight, ui->ch_detail->width()-80));

}


void Settings::on_ch_hidden_clicked()
{
    QSettings settings("cepiperez","filemanager");
    if (ui->ch_hidden->isChecked()) settings.setValue("ShowHiddenFiles","Yes");
    else settings.setValue("ShowHiddenFiles","No");
    settings.setValue("NeedToRefresh", "Yes");
}

void Settings::on_ch_paste_clicked()
{
    QSettings settings("cepiperez","filemanager");
    if (ui->ch_paste->isChecked()) settings.setValue("DeleteOnPaste","Yes");
    else settings.setValue("DeleteOnPaste","No");
}

void Settings::on_ch_root_clicked()
{
    if (ui->ch_root->isChecked())
    {
        system("touch /home/user/.config/cepiperez/.rootenabled");
    }
    else
    {
        system("rm /home/user/.config/cepiperez/.rootenabled");
    }
}

void Settings::on_ch_thumb_clicked()
{
    QSettings settings("cepiperez","filemanager");
    if (ui->ch_thumb->isChecked()) settings.setValue("Thumbnails","Yes");
    else settings.setValue("Thumbnails","No");
    settings.setValue("NeedToRefresh", "Yes");
}

void Settings::on_comboicons_activated(QString )
{
    QSettings settings("cepiperez","filemanager");
    settings.setValue("IconStyle", ui->comboicons->currentText());
    settings.setValue("RefreshIcons", "Yes");
    settings.sync();
}

void Settings::on_texteditor_activated(QString )
{
    QSettings settings("cepiperez","filemanager");
    settings.setValue("TextEditor", ui->texteditor->currentText());
    settings.sync();
}


void Settings::on_ch_multi_clicked()
{
    QSettings settings("cepiperez","filemanager");
    if (ui->ch_multi->isChecked()) settings.setValue("Multiselection","Yes");
    else settings.setValue("Multiselection","No");
    settings.setValue("NeedToRefresh", "Yes");
    settings.sync();
}

void Settings::on_button_clicked()
{
    QSettings settings("cepiperez","filemanager");
    Home* hw = new Home(this, "Home", settings.value("Home","/home/user/MyDocs").toString());
    hw->exec();
    QString dr = settings.value("Home","/home/user/MyDocs").toString();
    ui->button->setText( QFileInfo(dr).fileName() );
    if ( dr == "/") ui->button->setText( "/" );
    ui->button->setValueText( dr );
    if ( dr == "/") ui->button->setValueText( "" );
    settings.setValue("NeedToRefresh", "Yes");
}

void Settings::on_ch_detail_clicked()
{
    QSettings settings("cepiperez","filemanager");
    if (ui->ch_detail->isChecked()) settings.setValue("FilesDetail","Yes");
    else settings.setValue("FilesDetail","No");
    settings.setValue("NeedToRefresh", "Yes");
    settings.sync();
}

void Settings::on_ch_autoselect_clicked()
{
    QSettings settings("cepiperez","filemanager");
    if (ui->ch_autoselect->isChecked()) settings.setValue("AutoSelect","Yes");
    else settings.setValue("AutoSelect","No");
    settings.sync();
}

void Settings::on_comboBox_activated(int index)
{
    QSettings settings("cepiperez","filemanager");
    if ( index == 0 )
    {
        settings.setValue("Orientation", "Auto");
        setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    }
    else if ( index == 1 )
    {
        settings.setValue("Orientation", "Landscape");
        setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);
    }
    else
    {
        settings.setValue("Orientation", "Portrait");
        setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
    }
    settings.sync();
    orientationChanged();
}
