#include "bookmarks.h"
#include "ui_bookmarks.h"
#include "qmaemo5rotator.h"
#include "qsettings.h"
#include "rename.h"
#include "filedelegate.h"

QString col1, col2;

Bookmarks::Bookmarks(QWidget *parent, QString color1, QString color2) :
    QDialog(parent),
    ui(new Ui::Bookmarks)
{
#ifdef Q_WS_MAEMO_5
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);
#endif

    ui->setupUi(this);

    col1 = color1;
    col2 = color2;

    QSettings settings("cepiperez","filemanager");
    QString iconSet = settings.value("IconStyle", "Default").toString();
    ui->label->setPixmap( QPixmap("/opt/filebox/icons/" + iconSet + "/bookmarks.png") );

    loadBook();

    this->setAttribute(Qt::WA_Maemo5AutoOrientation, true);

}

Bookmarks::~Bookmarks()
{
    delete ui;
}

void Bookmarks::loadBook()
{
    ui->listWidget->clear();
    QSettings settings("cepiperez","filemanager");
    QSettings bsettings("cepiperez","filemanager_bookmarks");
    QSettings fsettings("cepiperez","filemanager_folders");
    QString iconSet = settings.value("IconStyle", "Default").toString();
    QStringList list = bsettings.value("Bookmarks","nothing").toStringList();

    if ( list[0] == "nothing" ) return;

    for (int j=0; j < list.count(); ++j)
    {
        QListWidgetItem *item1 = new QListWidgetItem( ui->listWidget );
        QString name = list[j];
        name.replace("/","_");
        QString name2 = bsettings.value(name, "").toString();
        if ( name2 == "" ) name2 = QFileInfo(list[j]).fileName();
        item1->setData(Qt::StatusTipRole, name2 );
        //QIcon ic1 = QPixmap("/opt/filebox/icons/" + iconSet + "/folders/general_folder.png");
        //item1->setData(Qt::DecorationRole, ic1);

        QString ficon = fsettings.value(QFileInfo(list[j]).fileName(), "general_folder.png").toString();
        if ( ! QFileInfo("/opt/filebox/icons/" + iconSet + "/folders/" + ficon).exists() )
            ficon = "general_folder.png";

        item1->setData(Qt::UserRole + 1, list[j] );
        item1->setData(Qt::UserRole + 2, "/opt/filebox/icons/" + iconSet + "/folders/" + ficon);
        ui->listWidget->insertItem( j, item1 );
    }

    FileDelegate *pluginDelegate = new FileDelegate(this, 0, col1, col2);
    ui->listWidget->setItemDelegate(pluginDelegate);

}

void Bookmarks::on_listWidget_itemClicked(QListWidgetItem* item)
{
    QSettings settings("cepiperez","filemanager");
    settings.setValue("CurrentDir", item->data(Qt::UserRole+1).toString() );
    settings.sync();
    this->close();

}

void Bookmarks::on_listWidget_customContextMenuRequested(QPoint pos)
{
    if ( ui->listWidget->count() == 0 ) return;
    if ( ui->listWidget->selectedItems().count() == 0 ) return;

    QMenu *menu = new QMenu(this);
    menu->addAction(tr("Rename"), this, SLOT(editBook()));
    menu->addAction(tr("Delete"), this, SLOT(removeBook()));
    menu->exec(mapToGlobal(pos));

}

void Bookmarks::removeBook()
{
    QString sel = ui->listWidget->currentItem()->data(Qt::UserRole+1).toString();
    QSettings bsettings("cepiperez","filemanager_bookmarks");

    QStringList books;
    QStringList list = bsettings.value("Bookmarks","").toStringList();
    for (int j=0; j < list.count(); ++j)
    {
        if ( list[j] != sel) {
            books.append( list[j] );
            //books.append(", ");
        }
    }

    if ( books.count() > 0) bsettings.setValue( "Bookmarks", books );
    else bsettings.remove( "Bookmarks" );

    QString name = ui->listWidget->currentItem()->data(Qt::UserRole+1).toString();
    name.replace("/","_");
    bsettings.remove(name);
    bsettings.sync();

    loadBook();

}

void Bookmarks::editBook()
{
    Rename* rd = new Rename( this, ui->listWidget->currentItem()->data(Qt::UserRole+1).toString(), "filemanager-bookmark-plugin" );
    rd->exec();

    loadBook();

}
