#ifndef ME_DBUS_CONN_H
#define ME_DBUS_CONN_H

#include <glib-object.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus.h>
#include <glib.h>

#define G_DEBUG_DISABLE 
#define FCITM_KBD_TYPE (fcitm_kbd_get_type())
#define FCITM_KBD(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), FCITM_KBD, fcitm_kbd))
#define FCITM_KBD_GET_CLASS(obj) \
        (G_TYPE_INSTANCE_GET_CLASS ((obj), \
         FCITM_KBD_TYPE, fcitm_kbd_class))

typedef gboolean (*key_press_func)( guint keyval, guint state, gchar **str, gboolean *ret);

typedef struct{
    GObject parent;
    key_press_func key_press;
}fcitm_kbd;

typedef struct{
    GObjectClass parent_class;
}fcitm_kbd_class;

GType fcitm_kbd_get_type(void);
fcitm_kbd* fcitm_kbd_new(void);
gboolean fcitm_kbd_key_press( fcitm_kbd* obj, guint keyval, guint state, gboolean *ret, gchar **str, GError **error);
void fcitm_kbd_set_key_func( fcitm_kbd* conn, key_press_func func );

#endif
