#include "conn.h"

gboolean fcitm_kbd_key_press( fcitm_kbd* obj, guint keyval, guint state, gboolean *ret, gchar **str, GError **error){
    obj->key_press( keyval, state, str, ret);
    return TRUE;
}

#include "bind.h"

static void fcitm_kbd_class_init( fcitm_kbd_class* klass );
static void fcitm_kbd_init( fcitm_kbd* obj );

GType fcitm_kbd_get_type( void ){
    static GType fcitm_kbd_type = 0;
    if ( !fcitm_kbd_type ) {
        static const GTypeInfo fcitm_kbd_info = {
            sizeof( fcitm_kbd_class ),
            NULL,
            NULL,
            (GClassInitFunc)fcitm_kbd_class_init,
            NULL,
            NULL,
            sizeof( fcitm_kbd ),
            0,
            (GInstanceInitFunc)fcitm_kbd_init
        };
        fcitm_kbd_type = g_type_register_static( G_TYPE_OBJECT, "fcitm_kbd", &fcitm_kbd_info, 0 );
    }
    return fcitm_kbd_type;
}

static void fcitm_kbd_class_init( fcitm_kbd_class* klass ){
    g_debug("fcitm_kbd_class_init");
    dbus_g_object_type_install_info( FCITM_KBD_TYPE, &dbus_glib_fcitm_kbd_object_info );
}
static void fcitm_kbd_init( fcitm_kbd* obj ){
    g_debug("fcitm_kbd_init");

    DBusGConnection* conn;
    DBusGProxy* proxy;
    GError *error = NULL;
    guint request_name_result;

    conn = dbus_g_bus_get (DBUS_BUS_SESSION, &error);
    proxy = dbus_g_proxy_new_for_name( conn, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus" );
    dbus_g_proxy_call ( proxy, "RequestName", &error, G_TYPE_STRING, "org.fcitm.im", G_TYPE_UINT, 0, G_TYPE_INVALID, G_TYPE_UINT, &request_name_result, G_TYPE_INVALID );
    dbus_g_connection_register_g_object ( conn, "/im", G_OBJECT(obj) );
}

fcitm_kbd* fcitm_kbd_new(void){
    g_debug("fcitm_kbd_new");
    fcitm_kbd* obj;
    obj = g_object_new( FCITM_KBD_TYPE, NULL );
    return obj;
}

void fcitm_kbd_set_key_func( fcitm_kbd* conn, key_press_func func ){
    conn->key_press = func;
}
