#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QDialogButtonBox>
#include <QFont>
#include <QLabel>
#include <QMessageBox>
#ifdef Q_WS_MAEMO_5
#include <QMaemo5InformationBox>
#endif

#include "wndconfigcustomisation.h"

wndConfigCustomisation::wndConfigCustomisation(QWidget *parent) :
    QWidget(parent)
{
    this->setGeometry(0, 0, 800, 480);
    this->setWindowFlags(this->windowFlags() | Qt::Window);
    this->setWindowModality(Qt::WindowModal);
#ifdef Q_WS_MAEMO_5
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
#endif

    QFont bldFont = QFont();
    bldFont.setBold(true);

    QLabel *lblAvailable = new QLabel(tr("Available"));
    lblAvailable->setAlignment(Qt::AlignCenter);
    lblAvailable->setFont(bldFont);

    lstAvailable = new myDragListWidget(this);

    QLabel *lblSelected = new QLabel(tr("Selected"));
    lblSelected->setAlignment(Qt::AlignCenter);
    lblSelected->setFont(bldFont);

    lstSelected = new myDragListWidget(this);

    QDialogButtonBox *buttonBox = new QDialogButtonBox(QDialogButtonBox::Cancel|QDialogButtonBox::Save, Qt::Horizontal);

    QVBoxLayout *lytWindow = new QVBoxLayout();
    QHBoxLayout *lytLists = new QHBoxLayout();
    QVBoxLayout *lytAvailable = new QVBoxLayout();
    QVBoxLayout *lytSelected = new QVBoxLayout();

    lytWindow->addLayout(lytLists);
    lytWindow->addWidget(buttonBox);
    lytLists->addLayout(lytAvailable);
    lytLists->addLayout(lytSelected);
    lytAvailable->addWidget(lblAvailable);
    lytAvailable->addWidget(lstAvailable);
    lytSelected->addWidget(lblSelected);
    lytSelected->addWidget(lstSelected);

    connect(buttonBox, SIGNAL(rejected()), this, SLOT(close()));
    connect(buttonBox, SIGNAL(accepted()), this, SLOT(writeConfig()));

    stdPalette = new QPalette(lstSelected->palette());
    fullPalette = 0;

    this->setLayout(lytWindow);
}

void wndConfigCustomisation::setConfig(fbConfig *config) {
    myConfig = config;
    this->loadData();
}

void wndConfigCustomisation::loadData() {
    lstSelected->clear();
    lstAvailable->clear();

    const QStringList *selected = myConfig->getCurrentEntries();

    for (int i = 0; i < selected->count(); i++) {
        lstSelected->addItem(myConfig->getItemDescription(selected->at(i)));
    }

    const QStringList available = myConfig->getAvailableItems();

    for (int i = 0; i < available.count(); i++) {
        if (!selected->contains(available.at(i))) {
            lstAvailable->addItem(myConfig->getItemDescription(available.at(i)));
        }
    }

    lstAvailable->sortItems();
    this->checkSelectedCount();
}

void wndConfigCustomisation::writeConfig() {
    QStringList selected;

    for (int i = 0; i < lstSelected->count(); i++) {
        selected.append(lstSelected->item(i)->text());
    }

    if (!myConfig->writeConfig(&selected)) {
        QMessageBox::critical(this, tr("Save failed"), tr("Failed to write the custom configuration file"));
    } else {
#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(this, tr("Configuration saved"));
#else
        QMessageBox::information(this, tr("Save complete"), tr("Configuration saved"));
#endif
    }
}


void wndConfigCustomisation::dropDone(QWidget *dest, QWidget *src) {
    if (dest == lstAvailable)
        lstAvailable->sortItems();

    if (src == dest)
        return;

    if (src == lstAvailable)
        this->checkSelectedCount();

    if ((src == lstSelected) && (lstAvailable->dragDropMode() == QAbstractItemView::DropOnly))
        this->setSelectedFull(false);
}

void wndConfigCustomisation::checkSelectedCount() {
    int maxEntries = myConfig->getMaxEntries();

    if (maxEntries <= 0)
        return;

    if (lstSelected->count() >= maxEntries)
        this->setSelectedFull(true);
}

void wndConfigCustomisation::setSelectedFull(bool enable) {
    if (enable) {
        if (!fullPalette) {
            fullPalette = new QPalette(*stdPalette);
            fullPalette->setColor(QPalette::Base, QColor("red"));
        }

        lstAvailable->setDragDropMode(QAbstractItemView::DropOnly);
        lstSelected->setPalette(*fullPalette);
    } else {
        lstAvailable->setDragDropMode(QAbstractItemView::DragDrop);
        lstSelected->setPalette(*stdPalette);
    }
}
