#ifndef FBCONFIG_H
#define FBCONFIG_H

#include <QHash>
#include <QStringList>

class fbConfig : public QObject
{
    Q_OBJECT

public:
    fbConfig(QObject *parent = 0);

    int getMaxEntries();
    const QStringList getAvailableItems();
    const QString getItemDescription(const QString item);
    const QString getItemName(const QString description);
    const QStringList *getCurrentEntries();
    virtual bool writeConfig(const QStringList *selected) = 0;

private:
    Q_DISABLE_COPY(fbConfig)

    void readItemDescriptions(const QString language);
    void loadData();

    static const QString SYSTEM_SHARED_DIR;
    static const QString SYSTEM_CONFIG_DIR;

    QString myCountry;
    QString myLanguage;
    QHash<QString,QString> myItemDescriptions;
    QStringList myCurrentEntries;
    bool loadedData;

protected:
    QStringList runQuery(const QString file_name, const QString query_string);
    const QString getSystemConfigDir();
    const QString getUserConfigDir();

    int myMaxEntries;
    QString myResourceQuery;
    QString myConfigQuery;
    QString myConfigFilePath;
};

#endif // FBCONFIG_H
