/****************************************************************************
**
** Copyright (C) 2010  Aimone Davide realsportcars@hotmail.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef PHONEBOOK_H
#define PHONEBOOK_H

#include <QWidget>
#include <QContactManager>
#include <QContactFetchRequest>
#include <QListWidgetItem>

QTM_USE_NAMESPACE

namespace Ui {
    class PhoneBook;
}

class PhoneBook : public QWidget
{
    Q_OBJECT

public:
    explicit PhoneBook(QWidget *parent = 0);
    ~PhoneBook();
    void updateContactsList(QString *sFilterText);

private:
    Ui::PhoneBook *ui;
    QList<QString> m_contacts;
    QContactFetchRequest *m_fetchRequest;
    void loadContacts();
    QContactManager *m_availableManagers;
    void open();

private slots:
    void contactsReady();
    void contactSelected(QListWidgetItem* item);

signals:
    void addRecipient(const QString sPhone, const QString sName);

};

#endif // PHONEBOOK_H
