/****************************************************************************
**
** Copyright (C) 2010  Aimone Davide realsportcars@hotmail.com
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#include "keyboard.h"
#include <QSet>
#include <QPushButton>
#include <QDebug>

const QString Keyboard::MOVERIGHT = "MR";
const QString Keyboard::MOVELEFT = "ML";
const QString Keyboard::NEXTWORD = "NW";
const QString Keyboard::PREVWORD = "PW";
const QString Keyboard::DELETE = "\b";
const QString Keyboard::NEWLINE = "\n";
const QString Keyboard::SPACE = " ";

Keyboard::Keyboard(QWidget *parent) :
    QWidget(parent)
{


}

void Keyboard::settingsChanged(int nStyle)
{
    if(isVisible())
        emit inputStyleChanged(nStyle);
}

void Keyboard::updateSettingsMenu(int nActiveKeyboard)
{
    m_settingsMenu->updateMenu(nActiveKeyboard);
}
