/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#ifndef REPOEDIT_H
#define REPOEDIT_H

#include <QDialog>

class Repository;
class AAptInterface;

namespace Ui {
    class RepoEdit;
}

class RepoEdit : public QDialog
{
    Q_OBJECT

public:
	explicit RepoEdit(AAptInterface* apt, Repository* repo, int pos, QWidget *parent = 0);
	virtual ~RepoEdit();

	/*
#ifdef Q_WS_MAEMO_5		// workaround for buggy Qt autorotation
	int exec() {
		QRect r = dynamic_cast<QWidget*>(this->parent())->rect();
		if(r.width() < r.height())
			this->setAttribute(Qt::WA_Maemo5PortraitOrientation);
		int e = QDialog::exec();
		this->setAttribute(Qt::WA_Maemo5AutoOrientation);
		return e;
	}
#endif
	*/

protected:
    void changeEvent(QEvent *e);

private:
	RepoEdit(const RepoEdit& old);
	RepoEdit operator= (const RepoEdit& old);

    Ui::RepoEdit *ui;
	Repository* iRepo;
	int iPos;
	AAptInterface* iAptInterface;
	bool iRevertEnabledTo;


private slots:
	void on_checkBox_Enabled_clicked();
	void on_lineEdit_url_textEdited(QString );
	void on_lineEdit_name_textEdited(QString );
	void on_btn_Delete_clicked();
	void on_btn_OK_clicked();
};

#endif // REPOEDIT_H
