/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#include <QtGui>

#ifdef Q_WS_MAEMO_5
#include <QtMaemo5>
#endif

#include "logview.h"
#include "ui_logview.h"
#include "aaptinterface.h"

LogView::LogView(QByteArray text, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::LogView)
{
    ui->setupUi(this);

	QFont f = ui->plainTextEdit->font();
	f.setPointSize( f.pointSize()-2 );

	ui->plainTextEdit->setFont(f);

	QString t = text;
	QStringList lines = t.split('\n');

	if( lines.count()>100 )
		ui->label->setText("Showing last 100 lines");

	while( lines.count()>100 )
		lines.removeFirst();
	lines << "" << "" << "" << "" << "";

	ui->plainTextEdit->setPlainText("");
	ui->plainTextEdit->appendPlainText(lines.join("\n"));
}

LogView::~LogView()
{
    delete ui;
}

int LogView::exec()
{
#ifdef Q_WS_MAEMO_5		// workaround for buggy Qt autorotation
	QRect r = dynamic_cast<QWidget*>(this->parent())->rect();
	if(r.width() < r.height())
		this->setAttribute(Qt::WA_Maemo5PortraitOrientation);
#endif
	show();

	//ui->plainTextEdit->setMinimumHeight( ui->plainTextEdit->contentsRect().height() );
	//ui->scrollAreaWidgetContents->setMinimumHeight( ui->scrollAreaWidgetContents->contentsRect().height() );
	//ui->plainTextEdit->setMinimumHeight( 800 );
	//ui->plainTextEdit->adjustSize();
	//ui->scrollAreaWidgetContents->adjustSize();

	// taken from a Qt example, should auto-resize the textedit
	QTextDocument *doc = ui->plainTextEdit->document();
	QSize s = doc->size().toSize();
	if (ui->plainTextEdit)
		s.setHeight((s.height() + 1) * ui->plainTextEdit->fontMetrics().lineSpacing());
	const QRect fr = ui->plainTextEdit->frameRect();
	const QRect cr = ui->plainTextEdit->contentsRect();
	ui->plainTextEdit->setMinimumHeight(qMax(70, s.height() + (fr.height() - cr.height() - 1)));

	int e = QDialog::exec();

#ifdef Q_WS_MAEMO_5		// workaround for buggy Qt autorotation
	this->setAttribute(Qt::WA_Maemo5AutoOrientation);
#endif
	return e;
}

void LogView::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void LogView::on_btnClear_clicked()
{
	QFile logfile(KLogFile);
	logfile.remove();

	accept();
}

void LogView::on_btnCopy_clicked()
{
	ui->plainTextEdit->selectAll();
	ui->plainTextEdit->copy();

	QMaemo5InformationBox::information ( this, "Copied" );
}
