/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#include "blacklistselect.h"
#include "ui_blacklistselect.h"
#include "package.h"

BlacklistSelect::BlacklistSelect(Package* pkg, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::BlacklistSelect)
{
    ui->setupUi(this);
	iPkg = pkg;

	if( iPkg->blacklisted() == BlacklistNone ) {
		ui->label->setText("This package has not been blacklisted");
		ui->pushButton_Restore->setEnabled(false);
	} else if( iPkg->blacklisted() == BlacklistThis ) {
		ui->label->setText("This version of the package has been blacklisted");
		ui->pushButton_This->setEnabled(false);
	} else if( iPkg->blacklisted() == BlacklistAll ) {
		ui->label->setText("All versions of this package have been blacklisted");
		ui->pushButton_Forever->setEnabled(false);
	}

	if( iPkg->isInstalled() )
		ui->pushButton_This->setEnabled(false);
}

BlacklistSelect::~BlacklistSelect()
{
    delete ui;
}

void BlacklistSelect::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void BlacklistSelect::on_pushButton_Forever_clicked()
{
	iPkg->setBlacklisted( BlacklistAll );
	accept();
}

void BlacklistSelect::on_pushButton_This_clicked()
{
	iPkg->setBlacklisted( BlacklistThis );
	accept();
}

void BlacklistSelect::on_pushButton_Restore_clicked()
{
	iPkg->setBlacklisted( BlacklistNone );
	accept();
}
