#ifndef SORTSELECTOR_H
#define SORTSELECTOR_H

#include <QDialog>
#include "packageview.h"

namespace Ui {
    class SortSelector;
}

class SortSelector : public QDialog
{
    Q_OBJECT

public:
	explicit SortSelector(PackageView::sortOrder currOrder, QWidget *parent = 0);
    ~SortSelector();
#ifdef Q_WS_MAEMO_5		// workaround for buggy Qt autorotation
	int exec() {
		QRect r = dynamic_cast<QWidget*>(this->parent())->rect();
		if(r.width() < r.height())
			this->setAttribute(Qt::WA_Maemo5PortraitOrientation);
		int e = QDialog::exec();
		this->setAttribute(Qt::WA_Maemo5AutoOrientation);
		return e;
	}
#endif
	PackageView::sortOrder selectedOperation();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::SortSelector *ui;
};

#endif // SORTSELECTOR_H
