/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#include <QtGui>
#include "dimmer.h"

dimmer::dimmer(QWidget *parent) :
    QWidget(parent)
{
	iParent = parent;
	iAlpha = 205;
	iLayout = new QVBoxLayout(this);
	iLabel = new QLabel(this);
	iLabel->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
	iLabel->setAlignment(Qt::AlignCenter);
	iLayout->addWidget(iLabel);
	iBusy = false;
	iAnim = 0;
	iAnimDir = 1;
	iAnimY = this->rect().height()-this->rect().height()/4;
	iProgress = -1;

	iTimer = new QTimer(this);
	connect(iTimer,SIGNAL(timeout()),this,SLOT(timerEvent()));

	connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));

	hide();
}

void dimmer::paintEvent(QPaintEvent *)
{
	QPainter painter(this);
	QColor dim("black");
	dim.setAlpha(iAlpha);
	painter.setPen(dim);
	painter.setBrush(dim);
	painter.drawRect(rect());

	painter.setBrush( QApplication::palette().color(QPalette::Highlight) );

	int step = 15;
	int animMax = 10;

	if( iProgress == -1 ) {
		painter.drawEllipse(QPoint(rect().left()+(rect().width()/2-(animMax*step)/2)+iAnim*step,
							iAnimY), 10, 10);
	}

	iAnim += iAnimDir;
	if( iAnim>animMax )
		iAnimDir=-1;
	if( iAnim==-1 )
		iAnimDir=1;

	if( iProgress >= 0 ) {
		if( iProgress>100 )
			iProgress = 100;

		painter.setBrush( QApplication::palette().color(QPalette::Window) );
		painter.drawRect(rect().left()+30, rect().bottom()-30, rect().right()-rect().left()-60, 10 );
		painter.setBrush( QApplication::palette().color(QPalette::Highlight) );
		painter.setPen(Qt::NoPen);
		int pw = ( rect().right()-rect().left()-60 ) * iProgress / 100;
		painter.drawRect(rect().left()+30, rect().bottom()-30, pw, 10 );
	}
}

void dimmer::timerEvent()
{
	repaint(0,iAnimY-10,rect().width(),22);
}

void dimmer::resizeEvent(QResizeEvent *)
{
	this->resize(iParent->size());
	iLayout->setGeometry(iParent->rect());
	iLayout->setSizeConstraint(QLayout::SetMaximumSize);
	iAnimY = this->rect().height()-this->rect().height()/4;
}

void dimmer::orientationChanged()
{
	resizeEvent(0);
}

void dimmer::dim(QString title, QString message)
{
	iTitle = title;
	iBusy = true;
	iLabel->setText("<font color=\"white\"><b><u>" + iTitle + "</u></b><br><br>" + message + "</font>");
	iProgress = -1;
	iAnim = 0;
	iAnimDir = 1;

	show();
	iTimer->start(250);
}

void dimmer::updateText(QString message)
{
	iLabel->setText("<font color=\"white\"><b><u>" + iTitle + "</u></b><br><br>" + message + "</font>");
}

void dimmer::setProgress(int p_)
{
	iProgress = p_;
	repaint(0,rect().bottom()-30,rect().width(),20);
}

void dimmer::undim()
{
	iBusy = false;
	iTimer->stop();
	hide();
}
