/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#ifndef SETTINGS_H
#define SETTINGS_H

#include <QtGui>

namespace Ui {
    class Settings;
}

class Settings : public QDialog
{
    Q_OBJECT

public:
    explicit Settings(QWidget *parent = 0);
    ~Settings();
	void openWin();

#ifdef Q_WS_MAEMO_5		// workaround for buggy Qt autorotation
	int exec() {
		QRect r = static_cast<QDialog*>(this->parent())->rect();
		if(r.width() < r.height())
			this->setAttribute(Qt::WA_Maemo5PortraitOrientation);
		int e = QDialog::exec();
		this->setAttribute(Qt::WA_Maemo5AutoOrientation);
		return e;
	}
#endif

	QSettings* qsettings() { return iQSettings; }

protected:
    void changeEvent(QEvent *e);

private:
    Ui::Settings *ui;
	QSettings* iQSettings;

private slots:
	void on_btn_OK_clicked();
};

#endif // SETTINGS_H
