/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtCore>
#include <QMainWindow>
#include "aptinterface.h"

class AptInterface;
class PackageView;
class Uninstall;
class Dialog;
class dimmer;
class RepoView;


namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
	enum operation { OpNone, OpInstall, OpUninstall, OpUpgrade, OpClean };

    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();
	void operationFinished(AptInterface::aptMode lastMode_, bool success_, QString msg_);
	void busyDialog(bool visible_, QString title="", QString text="");
	void setOperation(operation op_) { iOperation=op_; }
	void closeEvent(QCloseEvent *event);

public slots:
	void on_btnUpdate_clicked();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::MainWindow *ui;
	AptInterface* iAptInterface;
	PackageView* iWinPackageView;
	RepoView* iWinRepoView;
	Dialog* iDlgBusy;
	operation iOperation;
	dimmer* iDimmer;
	bool iReposAutoUpdating;
	bool iUpgradeAutoUpdate;

private slots:
	void on_btnRepos_clicked();
	void on_actionClean_triggered();
	void on_actionAbout_triggered();
	void on_btnUpgrade_clicked();
	void on_btnListInstallable_clicked();
	void on_btnListInstalled_clicked();
};

#endif // MAINWINDOW_H
