/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#include <QtGui>
#include "dimmer.h"

dimmer::dimmer(QWidget *parent) :
    QWidget(parent)
{
	iParent = parent;
	iAlpha = 215;
	iLayout = new QVBoxLayout(this);
	iLabel = new QLabel(this);
	iLabel->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
	iLabel->setAlignment(Qt::AlignCenter);
	iLayout->addWidget(iLabel);
	iBusy = false;
	iTimer = new QTimer(this);
	connect(iTimer,SIGNAL(timeout()),this,SLOT(repaint()));
	iAnim = 0;
	iAnimDir = 1;
	hide();
}

void dimmer::paintEvent(QPaintEvent *)
{
	QPainter painter(this);
	QColor dim("black");
	dim.setAlpha(iAlpha);
	painter.setPen(dim);
	painter.setBrush(dim);
	painter.drawRect(this->rect());

	painter.setBrush( QApplication::palette().color(QPalette::Highlight) );

	int step = 15;
	int animMax = 10;

	painter.drawEllipse(QPoint(this->rect().left()+(this->rect().width()/2-(animMax*step)/2)+iAnim*step,
							   this->rect().height()-this->rect().height()/4), 10, 10);

	iAnim += iAnimDir;
	if( iAnim>animMax )
		iAnimDir=-1;
	if( iAnim==-1 )
		iAnimDir=1;

}

void dimmer::resizeEvent(QResizeEvent *)
{
	this->resize(iParent->size());
	iLayout->setGeometry(iParent->rect());
	iLayout->setSizeConstraint(QLayout::SetMaximumSize);
}

void dimmer::dim(QString title, QString message)
{
	iBusy = true;
	iLabel->setText("<font color=\"white\"><b><u>" + title + "</u></b><br><br>" + message + "</font>");
	show();
	iAnim = 0;
	iAnimDir = 1;
	iTimer->start(250);
}

void dimmer::undim()
{
	iBusy = false;
	iTimer->stop();
	hide();
}

