/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#include "filterselect.h"
#include "ui_filterselect.h"

FilterSelect::FilterSelect(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::FilterSelect)
{
    ui->setupUi(this);
	connect(ui->listWidget,SIGNAL(itemActivated(QListWidgetItem*)),this,SLOT(accept()));
}

FilterSelect::~FilterSelect()
{
    delete ui;
}

void FilterSelect::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void FilterSelect::setList(QStringList labels, int selected)
{
	ui->listWidget->addItems(labels);
	ui->listWidget->item(selected)->setSelected(true);
}

int FilterSelect::selection()
{
	for( int i=0; i<ui->listWidget->count(); i++)
	{
		if( ui->listWidget->item(i)->isSelected() )
			return i;
	}

	return 0;
}
