#include "halkeyboards.h"

#include <QTextStream>
#include <QStringList>
#include <QMaemo5InformationBox>

#include <QDebug>

#include <stdio.h>
#include <errno.h>

HalKeyboards::HalKeyboards(QWidget * parent)
{
    FILE * fp=popen("hal-find-by-capability --capability input.keyboard","r");
    if(fp)
    {
	QString udi;
	QTextStream udi_stream( fp, QIODevice::ReadOnly );

	while(!(udi = udi_stream.readLine()).isNull())
	{
	    if(udi.isEmpty())
		continue;
	    FILE * fpudi=popen(QString("hal-get-property --udi %1 --key info.product").arg(udi).toLatin1(),"r");
	    if(fpudi)
	    {
		QTextStream kbd_udi_list( fpudi, QIODevice::ReadOnly );

		QString udi_info_product=kbd_udi_list.readLine();

		//qDebug()<<udi_info_product;

		if(     (!udi_info_product.isNull())
			&&
			(!udi_info_product.isEmpty())
			&&
			(udi_info_product != "omap_twl4030keypad") //do not include internal keyboard
			)
		{

		    insert(udi_info_product,udi);
		}

		pclose(fpudi);
	    }
	    else
	    {
		QMaemo5InformationBox::information(parent, QString("hal-get-property error %1<br>%2").arg(errno).arg(strerror(errno)),
							QMaemo5InformationBox::NoTimeout);
		break;
	    }
	}

	pclose(fp);
    }
    else
	QMaemo5InformationBox::information(parent, QString("hal-find-by-capability error %1<br>%2").arg(errno).arg(strerror(errno)),
						QMaemo5InformationBox::NoTimeout);

}
