#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui>
#include <QtGui/QX11Info>
#include <X11/Xlib.h>

#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>

#include <QDomDocument>

#include "basexmlparser.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QDialog
{
    Q_OBJECT

public:
    MainWindow(Window parent, bool user);
    ~MainWindow();

protected:
    void showEvent(QShowEvent *se)
    {
        if (m_parent != None)
        {
            XSetTransientForHint(QX11Info::display(), winId(), m_parent);
        }
        QDialog::showEvent(se);
    }

    bool ParseHalFdi();

    void setKbdModelVB(const QString & kbdModel = QString());
    void setFirstLanguageVB(const QString & kbdLanguage = QString());
    void setSecondLanguageVB(const QString & kbdLanguage = QString());
    void setLanguageVariantVB(const QString & kbdLanguage,const QString & var,QMaemo5ValueButton * vb,QStandardItemModel * model);
    void setLayoutVB(const QString & keyboard);
    void setLanguageSwitchVB(const QString & switchKey = QString());

    void saveCurrentKeyboard();

    void makeFdi();

    //contains keyboards found in "/usr/share/hal/fdi/policy/20thirdparty/99-x11-external-keyboard.fdi"
    //key - product id(i.e. keyboard name), - value [key- key_value, value - attribute text,...]

    QMap< QString, QMap<QString,QString> > m_halFdiProducts;
    Window m_parent;

    QStandardItemModel * m_languageModel;
    QStandardItemModel * m_language1VariantModel;
    QStandardItemModel * m_language2VariantModel;
    QStandardItemModel * m_descriptionModel;
    QStandardItemModel * m_layoutModel;
    QStandardItemModel * m_languageSwitchModel;
    BaseXMLParser * m_baseXMLParser;

    void setLayoutModel();
    void setLanguageSwitchModel();
    void setLanguageModel();
    int  setLanguageVariantModel(const QString & language,const QString & v,QStandardItemModel * model);

private:
    Ui::MainWindow *ui;

#define KBD_NUM_ATTR 6
    QMap <  QString /*Keyboard*/,
            QStringList
            /*[
                    Layout,
                    1st language,
                    1st language variant,
                    2nd language,
                    2nd language variant,
                    switch key
            ]*/
    > m_Keyboards;

private slots:
    void selectKbdModel(const QString & kbdmodel);
    void setFirstLanguage(const QString & model);
    void setSecondLanguage(const QString & model);
    void setFirstLanguageVariant(const QString & language,const QString &variant);
    void setSecondLanguageVariant(const QString & language,const QString &variant );
    void on_vbExternaKeyboard_clicked();

    void on_buttonBox_accepted();
};

#endif // MAINWINDOW_H
