/*
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Xavier Claessens <xavier.claessens@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "config.h"

#include <libosso-abook/osso-abook.h>

#include "ecs-match.h"
#include "ecs-window.h"

typedef struct {
  OssoABookMenuExtension parent_instance;
} ExtendedContactsSearch;

typedef struct {
  OssoABookMenuExtensionClass parent_class;
} ExtendedContactsSearchClass;

G_GNUC_INTERNAL GType extended_contacts_search_get_type (void) G_GNUC_CONST;

OSSO_ABOOK_DEFINE_MENU_PLUGIN (ExtendedContactsSearch,
    extended_contacts_search,
    OSSO_ABOOK_TYPE_MENU_EXTENSION,
    g_type_module_use (module);,);

/* HACK: I'm terribly sorry, but I copy/pasted private struct of
 * GtkTreeModelFilter, see override_visible_func_idle_cb() below */
struct _GtkTreeModelFilterPrivate
{
  gpointer root;
  gint stamp;
  guint child_flags;
  GtkTreeModel *child_model;
  gint zero_ref_count;

  GtkTreePath *virtual_root;

  GtkTreeModelFilterVisibleFunc visible_func;
  gpointer visible_data;
  GDestroyNotify visible_destroy;

  gint modify_n_columns;
  GType *modify_types;
  GtkTreeModelFilterModifyFunc modify_func;
  gpointer modify_data;
  GDestroyNotify modify_destroy;

  gint visible_column;

  gboolean visible_method_set;
  gboolean modify_func_set;

  gboolean in_row_deleted;
  gboolean virtual_root_deleted;

  /* signal ids */
  guint changed_id;
  guint inserted_id;
  guint has_child_toggled_id;
  guint deleted_id;
  guint reordered_id;
};

static void
extended_search_cb (GtkWidget *widget,
    OssoABookMenuExtension *self)
{
  GtkWidget *window;

  window = ecs_window_new ();
  gtk_widget_show (window);
}

static gboolean
visible_func (GtkTreeModel *model,
    GtkTreeIter *iter,
    gpointer user_data)
{
  OssoABookFilterModel *filter = user_data;
  const gchar *text;

  text = osso_abook_filter_model_get_text (filter);

  return ecs_match_visible_func (OSSO_ABOOK_LIST_STORE (model), iter, text);
}

static GtkWidget *
lookup_child_with_type (GtkWidget *widget,
    GType type)
{
  if (g_type_is_a (G_OBJECT_TYPE (widget), type))
    return widget;

  if (GTK_IS_CONTAINER (widget))
    {
      GList *childs;

      childs = gtk_container_get_children (GTK_CONTAINER (widget));
      while (childs != NULL)
        {
          GtkWidget *w;

          w = lookup_child_with_type (childs->data, type);
          if (w != NULL)
            {
              g_list_free (childs);
              return w;
            }

          childs = g_list_delete_link (childs, childs);
        }
    }

  return NULL;
}

static gboolean
override_visible_func_idle_cb (gpointer self)
{
  GtkWindow *window;
  GtkWidget *view;
  OssoABookFilterModel *filter;
  GtkTreeModelFilterPrivate *priv;

  window = osso_abook_menu_extension_get_parent (self);

  /* HACK: recurse through all its childs to find the treeview */
  view = lookup_child_with_type (GTK_WIDGET (window),
      OSSO_ABOOK_TYPE_TREE_VIEW);
  g_assert (view != NULL);

  /* HACK: We can't use osso_abook_filter_model_set_visible_func() because it
   * doesn't completely override the visible func. It only let us hide more
   * rows, but not make visible rows that doesn't match the default function.
   *
   * So we override the visible func at the GtkTreeModelFilter level. But it
   * doesn't support changing its visible func, so we have to force it in a
   * terribly ugly way.
   */
  filter = osso_abook_tree_view_get_filter_model (OSSO_ABOOK_TREE_VIEW (view));
  priv = GTK_TREE_MODEL_FILTER (filter)->priv;
  if (priv->visible_destroy)
    priv->visible_destroy (priv->visible_data);
  priv->visible_destroy = NULL;
  priv->visible_data = NULL;
  priv->visible_func = NULL;
  priv->visible_method_set = FALSE;

  gtk_tree_model_filter_set_visible_func (GTK_TREE_MODEL_FILTER (filter),
      visible_func, filter, NULL);

  return FALSE;
}

static void
extended_contacts_search_init (ExtendedContactsSearch *self)
{
  /* HACK: We want to override the visible func of the main view. We know the
   * parent window of this menu extention is the main window. But the main
   * window's menu is created before its childs widgets, so we have to
   * introspect the window in idle callback to find the tree view.
   */
  g_idle_add (override_visible_func_idle_cb, self);
}

static OssoABookMenuEntry entries[] = {
  { "Extended Search", 0, 0, G_CALLBACK (extended_search_cb), NULL },
};

static const OssoABookMenuEntry *
get_menu_entries (OssoABookMenuExtension *self)
{
  return entries;
}

static int
get_n_menu_entries (OssoABookMenuExtension *self)
{
  return G_N_ELEMENTS (entries);
}

static void
extended_contacts_search_class_init (ExtendedContactsSearchClass *klass)
{
  OssoABookMenuExtensionClass *menu_extension_class;

  menu_extension_class = OSSO_ABOOK_MENU_EXTENSION_CLASS (klass);
  menu_extension_class->get_n_menu_entries = get_n_menu_entries;
  menu_extension_class->get_menu_entries = get_menu_entries;
  menu_extension_class->name =  OSSO_ABOOK_MENU_NAME_MAIN_VIEW;
}

static void
extended_contacts_search_class_finalize (ExtendedContactsSearchClass *klass)
{
}
