// Copyright (C) 2010 Jaakko Kyro <jkyro@korjaussarja.net>
// This file is licenced under GPL, see COPYING
// for full licence information
#include "evemodel.h"
#include "eveaccount.h"
#include <QNetworkAccessManager>
#include <QXmlStreamReader>
#include <QUrl>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QtDebug>
#include <QSettings>

static QUrl imageUrl("http://img.eve.is/serv.asp");

EveModel::EveModel(QObject *parent) :
    QObject(parent),
    m_userId(0),
    m_selectedIndex(-1)
{

}

void EveModel::fetchAccounts()
{
    QNetworkRequest fetch(QUrl(QString("http://api.eveonline.com/account/Characters.xml.aspx?apiKey=%1&userID=%2")
                               .arg(apiKey())
                               .arg(userId())));
    m_reply = mgr.get(fetch);
    qDebug() << "Fetch accounts, reply " << m_reply;
    connect(m_reply,SIGNAL(finished()),this,SLOT(replyReady()));
    connect(m_reply,SIGNAL(error(QNetworkReply::NetworkError)),this,SLOT(networkError(QNetworkReply::NetworkError)));
}

void EveModel::replyReady()
{
    if (m_reply->error()) {
        qDebug() << "Failed! " << m_reply->errorString();
        return;
    }
    QByteArray reply = m_reply->readAll();
    qDebug() << "Reply ready";
    qDebug() << reply;
    QXmlStreamReader reader(reply);

    reader.readNextStartElement();
    if (reader.error()) {
        qDebug() << "Parse error: " << reader.errorString();
    }
    qDebug() << "Relement: " << reader.name();
    if (reader.name() != "eveapi")
        return;
    reader.readNextStartElement();
    if (reader.error()) {
        qDebug() << "Parse error: " << reader.errorString();
    }
    qDebug() << "1 element: " << reader.name();
    if (reader.name() != "currentTime")
        return;
    reader.readNextStartElement();
    reader.readNextStartElement();
    if (reader.error()) {
        qDebug() << "Parse error: " << reader.errorString();
    }
    qDebug() << "2 element: " << reader.name();
    if (reader.name() != "result")
        return;
    reader.readNextStartElement();
    qDebug() << "Relement: " << reader.name();
    if (reader.name() != "rowset")
        return;
    reader.readNextStartElement();
    qDebug() << "3 element: " << reader.name();
    if (reader.name() == "row")
        m_characters.clear();
    while (reader.name() == "row") {
        EveCharacter chara;
        if (!chara.fromXml(reader)) {
            qDebug() << "Error parsing character data";
            break;
        }
        m_characters.append(chara);
        reader.readNextStartElement(); // end current row
        reader.readNextStartElement(); // start next row
    }
    m_reply->deleteLater();

    emit accountsReady();
}

void EveModel::networkError(QNetworkReply::NetworkError error)
{
    qDebug() << "Network error " << error;
}

EveCharacter *EveModel::selectedCharacter()
{
    qDebug() << "Index:" << m_selectedIndex;
    if (m_selectedIndex >= 0 && m_selectedIndex < m_characters.size())
        return &(m_characters[m_selectedIndex]);
    return NULL;
}

bool EveModel::loadSettings()
{
    QSettings settings("net.korjaussarja","evehomescreen");
    qDebug() << "Load settings";
    // Absence of this key means first time load
    if (!settings.contains("account/apiKey")) {
        qDebug() << "No saved settings";
        return false;
    }
    setApiKey(settings.value("account/apiKey").toString());
    setUserId(settings.value("account/userId").toInt());

    int size = settings.beginReadArray("characters");
    for (int i = 0;i<size;++i) {
        settings.setArrayIndex(i);
        EveCharacter character;
        character.name = settings.value("characterName").toString();
        character.characterId = settings.value("characterId").toInt();
        character.corpName = settings.value("corpName").toString();
        character.corpId = settings.value("corpId").toInt();

        if (settings.contains("characterIcon")) {
            character.characterIcon = new QPixmap(settings.value("characterIcon").value<QPixmap>());
        }
        characters().append(character);
    }
    settings.endArray();
    m_selectedIndex = settings.value("account/selectedCharacter",-1).toInt();
    return true;
}

// TODO
void EveModel::saveSettings()
{
    qDebug() << "Save";
    QSettings settings("net.korjaussarja","evehomescreen");
    settings.setValue("account/apiKey",apiKey());
    settings.setValue("account/userId",userId());
    if (m_selectedIndex >= 0 && m_selectedIndex < characters().size())
        settings.setValue("account/selectedCharacter",m_selectedIndex);
    settings.beginWriteArray("characters");

    for (int i=0;i<characters().size();++i) {
        settings.setArrayIndex(i);
        settings.setValue("characterName", characters().at(i).name);
        settings.setValue("characterId", characters().at(i).characterId);
        settings.setValue("corpName", characters().at(i).corpName);
        settings.setValue("corpId", characters().at(i).corpId);
        if (characters().at(i).characterIcon != NULL) {
            settings.setValue("characterIcon",*(characters().at(i).characterIcon));
        }
    }
    settings.endArray();
}
