// Copyright (C) 2010 Jaakko Kyro <jkyro@korjaussarja.net>
// This file is licenced under GPL, see COPYING
// for full licence information
#ifndef WIDGET_H
#define WIDGET_H

#include <QtGui/QLabel>
#include <QNetworkConfigurationManager>
#include <QSharedPointer>

QTM_USE_NAMESPACE

class EveCharacter;
class EveSettingsDialog;
class EveSkillTraining;
class SkillTree;
class EveModel;

class Widget : public QLabel
{
    Q_OBJECT

public:
    Widget(QWidget *parent = 0);
    ~Widget();
    QSize sizeHint() const;

public slots:
    void showSettingsDialog();
    void paintEvent(QPaintEvent *event);
    void skillReady();
    void onlineStateChanged(bool online);
    void loadTraining();
    void trainingLoaded();
private:
    EveSettingsDialog *m_settings;
    EveSkillTraining *m_training;
    QNetworkConfigurationManager *m_net;
    SkillTree *m_skills;
    QSharedPointer<EveModel> m_model;
    QTimer *m_timer;
};

#endif // WIDGET_H
