#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# eSpeakCaller for Maemo 5.
#
# Author: Arto Rusanen
# Date: 2010.03.23
#
# File: espeakcaller.py
# Version: 0.2
# 
# Special thanks to: 
#    Original eSpeak project: http://espeak.sourceforge.net/
#    Kaj-Michael Lang (eSpeak) eSpeak package :)
#    Nick Leppänen Larsson (fMMS) phonebook code
#    V@s3K (pyCallBlocker) skeleton for this program
#

daemonFile = '/opt/espeakcaller/espeakcaller-daemon.py'
pidFile = '/tmp/espeakcaller_pid.txt'
cfgFile = "~/.espeakcaller/espeakcaller.conf"


from PyQt4 import QtGui, QtCore
from PyQt4.QtCore import SIGNAL, SLOT
import sys
import subprocess
import os.path
from espeakcaller_ui import Ui_MainWindow
from espeakcaller_about import Ui_Dialog


class eSpeakCaller(QtGui.QMainWindow):
    # Load our new ultra awesome GUI.
    # Made with Qt Designer :)
    def __init__(self, parent=None):
        QtGui.QWidget.__init__(self, parent)
        self.ui = Ui_MainWindow()
        self.ui.setupUi(self)
        self.loadsettings()
    
    
    # Load settings.
    def loadsettings(self):
        try:
            tmpStr = ""
            pdFile = open(os.path.expanduser(cfgFile), 'r')
            tmpStr = pdFile.readline().strip() # We don't need first line here. This is command for daemon.
            tmpStr = pdFile.readline().strip() # Read Unknown caller name
            if not tmpStr == "":
                self.ui.lineUnCaller.setText(tmpStr)
            tmpStr = pdFile.readline().strip() # Read spoken language
            if not tmpStr == "":
                self.ui.comboLang.setCurrentIndex(int(tmpStr))
            tmpStr = pdFile.readline().strip() # Read additional parameters
            if not tmpStr == "":
                self.ui.lineAParams.setText(tmpStr)
            tmpStr = pdFile.readline().strip() # Read spoken line
            if not tmpStr == "":
                self.ui.lineSay.setText(tmpStr)
            pdFile.close()
            if os.path.exists(pidFile):
                self.ui.checkEnabled.setCheckState(-1)
        except:
            pass
        
    # Save settings to espeakcaller.conf
    def SaveSettings(self):
        # Check if we need to create directory
        cfgTmp = os.path.expanduser(cfgFile)
        if not os.path.exists(os.path.dirname(cfgTmp)):
            os.makedirs(os.path.dirname(cfgTmp))
            
        if os.path.exists(cfgTmp): 
            os.remove(cfgTmp) # Remove old settings.
            
        
        pdFile = open(cfgTmp, 'w')
        pdFile.write(str(self.GeteSpeakCommand()) + '\n')
        pdFile.write(str(self.ui.lineUnCaller.displayText()) + '\n')
        pdFile.write(str(self.ui.comboLang.currentIndex()) + '\n')
        pdFile.write(str(self.ui.lineAParams.displayText()) + '\n')
        pdFile.write(str(self.ui.lineSay.displayText()) + '\n')
        pdFile.close()
        
        
    # Generates hopefully valid eSpeak command.
    def GeteSpeakCommand(self):
        # Damn eSpeak supports lot of langueages
        sLang=['',' -ven',' -ven-us',' -ven-sc',' -vaf',' -vbs',' -vca',' -vcs',' -vde',' -vel',' -veo',' -ves',' -ves-la',' -vfi',' -vfr',' -vhr',' -vhu',' -vit',' -vku',' -vlv',' -vpl',' -vpt',' -vpt-pt',' -vro',' -vsk',' -vsr',' -vsv',' -vsw',' -vta',' -vtr',' -vzh']
        tmpCmd = "espeak " + sLang[self.ui.comboLang.currentIndex()] + " "
        tmpCmd = tmpCmd + self.ui.lineAParams.displayText() + " "
        tmpCmd = tmpCmd + "'" + self.ui.lineSay.displayText() + "'"
        
        return tmpCmd
       
       
    # Test eSpeak 
    def slotTest(self):
        tmpS = self.GeteSpeakCommand().replace("%name%", self.ui.lineUnCaller.displayText())
        #print tmpS
        subprocess.Popen(str(tmpS), shell=True)
        
        
    # Apply settings
    def slotApply(self):
        #self.restartDaemon()
        self.StopDaemon()
        self.SaveSettings()
        if self.ui.checkEnabled.isChecked():
            self.StartDaemon()
        
    # Show new cool About box :) (well not really that cool...)
    def slotAbout(self):
        AboutBox = QtGui.QDialog()
        AboutBox.ui = Ui_Dialog()
        AboutBox.ui.setupUi(AboutBox)
        AboutBox.show()
        AboutBox.exec_()
        
        
    # Stop Daemon
    def StopDaemon(self):
        try:
            pdFile = open(pidFile, 'r+')
            pid = pdFile.readline().strip()
            subprocess.Popen("kill -9 " + str(pid), shell=True)
            pdFile.close()
            os.remove(pidFile)
        except:
            pass
    
    # Start Daemon    
    def StartDaemon(self):
        self.StopDaemon() # Just in case...
        
        proc = subprocess.Popen("python2.5 " + daemonFile + " &", shell=True)
        
        pdFile = open(pidFile, 'w+')
        pdFile.write(str(proc.pid + 1))
        pdFile.close()

# Execution
if __name__ == "__main__":
    app = QtGui.QApplication(sys.argv)
    myapp = eSpeakCaller()
    myapp.show()
    sys.exit(app.exec_())

        
