#ifndef SYSTEMPLAYER_H
#define SYSTEMPLAYER_H

#include <QObject>
#include <QMap>
#include <QString>
#include <QVariant>

#ifdef Q_WS_MAEMO_5
    #include "backends/mafw/mafwrendereradapter.h"
#endif

#define SYSTEM_PLAYER_SONG_TITLE "title"
#define SYSTEM_PLAYER_SONG_ALBUM "album"
#define SYSTEM_PLAYER_SONG_ARTIST "artist"

class SystemPlayer : public QObject
{
    Q_OBJECT
public:
    explicit SystemPlayer(QObject *parent = 0);
    enum PlaybackState {PlayingState,
                        StoppedState,
                        PausedState,
                        UnknownState};
    SystemPlayer::PlaybackState state();

signals:
    void stateChanged(SystemPlayer::PlaybackState state);
    void metadataChanged(QMap<QString,QVariant> metadata);

public slots:
    void play();
    void pause();
    void stop();
    void resume();
    void next();
    void previous();

private:
#ifdef Q_WS_MAEMO_5
    MafwRendererAdapter *m_renderer;
    int m_mafwState;
#endif
    SystemPlayer::PlaybackState m_state;

private slots:
#ifdef Q_WS_MAEMO_5
    // Internal mafw state handling
    void mafwStateChanged(int mafwState);
    void onGotMafwState(MafwPlaylist*, uint, MafwPlayState, const char*, QString);
    void onGotMafwMetadata(GHashTable*,QString,QString);
#endif
};

#endif // SYSTEMPLAYER_H
