/*
 * This file is part of edicom application
 *
 * Copyright (C) 2010 Sugnan Prabhu S <sugnan.prabhu@gmail.com>
 *
 * Contact: Sugnan Prabhu S <sugnan.prabhu@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#ifndef TERMINAL_H
#define TERMINAL_H

#include <QtGui/QMainWindow>
#include <QTextStream>
#include <QFileDialog>
#include "exethread.h"
#include "outputthread.h"
#include "scannerthread.h"

namespace Ui {
    class Terminal;
}

class Terminal : public QMainWindow {
    Q_OBJECT
public:
    Terminal(QWidget *parent = 0);
    ~Terminal();

public:
    OutputThread outputThread;
    ExeThread exeThread;
    ScannerThread scanfThread;
    int charCountBefourScanf;
    int fl;
    int fpointer;
    int endPoint;
signals:
    void killed();
    void terminalExiting();
public slots:
    void updateDisplay(QString str);
    void killer();
    void showScanDialog();
    void returnPressed();
    void closeEvent(QCloseEvent *event);

protected:
    void changeEvent(QEvent *e);
    bool eventFilter(QObject *obj, QEvent *ev);

public:
    Ui::Terminal *m_ui;
};

#endif // TERMINAL_H
