#include<QDir>
#include<QSettings>

#include "ConfigDialog.h"
#include "ui_ConfigDialog.h"

ConfigDialog::ConfigDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::ConfigDialog)
{
    ui->setupUi(this);
    ui->generalSettings->setIcon(QIcon(QPixmap(":images/generalsettings.png").scaled(400,400)));
    ui->editorSettings->setIcon(QIcon(QPixmap(":images/pagesettings.png").scaled(400,400)));
    this->setWindowTitle("Settings");
    ui->editorSettings->hide();

    ui->buildLineEdit->setInputMethodHints(Qt::ImhNoAutoUppercase);
    ui->argumentsLineEdit->setInputMethodHints(Qt::ImhNoAutoUppercase);

    QSettings settings("SJCE", "edicom");
    settings.beginGroup("BuildSettings");
    ui->buildLineEdit->setText(settings.value("build").toString());
    ui->argumentsLineEdit->setText(settings.value("arguments").toString());
    ui->enableSettings->setChecked(settings.value("enable").toBool());
    settings.endGroup();
    connect(ui->enableSettings,SIGNAL(clicked(bool)),this,SLOT(enableSettingsToggled(bool)));
    enableSettingsToggled(ui->enableSettings->isChecked());
}

ConfigDialog::~ConfigDialog()
{
    QSettings settings("SJCE", "edicom");
    settings.beginGroup("BuildSettings");
    settings.setValue("build", ui->buildLineEdit->text());
    settings.setValue("arguments", ui->argumentsLineEdit->text());
    settings.setValue("enable", ui->enableSettings->isChecked());
    settings.endGroup();
    delete ui;
}

void ConfigDialog::enableSettingsToggled(bool value)
{
    ui->buildLineEdit->setEnabled(value);
    ui->argumentsLineEdit->setEnabled(value);
}
