/*
 * This file is part of edicom application
 *
 * Copyright (C) 2010 Sugnan Prabhu S <sugnan.prabhu@gmail.com>
 *
 * Contact: Sugnan Prabhu S <sugnan.prabhu@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
#include<QMaemo5InformationBox>
#include "ui_logindialog.h"
#include "logindialog.h"
#include "ShareProgramDialog.h"
#include "googledocumentlist.h"
#include "googledocument.h"
#include "googledocumentservice.h"

class GoogleDocumentService;

LoginDialog::LoginDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::LoginDialog)
{
    ui->setupUi(this);
    QMaemo5InformationBox::information(this, "Enter the Username and Password of Google Docs account", QMaemo5InformationBox::DefaultTimeout);
    this->setWindowTitle("Login Dialog");
    ui->userName->setInputMethodHints(Qt::ImhNoAutoUppercase);
    connect(ui->signInButton,SIGNAL(clicked()),this,SLOT(signInButtonClicked()));
    QFile tempFile("/tmp/.pw");
    if(tempFile.exists()) {
        if (tempFile.open(QFile::ReadOnly)){
            ui->userName->setText(QString(tempFile.readLine()));
            ui->passWord->setText(QString(tempFile.readLine()));
            ui->staySigned->setChecked(true);
        }
    }
}

LoginDialog::~LoginDialog()
{
    delete ui;
}
void LoginDialog::signInButtonClicked()
{
    if(ui->userName->text().isEmpty() || ui->passWord->text().isEmpty()) {
        QMaemo5InformationBox::information(this, "One or more fields are Empty", QMaemo5InformationBox::DefaultTimeout);
        return;
    }
    googleDoc = new GoogleDocumentService();
    googleDoc->clientLogin(ui->userName->text(), ui->passWord->text());
    connect(googleDoc, SIGNAL(userAuthenticated(bool)), this, SLOT(authenticated(bool)));
}
void LoginDialog::authenticated(bool value)
{
    if(value==false) {
        QMaemo5InformationBox::information(this, "Invalid Username or Password ", QMaemo5InformationBox::DefaultTimeout);
    }
    else {
        QFile fileTemp("/tmp/.pw");
        if(ui->staySigned->isChecked()) {
            if (fileTemp.open(QFile::WriteOnly | QFile::Truncate)){
                QString temp=ui->userName->text()+"\n"+ui->passWord->text();
                fileTemp.write(temp.toAscii().data());
                fileTemp.close();
           }
        }
        else
            fileTemp.remove();

         shareProgramDialog = new ShareProgramDialog(googleDoc, this);
         this->accept();
         shareProgramDialog->exec();
    }/*
    shareProgramDialog = new ShareProgramDialog(googleDoc, this);
    this->accept();
    shareProgramDialog->exec();*/
}

void LoginDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}
