/*
 * Copyright (C) 2010, Bundyo (bundyo at gmail.com)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

using Gtk; 
using Config; 
using Hildon;
using Mx;

static const string iface = 
"""{
  "MyScene" : {
    "id" : "mainStage",
    "name" : "mainStage",
    "type" : "ClutterStage",
    "width": 800,
    "height": 480,
    "is-default" : true,
    "children" : [
      {
        "id" : "canvas",
        "name" : "canvas",
        "type" : "MxButton",
        "x" : 0, 
        "y" : 0, 
        "width" : 800, 
        "height" : 480
      },
      {
        "id" : "mainImage",
        "name" : "mainImage",
        "type" : "MxButton",
        "x" : 25,
        "y" : 25,
        "width" : 750,
        "height" : 430
      },
      {
        "id" : "mainMirror",
        "name" : "mainMirror",
        "type" : "MxButton",
        "x" : -775,
        "y" : 25,
        "width" : 750,
        "height" : 430
      },
      {
        "id" : "topSlide",
        "name" : "topSlide",
        "type" : "ClutterGroup",
        "x" : -381, 
        "y" : -5, 
        "width" : 380, 
        "height" : 100,
        "children": [
		      {
		        "id" : "topSlideBg",
		        "name" : "topSlideBg",
		        "type" : "MxFrame",
		        "x" : 0, 
		        "y" : 0, 
		        "width" : 380, 
		        "height" : 100
		      },
		      {
		        "id" : "brevButton",
		        "name" : "brevButton",
		        "type" : "MxButton",
		        "x" : 40, 
		        "y" : 20, 
		        "width" : 50, 
		        "height" : 50
		      },
		      {
		        "id" : "backButton",
		        "name" : "backButton",
		        "type" : "MxButton",
		        "x" : 120, 
		        "y" : 20, 
		        "width" : 50, 
		        "height" : 50
		      },
		      {
		        "id" : "forwardButton",
		        "name" : "forwardButton",
		        "type" : "MxButton",
		        "x" : 200, 
		        "y" : 20, 
		        "width" : 50, 
		        "height" : 50
		      },
		      {
		        "id" : "frevButton",
		        "name" : "frevButton",
		        "type" : "MxButton",
		        "x" : 280, 
		        "y" : 20, 
		        "width" : 50, 
		        "height" : 50
		      }
        ]
      },
      {
        "id" : "topLeft",
        "name" : "topLeft",
        "type" : "MxButton",
        "x" : 0, 
        "y" : 0, 
        "width" : 110, 
        "height" : 110
      },
      {
        "id" : "topRight",
        "name" : "topRight",
        "type" : "MxButton",
        "x" : 690,
        "y" : 0,
        "width" : 110,
        "height" : 110
      },
      {
        "id" : "bottomLeft",
        "name" : "bottomLeft",
        "type" : "MxButton",
        "x" : 0, 
        "y" : 370, 
        "width" : 110, 
        "height" : 110
      },
      {
        "id" : "bottomRight",
        "name" : "bottomRight",
        "type" : "MxButton",
        "x" : 690,
        "y" : 370,
        "width" : 110,
        "height" : 110
      }
    ]
  }
}""";

Hildon.Program program;
Osso.Context context;
Clutter.Script script;
unowned Clutter.Actor stage;
bool slide_event;

struct Path { 
	public string name;
	public double x;
	public double y;
	public double dx;
	public double dy;
	public bool visible;
}
struct AnimationPath {
	public double endX;
	public double endY;
}

Path[] paths;
Clutter.Gesture gesture;

//[DBus (name = "org.freedesktop.Echognomix")]
class Echognomix : Hildon.Window {

	static Path? get_path( string path ) {
		
		for ( var i = 0; i < paths.length; i++ ) {
			if (paths[i].name == path)
				return paths[i];
		}
		
		return null;
	}

	static void set_path_visibility ( string path, bool visible ) {
		
		for ( var i = 0; i < paths.length; i++ ) {
			if (paths[i].name == path)
				paths[i].visible = visible;
		}
	}

	static void topLeftClick() {
		var path = get_path( "topSlide" );
		
		unowned Clutter.Actor animated;
		script.get_objects ( path.name, out animated );
	
		Clutter.Geometry geo;
		animated.get_geometry( out geo );
		if (geo.x == path.x) {
			animated.animate( Clutter.AnimationMode.EASE_OUT_SINE, 100, "x", path.x + path.dx * geo.width );
			set_path_visibility( path.name, true );
		} else {
			animated.animate( Clutter.AnimationMode.EASE_IN_SINE, 100, "x", path.x );
			set_path_visibility( path.name, false );
		}
		
	}

	static void mainImageClick() {
		
		if (slide_event) {
			slide_event = false;
			return;
		}
		
		Clutter.Geometry geo;
		for ( var i = 0; i < paths.length; i++ ) {
			unowned Clutter.Actor animated;
			var path = paths[i];
			
			script.get_objects ( path.name, out animated );
			animated.get_geometry( out geo );
			
			if (geo.x == path.x) {
				if (path.name != "topSlide" || path.visible)
					animated.animate( Clutter.AnimationMode.EASE_OUT_SINE, 100, "x", path.x + path.dx * geo.width, "y", path.y + path.dy * geo.height );
			} else
				animated.animate( Clutter.AnimationMode.EASE_IN_SINE, 100, "x", path.x, "y", path.y );
		}
	}

	static bool mainImageSlide ( Clutter.GestureSlideEvent event) {
		
		unowned Clutter.Actor image, mirror;
		script.get_objects ( "mainImage", out image );
		script.get_objects ( "mainMirror", out mirror );
		
		string[] classes = new string[2] { "mainImage", "subImage" };
		
		AnimationPath imagePath = { 25.0, 25.0 };
		AnimationPath mirrorPath = { 0, 0 };
		
		((Mx.Stylable) mirror).set_style_class( ((Mx.Stylable) image).get_style_class() );
		
		mirror.set_position( 25, 25 );
		var rand = Random.int_range(0, 2);
		
		((Mx.Stylable) image).set_style_class( classes[ rand ] ); 
		
		switch (event.direction) {
			case Clutter.GestureSlideDirection.UP:
					mirrorPath.endX = 25.0;
					mirrorPath.endY = -455.0;
					image.set_position( 25, 505 );
					break;
					
			case Clutter.GestureSlideDirection.DOWN: 
					mirrorPath.endX = 25.0;
					mirrorPath.endY = 505.0;
					image.set_position( 25, -455 );
					break;
					
			case Clutter.GestureSlideDirection.LEFT: 
					mirrorPath.endX = -775.0;
					mirrorPath.endY = 25.0;
					image.set_position( 825, 25 );
					break;
					
			case Clutter.GestureSlideDirection.RIGHT: 
					mirrorPath.endX = 825.0;
					mirrorPath.endY = 25.0;
					image.set_position( -775, 25 );
					break;
		}

		image.animate( Clutter.AnimationMode.EASE_OUT_SINE, 200, "x", imagePath.endX, "y", imagePath.endY );
		mirror.animate( Clutter.AnimationMode.EASE_OUT_SINE, 200, "x", mirrorPath.endX, "y", mirrorPath.endY );
		
		slide_event = true;
		
		return false;
	}

    static int main (string[] args) {
	    
	    Intl.setlocale ( LocaleCategory.ALL, "" );
        Intl.bindtextdomain( Config.GETTEXT_PACKAGE, Config.LOCALE_DIR );
        Intl.textdomain( Config.GETTEXT_PACKAGE ); 
        Intl.bind_textdomain_codeset( Config.GETTEXT_PACKAGE, "UTF-8" );

		paths = { Path() { name = "topLeft", x = 0.0, y = 0.0, dx = -1, dy = -1, visible = false }, 
				  Path() { name = "topRight", x = 690.0, y = 0.0, dx = 1, dy = -1, visible = false }, 
				  Path() { name = "bottomLeft", x = 0.0, y = 370.0, dx = -1, dy = 1, visible = false }, 
				  Path() { name = "bottomRight", x = 690.0, y = 370.0, dx = 1, dy = 1, visible = false },
				  Path() { name = "topSlide", x = -381.0, y = -5.0, dx = 1.2, dy = 0.0 , visible = false } };
		slide_event = false;
		
  	    Hildon.gtk_init( ref args );
  	    Clutter.init( ref args );
  	    
  	    program = Hildon.Program.get_instance ();
  	    
        Environment.set_application_name (Config.PACKAGE_NAME);
	
		context = new Osso.Context(Config.PACKAGE, Config.VERSION, false, null);
		
        if (context.display_state_on () != Osso.Status.OK) 
            warning("Error: Osso Initialize failed.\n");
            
  		var style = Mx.Style.get_default();
  		style.load_from_file ( "/usr/share/echognomix/style/default.css" );
  		
  		script = new Clutter.Script ();
  		try {
  			script.load_from_data ( iface, iface.length );
  		} catch ( GLib.Error error ) {
	  		//
  		}
  		
		var stage = Clutter.Stage.get_default ();
		var res = script.get_objects ( "mainStage", out stage );
		
		((Mx.Stylable) stage).set_style( style ); 

		Mx.Button btn;
		script.get_objects ( "topLeft", out btn );
		btn.clicked.connect( topLeftClick );

		script.get_objects ( "mainMirror", out btn );
		((Mx.Stylable) btn).set_style_class( "mainImage" );
		
		script.get_objects ( "mainImage", out btn );
		btn.clicked.connect( mainImageClick );
		((Mx.Stylable) btn).set_style_class( "subImage" );

		gesture = new Clutter.Gesture ( btn );
		gesture.set_gesture_mask( btn, Clutter.GestureMask.SLIDE );
		gesture.gesture_slide_event.connect( mainImageSlide );

		stage.set_fullscreen( true );
		stage.show();
		
		Clutter.main();
		
		return 0; 
		
    }
    
}