#!/bin/sh

## Ask where the user wishes to install the package with gxmessage:

export GXMSG=`printf "\
Where do you want your Debian image file installed?\n\
You need approximately 1.3GB initially.\n\
Free space left in internal memory or your memory card:\n\n"; \
df -h | grep "mmcblk.p1" | awk '{print $6 ": " $4 " free, " $2 " total (" $5 " full)"}' | sort`
gxmessage -center -buttons MyDocs:1,MicroSD:2 -geometry 690x380 -title "Choose Memory Card" "$GXMSG"
export SDNO=$?

case "$SDNO" in
  1)
    export SDCARD="/home/user/MyDocs" 
    ;;
  *)
    export SDCARD="/media/mmc1" 
    ;;
esac

echo "Downloading and extracting to $SDCARD..."

#exit 0

## HERE ARE THE VARIABLES:

export INSTPATH="/home/user/img-install"
export TARPATH="$SDCARD"
export DLURL="http://qole.org/files"
#This doesn't work:
export GZCMD1="tar -xzf"

export EXTPATH1=$TARPATH
export PKGNAME1="EASY DEBIAN IMAGE FILE"
export BIGTAR1="debian-m5-v2.img.ext2.bz2"
export BIGIMG1="debian-m5-v2.img.ext2"
# export BZ2CMD1="bzip2 -d "
# export BZ2CMD2=" > $TARPATH/$BIGIMG1"
# export BZ2CMD1="cat "
# export BZ2CMD2=" | bunzip2 > "
# export TARCMD1="cat $TARPATH/$BIGTAR1 | bunzip2 > $TARPATH/$BIGIMG1"
export MD51="1c02d35d6453fd35390ae025bd930ba2"
export EXTCMD1=""

#Set SKIPPKG2=1 to skip the second package.

export SKIPPKG2=1
export EXTPATH2=$EXTPATH1
export PKGNAME2="SECOND TEST"
export BIGTAR2="test2.tgz"
export TARCMD2="$GZCMD1 $TARPATH/$BIGTAR2"
export MD52="ec3ccde37f4cd026fd03911df7579d6a"
export EXTCMD2=""

#export CLEANUP="sudo rm -r $INSTPATH ; sudo rm /usr/share/applications/image-install.desktop "
export CLEANUP="echo All done!"

## HERE'S THE SCRIPT:

# Download first package

export GOTIT="no"

if [ -f $TARPATH/$BIGTAR1 ] ; then
  echo You already have the big image file! 
  echo   Checking to see if it is good...
  if [ "`$INSTPATH/md5sum  $TARPATH/$BIGTAR1 | awk '{print $1}'`" = "$MD51" ] ; then 
    export GOTIT="yes"
  fi
fi

echo " "
echo "Downloading $PKGNAME1 package..."

export GOOD=1
export TEST=2

while test $TEST != $GOOD 
do
 cd $TARPATH
 if [ ! "$GOTIT" = "yes" ] ; then
   wget -c $DLURL/$BIGTAR1
 fi

 if test -e  $TARPATH/$BIGTAR1
  then

   cd $INSTPATH
   export GOOD=$MD51
   if [ ! "$GOTIT" = "yes" ] ; then
     echo Testing the file to see if it is good.
     export TEST=`$INSTPATH/md5sum  $TARPATH/$BIGTAR1 | awk '{print $1}'`
   else
     export TEST=$MD51
   fi

   if test $TEST = $GOOD
    then

     cd $EXTPATH1
     echo Extracting the image file. This will take some time.

     # echo $TARCMD1
     # echo 'cat $TARPATH/$BIGTAR1 | bunzip2 > $TARPATH/$BIGIMG1'
     # TARERR=`$TARCMD1 2>&1`
     TARERR="Unknown bzip2 error"
     # read -p 'press enter' key
     #$TARCMD1
     cat $TARPATH/$BIGTAR1 | bunzip2 > $TARPATH/$BIGIMG1
     if [ "$?" = 0 ] ; then
	 rm -rf $TARPATH/$BIGTAR1
         $EXTCMD1
         export MSG1=`printf "CONGRATULATIONS!\n\nAll has gone well!\n\nSuccess installing $PKGNAME1 package!"`
         gxmessage -center -alignbuttons right -buttons GTK_STOCK_OK:0 -geometry 640x250 -title "SUCCESS!" "$MSG1"
       else
         export ERR1=`printf "ERROR! TAR FAILED!\nUnable to install $PKGNAME1\n$TARERR"`
         gxmessage -center -alignbuttons right -buttons GTK_STOCK_OK:0 -geometry 640x380 -title "TAR ERROR" "$ERR1"
         exit 99
      fi	
    else
      export ERR1=`printf "$PKGNAME1 package appears damaged.\nPress OK to try downloading again.\nCancel keeps the damaged file."`
      gxmessage -center -alignbuttons right -buttons GTK_STOCK_OK:0,GTK_STOCK_CANCEL:1 -geometry 640x100 -title "DOWNLOAD ERROR" "$ERR1"
      if [ "$?" = 1 ] ; then
        exit 99
      fi
      rm $TARPATH/$BIGTAR1
    fi
  fi
done

# Stop if only getting one package

if test $SKIPPKG2 == 1
 then
  $CLEANUP
  exit 0
fi

# Download second package

echo " "
echo "Downloading $PKGNAME2 package..."
export GOOD2=1
export TEST2=2

while test $TEST2 != $GOOD2
do
  cd $INSTPATH
  wget -c $DLURL/$BIGTAR2
  if test -e  $TARPATH/$BIGTAR2
   then

    export GOOD2=$MD52
    export TEST2=`$INSTPATH/md5sum  $TARPATH/$BIGTAR2 | awk '{print $1}'`

    if test $TEST2 = $GOOD2
     then
      cd $EXTPATH2
      TARERR=`$TARCMD2 2>&1`
      if [ "$?" = 0 ] ; then
	rm -rf $TARPATH/$BIGTAR2
        $EXTCMD2
        export MSG2=`printf "CONGRATULATIONS!\n\nAll has gone well!\n\nSuccess installing $PKGNAME2 package!"`
        gxmessage -center -alignbuttons right -buttons GTK_STOCK_OK:0 -geometry 640x250 -title "SUCCESS!" "$MSG2"
      else
        export ERR2=`printf "ERROR! ERROR! ERROR!\nTAR FAILED!\n\nUnable to install $PKGNAME2\n\n$TARERR"`
        gxmessage -center -alignbuttons right -buttons GTK_STOCK_OK:0 -geometry 640x250 -title "TAR ERROR" "$ERR2"
        exit 99
      fi
     else
      echo "$PKGNAME2 package seems damaged, trying again!"
     fi
   fi
done

$CLEANUP
exit 0
