import logging

from dwimd.values import on, off


values = {"on": on, "off": off}


def act(value):
    import conic
    if value is on:
        logging.debug("Enabling Wifi")
        # XXX not yet supported
    elif value is off:
        logging.debug("Disabling Wifi")
        # XXX not yet supported
    elif type(value) == str:
        logging.debug("Logging into the network " + value)
        connection = conic.Connection()
        iaps = connection.get_all_iaps()
        iap = [iap for iap in iaps if iap.get_name() == value][0]
        success = connection.request_connection_by_id(iap.get_id(), conic.CONNECT_FLAG_NONE)
        assert success
    else:
        raise ValueError("Invalid value %r" % (value, ))

#def read():
# not implemented because I could not find a way to get the current connection with libconic
