import py

from dwimd.plugins import reload_plugins, get_plugin, init_plugins, get_pluginnames, \
        add_plugin, del_plugin
from dwimd.engine import run_config_modules, run_functions, PlanningException, act


def setup_module():
    reload_plugins()
    init_plugins()


def test_sensor_orientation_valid_value():
    py.test.skip("orientation plugin not yet implemented")
    plugin = get_plugin("sensors", "orientation")
    assert plugin.sample()["orientation"] in plugin.values


def test_sensors_pluginlist_not_empty():
    plist = get_pluginnames("sensors")
    print plist
    assert plist


def test_history():
    class ValueException(Exception): pass
    class TestModuleAction(object):
        @staticmethod
        def act(value):
            raise ValueException(value)

    def func():
        force(test, history("load", 10, load))
    add_plugin("actions", "test", TestModuleAction)

    try:
        for _ in range(20):
            plan = run_functions([func])
            e = py.test.raises(ValueException, "act(plan)")
            l = e.value.args[0]
            print l
            assert len(l) <= 10
    finally:
        del_plugin("actions", "test")

