import logging
from subprocess import PIPE, Popen


further_names = "availability_message".split()

def get_account_list():
    return Popen(["/usr/bin/mc-tool", "list"], stdout=PIPE).communicate()[0].splitlines()


def act(values):
    statusname, statusmsg = values["availability"], values["availability_message"]
    if statusmsg is None:
        statusmsg = ""
    for account in get_account_list():
        account = account.strip()
        Popen(["/usr/bin/mc-tool", "request", account, statusname, statusmsg],
               stdout=PIPE).communicate()[0].splitlines()

def read():
    for account in get_account_list():
        if "skype" in account or "gabble" in account:
            info = Popen(["/usr/bin/mc-tool", "show", account],
                        stdout=PIPE).communicate()[0].splitlines()
            for line in info:
                parts = line.strip().split(":", 1)
                if len(parts) == 2 and parts[0] == "Current":
                    return parts[1].strip().lower()
            assert False
    return NotImplemented

