// Copyright (C) 2005-2007 Code Synthesis Tools CC
//
// This program was generated by XML Schema Definition Compiler (XSD)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis Tools CC gives
// permission to link this program with the Xerces-C++ library (or with
// modified versions of Xerces-C++ that use the same license as Xerces-C++),
// and distribute linked combinations including the two. You must obey
// the GNU General Public License version 2 in all respects for all of
// the code used other than Xerces-C++. If you modify this copy of the
// program, you may extend this exception to your version of the program,
// but you are not obligated to do so. If you do not wish to do so, delete
// this exception statement from your version.
//
// Furthermore, Code Synthesis Tools CC makes a special exception for
// the Free/Libre and Open Source Software (FLOSS) which is described
// in the accompanying FLOSSE file.
//

#ifndef ROUTER_H
#define ROUTER_H

#include <xsd/cxx/version.hxx>

#if (XSD_INT_VERSION != 2030100L)
#error XSD runtime version mismatch
#endif

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/pre.hxx>

#ifndef XSD_USE_CHAR
#define XSD_USE_CHAR
#endif

#ifndef XSD_CXX_TREE_USE_CHAR
#define XSD_CXX_TREE_USE_CHAR
#endif

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/types.hxx>
#include <xsd/cxx/xml/error-handler.hxx>

#include <xsd/cxx/tree/parsing.hxx>

#include <xsd/cxx/tree/serialization.hxx>
#include <xsd/cxx/xml/dom/namespace-infomap.hxx>

namespace xml_schema
{
  // anyType and anySimpleType.
  //
  typedef ::xsd::cxx::tree::type type;
  typedef ::xsd::cxx::tree::simple_type<type> simple_type;

  // 8-bit
  //
  typedef signed char byte;
  typedef unsigned char unsigned_byte;

  // 16-bit
  //
  typedef short short_;
  typedef unsigned short unsigned_short;

  // 32-bit
  //
  typedef int int_;
  typedef unsigned int unsigned_int;

  // 64-bit
  //
  typedef long long long_;
  typedef unsigned long long unsigned_long;

  // Supposed to be arbitrary-length integral types.
  //
  typedef long long integer;
  typedef integer non_positive_integer;
  typedef integer non_negative_integer;
  typedef integer positive_integer;
  typedef integer negative_integer;

  // Boolean.
  //
  typedef bool boolean;

  // Floating-point types.
  //
  typedef float float_;
  typedef double double_;
  typedef long double decimal;

  // String types.
  //
  typedef ::xsd::cxx::tree::string< char, simple_type > string;
  typedef ::xsd::cxx::tree::normalized_string< char, string > normalized_string;
  typedef ::xsd::cxx::tree::token< char, normalized_string > token;
  typedef ::xsd::cxx::tree::name< char, token > name;
  typedef ::xsd::cxx::tree::nmtoken< char, token > nmtoken;
  typedef ::xsd::cxx::tree::nmtokens< char, simple_type, nmtoken> nmtokens;
  typedef ::xsd::cxx::tree::ncname< char, name > ncname;
  typedef ::xsd::cxx::tree::language< char, token > language;

  // ID/IDREF.
  //
  typedef ::xsd::cxx::tree::id< char, ncname > id;
  typedef ::xsd::cxx::tree::idref< type, char, ncname > idref;
  typedef ::xsd::cxx::tree::idrefs< char, simple_type, idref > idrefs;

  // URI.
  //
  typedef ::xsd::cxx::tree::uri< char, simple_type > uri;

  // Qualified name.
  //
  typedef ::xsd::cxx::tree::qname< char, simple_type, uri, ncname > qname;

  // Binary.
  //
  typedef ::xsd::cxx::tree::buffer< char > buffer;
  typedef ::xsd::cxx::tree::base64_binary< char, simple_type > base64_binary;
  typedef ::xsd::cxx::tree::hex_binary< char, simple_type > hex_binary;

  // Date/time.
  //
  typedef ::xsd::cxx::tree::date< char, simple_type > date;
  typedef ::xsd::cxx::tree::date_time< char, simple_type > date_time;
  typedef ::xsd::cxx::tree::duration< char, simple_type > duration;
  typedef ::xsd::cxx::tree::day< char, simple_type > day;
  typedef ::xsd::cxx::tree::month< char, simple_type > month;
  typedef ::xsd::cxx::tree::month_day< char, simple_type > month_day;
  typedef ::xsd::cxx::tree::year< char, simple_type > year;
  typedef ::xsd::cxx::tree::year_month< char, simple_type > year_month;
  typedef ::xsd::cxx::tree::time< char, simple_type > time;

  // Entity.
  //
  typedef ::xsd::cxx::tree::entity< char, ncname > entity;
  typedef ::xsd::cxx::tree::entities< char, simple_type, entity > entities;

  // Exceptions.
  //
  typedef ::xsd::cxx::tree::exception< char > exception;
  typedef ::xsd::cxx::tree::parsing< char > parsing;
  typedef ::xsd::cxx::tree::expected_element< char > expected_element;
  typedef ::xsd::cxx::tree::unexpected_element< char > unexpected_element;
  typedef ::xsd::cxx::tree::expected_attribute< char > expected_attribute;
  typedef ::xsd::cxx::tree::unexpected_enumerator< char > unexpected_enumerator;
  typedef ::xsd::cxx::tree::expected_text_content< char > expected_text_content;
  typedef ::xsd::cxx::tree::no_type_info< char > no_type_info;
  typedef ::xsd::cxx::tree::not_derived< char > not_derived;
  typedef ::xsd::cxx::tree::duplicate_id< char > duplicate_id;
  typedef ::xsd::cxx::tree::serialization< char > serialization;
  typedef ::xsd::cxx::tree::no_namespace_mapping< char > no_namespace_mapping;
  typedef ::xsd::cxx::tree::no_prefix_mapping< char > no_prefix_mapping;
  typedef ::xsd::cxx::tree::xsi_already_in_use< char > xsi_already_in_use;
  typedef ::xsd::cxx::tree::bounds< char > bounds;

  // Parsing/serialization error.
  //
  typedef ::xsd::cxx::tree::error< char > error;
  typedef ::xsd::cxx::tree::errors< char > errors;

  // Error handler interface.
  //
  typedef ::xsd::cxx::xml::error_handler< char > error_handler;

  // Namespace information. Used in serialization functions.
  //
  typedef ::xsd::cxx::xml::dom::namespace_info < char > namespace_info;
  typedef ::xsd::cxx::xml::dom::namespace_infomap < char > namespace_infomap;

  // Flags and properties.
  //
  typedef ::xsd::cxx::tree::flags flags;
  typedef ::xsd::cxx::tree::properties< char > properties;

  // DOM user data key for back pointers to tree nodes.
  //
#ifndef XSD_CXX_TREE_TREE_NODE_KEY_IN___XML_SCHEMA
#define XSD_CXX_TREE_TREE_NODE_KEY_IN___XML_SCHEMA

  const XMLCh* const tree_node_key = ::xsd::cxx::tree::user_data_keys::node;

#endif
}

// Forward declarations.
//
namespace dtn
{
  namespace rtrmessage
  {
    class dtnStatusType;
    class bundlePriorityType;
    class eventSourceType;
    class bundleForwardActionType;
    class contactReasonType;
    class linkTypeType;
    class linkStateType;
    class eidTypeType;
    class percentType;
    class failureActionType;
    class bundleLocationType;
    class eidType_base;
    class eidType;
    class gbofIdType_base;
    class gbofIdType;
    class bundleType_base;
    class bundleType;
    class contactType_base;
    class contactType;
    class clInfoType;
    class linkType_base;
    class linkType;
    class routeEntryType_base;
    class routeEntryType;
    class custodySignalType;
    class registrationType_base;
    class registrationType;
    class linkConfigType;
    class key_value_pair_base;
    class key_value_pair;
    class bundleAttributesSimpleQueryType;
    class bundleMetaBlockQueryType;
    class bundleAttributesQueryType;
    class metadataBlockType;
    class bundleAttributesReportType;
    class bundle_received_event;
    class data_transmitted_event;
    class bundle_delivered_event;
    class bundle_delivery_event;
    class bundle_send_cancelled_event;
    class bundle_expired_event;
    class bundle_injected_event;
    class link_opened_event;
    class link_closed_event;
    class link_created_event;
    class link_deleted_event;
    class link_available_event;
    class link_unavailable_event;
    class link_attribute_changed_event;
    class contact_attribute_changed_event;
    class link_busy_event;
    class eid_reachable_event;
    class route_add_event;
    class route_delete_event;
    class custody_signal_event;
    class custody_timeout_event;
    class intentional_name_resolved_event;
    class registration_added_event;
    class registration_removed_event;
    class registration_expired_event;
    class open_link_request;
    class close_link_request;
    class add_link_request;
    class delete_link_request;
    class reconfigure_link_request;
    class send_bundle_request;
    class send_bundle_broadcast_request;
    class cancel_bundle_request;
    class inject_bundle_request;
    class delete_bundle_request;
    class set_cl_params_request;
    class intentional_name_resolution_request;
    class deliver_bundle_to_app_request;
    class link_report;
    class link_attributes_query;
    class link_attributes_report;
    class contact_report;
    class route_report;
    class bundle_report;
    class bundle_attributes_query;
    class bundle_attributes_report;
    class bpa;
  }
}


#include <memory>    // std::auto_ptr
#include <algorithm> // std::binary_search

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/containers.hxx>
#include <xsd/cxx/tree/list.hxx>

namespace dtn
{
  namespace rtrmessage
  {
    class dtnStatusType: public ::xml_schema::string
    {
      public:
      enum _xsd_dtnStatusType
      {
        justBooted,
        shuttingDown
      };

      dtnStatusType ();

      dtnStatusType (_xsd_dtnStatusType);

      dtnStatusType (const ::xml_schema::string&);

      dtnStatusType (const ::xercesc::DOMElement&,
                     ::xml_schema::flags = 0,
                     ::xml_schema::type* = 0);

      dtnStatusType (const ::xercesc::DOMAttr&,
                     ::xml_schema::flags = 0,
                     ::xml_schema::type* = 0);

      dtnStatusType (const ::std::basic_string< char >&,
                     const ::xercesc::DOMElement*,
                     ::xml_schema::flags = 0,
                     ::xml_schema::type* = 0);

      dtnStatusType (const dtnStatusType&,
                     ::xml_schema::flags = 0,
                     ::xml_schema::type* = 0);

      virtual dtnStatusType*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      dtnStatusType&
      operator= (_xsd_dtnStatusType);

      virtual
      operator _xsd_dtnStatusType () const
      {
        return _xsd_dtnStatusType_convert ();
      }

      protected:
      _xsd_dtnStatusType
      _xsd_dtnStatusType_convert () const;

      public:
      static const char* const _xsd_dtnStatusType_literals_[2];
      static const _xsd_dtnStatusType _xsd_dtnStatusType_indexes_[2];
    };

    class bundlePriorityType: public ::xml_schema::string
    {
      public:
      enum _xsd_bundlePriorityType
      {
        bulk,
        normal,
        expedited,
        _unknown_priority_
      };

      bundlePriorityType ();

      bundlePriorityType (_xsd_bundlePriorityType);

      bundlePriorityType (const ::xml_schema::string&);

      bundlePriorityType (const ::xercesc::DOMElement&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

      bundlePriorityType (const ::xercesc::DOMAttr&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

      bundlePriorityType (const ::std::basic_string< char >&,
                          const ::xercesc::DOMElement*,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

      bundlePriorityType (const bundlePriorityType&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

      virtual bundlePriorityType*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      bundlePriorityType&
      operator= (_xsd_bundlePriorityType);

      virtual
      operator _xsd_bundlePriorityType () const
      {
        return _xsd_bundlePriorityType_convert ();
      }

      protected:
      _xsd_bundlePriorityType
      _xsd_bundlePriorityType_convert () const;

      public:
      static const char* const _xsd_bundlePriorityType_literals_[4];
      static const _xsd_bundlePriorityType _xsd_bundlePriorityType_indexes_[4];
    };

    class eventSourceType: public ::xml_schema::string
    {
      public:
      enum _xsd_eventSourceType
      {
        peer,
        application,
        dataStore,
        admin,
        fragmentation
      };

      eventSourceType ();

      eventSourceType (_xsd_eventSourceType);

      eventSourceType (const ::xml_schema::string&);

      eventSourceType (const ::xercesc::DOMElement&,
                       ::xml_schema::flags = 0,
                       ::xml_schema::type* = 0);

      eventSourceType (const ::xercesc::DOMAttr&,
                       ::xml_schema::flags = 0,
                       ::xml_schema::type* = 0);

      eventSourceType (const ::std::basic_string< char >&,
                       const ::xercesc::DOMElement*,
                       ::xml_schema::flags = 0,
                       ::xml_schema::type* = 0);

      eventSourceType (const eventSourceType&,
                       ::xml_schema::flags = 0,
                       ::xml_schema::type* = 0);

      virtual eventSourceType*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      eventSourceType&
      operator= (_xsd_eventSourceType);

      virtual
      operator _xsd_eventSourceType () const
      {
        return _xsd_eventSourceType_convert ();
      }

      protected:
      _xsd_eventSourceType
      _xsd_eventSourceType_convert () const;

      public:
      static const char* const _xsd_eventSourceType_literals_[5];
      static const _xsd_eventSourceType _xsd_eventSourceType_indexes_[5];
    };

    class bundleForwardActionType: public ::xml_schema::string
    {
      public:
      enum _xsd_bundleForwardActionType
      {
        forward,
        copy
      };

      bundleForwardActionType ();

      bundleForwardActionType (_xsd_bundleForwardActionType);

      bundleForwardActionType (const ::xml_schema::string&);

      bundleForwardActionType (const ::xercesc::DOMElement&,
                               ::xml_schema::flags = 0,
                               ::xml_schema::type* = 0);

      bundleForwardActionType (const ::xercesc::DOMAttr&,
                               ::xml_schema::flags = 0,
                               ::xml_schema::type* = 0);

      bundleForwardActionType (const ::std::basic_string< char >&,
                               const ::xercesc::DOMElement*,
                               ::xml_schema::flags = 0,
                               ::xml_schema::type* = 0);

      bundleForwardActionType (const bundleForwardActionType&,
                               ::xml_schema::flags = 0,
                               ::xml_schema::type* = 0);

      virtual bundleForwardActionType*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      bundleForwardActionType&
      operator= (_xsd_bundleForwardActionType);

      virtual
      operator _xsd_bundleForwardActionType () const
      {
        return _xsd_bundleForwardActionType_convert ();
      }

      protected:
      _xsd_bundleForwardActionType
      _xsd_bundleForwardActionType_convert () const;

      public:
      static const char* const _xsd_bundleForwardActionType_literals_[2];
      static const _xsd_bundleForwardActionType _xsd_bundleForwardActionType_indexes_[2];
    };

    class contactReasonType: public ::xml_schema::string
    {
      public:
      enum _xsd_contactReasonType
      {
        no_info,
        user,
        broken,
        cl_error,
        cl_version,
        shutdown,
        reconnect,
        idle,
        timeout,
        blocked,
        unblocked
      };

      contactReasonType ();

      contactReasonType (_xsd_contactReasonType);

      contactReasonType (const ::xml_schema::string&);

      contactReasonType (const ::xercesc::DOMElement&,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

      contactReasonType (const ::xercesc::DOMAttr&,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

      contactReasonType (const ::std::basic_string< char >&,
                         const ::xercesc::DOMElement*,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

      contactReasonType (const contactReasonType&,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

      virtual contactReasonType*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      contactReasonType&
      operator= (_xsd_contactReasonType);

      virtual
      operator _xsd_contactReasonType () const
      {
        return _xsd_contactReasonType_convert ();
      }

      protected:
      _xsd_contactReasonType
      _xsd_contactReasonType_convert () const;

      public:
      static const char* const _xsd_contactReasonType_literals_[11];
      static const _xsd_contactReasonType _xsd_contactReasonType_indexes_[11];
    };

    class linkTypeType: public ::xml_schema::string
    {
      public:
      enum _xsd_linkTypeType
      {
        alwayson,
        ondemand,
        scheduled,
        opportunistic
      };

      linkTypeType ();

      linkTypeType (_xsd_linkTypeType);

      linkTypeType (const ::xml_schema::string&);

      linkTypeType (const ::xercesc::DOMElement&,
                    ::xml_schema::flags = 0,
                    ::xml_schema::type* = 0);

      linkTypeType (const ::xercesc::DOMAttr&,
                    ::xml_schema::flags = 0,
                    ::xml_schema::type* = 0);

      linkTypeType (const ::std::basic_string< char >&,
                    const ::xercesc::DOMElement*,
                    ::xml_schema::flags = 0,
                    ::xml_schema::type* = 0);

      linkTypeType (const linkTypeType&,
                    ::xml_schema::flags = 0,
                    ::xml_schema::type* = 0);

      virtual linkTypeType*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      linkTypeType&
      operator= (_xsd_linkTypeType);

      virtual
      operator _xsd_linkTypeType () const
      {
        return _xsd_linkTypeType_convert ();
      }

      protected:
      _xsd_linkTypeType
      _xsd_linkTypeType_convert () const;

      public:
      static const char* const _xsd_linkTypeType_literals_[4];
      static const _xsd_linkTypeType _xsd_linkTypeType_indexes_[4];
    };

    class linkStateType: public ::xml_schema::string
    {
      public:
      enum _xsd_linkStateType
      {
        unavailable,
        available,
        opening,
        open,
        busy
      };

      linkStateType ();

      linkStateType (_xsd_linkStateType);

      linkStateType (const ::xml_schema::string&);

      linkStateType (const ::xercesc::DOMElement&,
                     ::xml_schema::flags = 0,
                     ::xml_schema::type* = 0);

      linkStateType (const ::xercesc::DOMAttr&,
                     ::xml_schema::flags = 0,
                     ::xml_schema::type* = 0);

      linkStateType (const ::std::basic_string< char >&,
                     const ::xercesc::DOMElement*,
                     ::xml_schema::flags = 0,
                     ::xml_schema::type* = 0);

      linkStateType (const linkStateType&,
                     ::xml_schema::flags = 0,
                     ::xml_schema::type* = 0);

      virtual linkStateType*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      linkStateType&
      operator= (_xsd_linkStateType);

      virtual
      operator _xsd_linkStateType () const
      {
        return _xsd_linkStateType_convert ();
      }

      protected:
      _xsd_linkStateType
      _xsd_linkStateType_convert () const;

      public:
      static const char* const _xsd_linkStateType_literals_[5];
      static const _xsd_linkStateType _xsd_linkStateType_indexes_[5];
    };

    class eidTypeType: public ::xml_schema::string
    {
      public:

      eidTypeType ();

      eidTypeType (const ::std::basic_string< char >&);

      eidTypeType (const ::xercesc::DOMElement&,
                   ::xml_schema::flags = 0,
                   ::xml_schema::type* = 0);

      eidTypeType (const ::xercesc::DOMAttr&,
                   ::xml_schema::flags = 0,
                   ::xml_schema::type* = 0);

      eidTypeType (const ::std::basic_string< char >&,
                   const ::xercesc::DOMElement*,
                   ::xml_schema::flags = 0,
                   ::xml_schema::type* = 0);

      eidTypeType (const eidTypeType&,
                   ::xml_schema::flags = 0,
                   ::xml_schema::type* = 0);

      virtual eidTypeType*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;
    };

    class percentType: public ::xsd::cxx::tree::fundamental_base< ::xml_schema::integer, char, ::xml_schema::simple_type >
    {
      public:

      struct _xsd_percentType
      {
        typedef ::xml_schema::integer base_;
      };

      // Constructors.
      //
      public:
      percentType ();

      percentType (const _xsd_percentType::base_& );

      percentType (const ::xercesc::DOMElement&,
                   ::xml_schema::flags = 0,
                   ::xml_schema::type* = 0);

      percentType (const ::xercesc::DOMAttr&,
                   ::xml_schema::flags = 0,
                   ::xml_schema::type* = 0);

      percentType (const ::std::basic_string< char >&,
                   const ::xercesc::DOMElement*,
                   ::xml_schema::flags = 0,
                   ::xml_schema::type* = 0);

      percentType (const percentType&,
                   ::xml_schema::flags = 0,
                   ::xml_schema::type* = 0);

      virtual percentType*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;
    };

    class failureActionType: public ::xml_schema::string
    {
      public:
      enum _xsd_failureActionType
      {
        drop,
        defer,
        exec
      };

      failureActionType ();

      failureActionType (_xsd_failureActionType);

      failureActionType (const ::xml_schema::string&);

      failureActionType (const ::xercesc::DOMElement&,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

      failureActionType (const ::xercesc::DOMAttr&,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

      failureActionType (const ::std::basic_string< char >&,
                         const ::xercesc::DOMElement*,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

      failureActionType (const failureActionType&,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

      virtual failureActionType*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      failureActionType&
      operator= (_xsd_failureActionType);

      virtual
      operator _xsd_failureActionType () const
      {
        return _xsd_failureActionType_convert ();
      }

      protected:
      _xsd_failureActionType
      _xsd_failureActionType_convert () const;

      public:
      static const char* const _xsd_failureActionType_literals_[3];
      static const _xsd_failureActionType _xsd_failureActionType_indexes_[3];
    };

    class bundleLocationType: public ::xml_schema::string
    {
      public:
      enum _xsd_bundleLocationType
      {
        memory,
        disk,
        nodata
      };

      bundleLocationType ();

      bundleLocationType (_xsd_bundleLocationType);

      bundleLocationType (const ::xml_schema::string&);

      bundleLocationType (const ::xercesc::DOMElement&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

      bundleLocationType (const ::xercesc::DOMAttr&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

      bundleLocationType (const ::std::basic_string< char >&,
                          const ::xercesc::DOMElement*,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

      bundleLocationType (const bundleLocationType&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

      virtual bundleLocationType*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      bundleLocationType&
      operator= (_xsd_bundleLocationType);

      virtual
      operator _xsd_bundleLocationType () const
      {
        return _xsd_bundleLocationType_convert ();
      }

      protected:
      _xsd_bundleLocationType
      _xsd_bundleLocationType_convert () const;

      public:
      static const char* const _xsd_bundleLocationType_literals_[3];
      static const _xsd_bundleLocationType _xsd_bundleLocationType_indexes_[3];
    };

    class eidType_base: public ::xml_schema::type
    {
      public:

      struct _xsd_eidType_base
      {
        typedef ::xml_schema::type base_;
      };

      // uri
      // 
      public:
      struct uri
      {
        typedef ::dtn::rtrmessage::eidTypeType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const uri::type&
      uri () const;

      uri::type&
      uri ();

      void
      uri (const uri::type&);

      void
      uri (::std::auto_ptr< uri::type >);

      // Constructors.
      //
      public:
      eidType_base ();

      eidType_base (const uri::type&);

      eidType_base (const ::xercesc::DOMElement&,
                    ::xml_schema::flags = 0,
                    ::xml_schema::type* = 0);

      eidType_base (const eidType_base&,
                    ::xml_schema::flags = 0,
                    ::xml_schema::type* = 0);

      virtual eidType_base*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< uri::type > _xsd_uri_;
    };

    class gbofIdType_base: public ::xml_schema::type
    {
      public:

      struct _xsd_gbofIdType_base
      {
        typedef ::xml_schema::type base_;
      };

      // source
      // 
      public:
      struct source
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const source::type&
      source () const;

      source::type&
      source ();

      void
      source (const source::type&);

      void
      source (::std::auto_ptr< source::type >);

      // creation_ts
      // 
      public:
      struct creation_ts
      {
        typedef ::xml_schema::long_ type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const creation_ts::type&
      creation_ts () const;

      creation_ts::type&
      creation_ts ();

      void
      creation_ts (const creation_ts::type&);

      // is_fragment
      // 
      public:
      struct is_fragment
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const is_fragment::type&
      is_fragment () const;

      is_fragment::type&
      is_fragment ();

      void
      is_fragment (const is_fragment::type&);

      // frag_length
      // 
      public:
      struct frag_length
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const frag_length::type&
      frag_length () const;

      frag_length::type&
      frag_length ();

      void
      frag_length (const frag_length::type&);

      // frag_offset
      // 
      public:
      struct frag_offset
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const frag_offset::type&
      frag_offset () const;

      frag_offset::type&
      frag_offset ();

      void
      frag_offset (const frag_offset::type&);

      // Constructors.
      //
      public:
      gbofIdType_base ();

      gbofIdType_base (const source::type&,
                       const creation_ts::type&,
                       const is_fragment::type&,
                       const frag_length::type&,
                       const frag_offset::type&);

      gbofIdType_base (const ::xercesc::DOMElement&,
                       ::xml_schema::flags = 0,
                       ::xml_schema::type* = 0);

      gbofIdType_base (const gbofIdType_base&,
                       ::xml_schema::flags = 0,
                       ::xml_schema::type* = 0);

      virtual gbofIdType_base*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< source::type > _xsd_source_;
      ::xsd::cxx::tree::one< creation_ts::type > _xsd_creation_ts_;
      ::xsd::cxx::tree::one< is_fragment::type > _xsd_is_fragment_;
      ::xsd::cxx::tree::one< frag_length::type > _xsd_frag_length_;
      ::xsd::cxx::tree::one< frag_offset::type > _xsd_frag_offset_;
    };

    class bundleType_base: public ::xml_schema::type
    {
      public:

      struct _xsd_bundleType_base
      {
        typedef ::xml_schema::type base_;
      };

      // source
      // 
      public:
      struct source
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const source::type&
      source () const;

      source::type&
      source ();

      void
      source (const source::type&);

      void
      source (::std::auto_ptr< source::type >);

      // dest
      // 
      public:
      struct dest
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const dest::type&
      dest () const;

      dest::type&
      dest ();

      void
      dest (const dest::type&);

      void
      dest (::std::auto_ptr< dest::type >);

      // custodian
      // 
      public:
      struct custodian
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const custodian::type&
      custodian () const;

      custodian::type&
      custodian ();

      void
      custodian (const custodian::type&);

      void
      custodian (::std::auto_ptr< custodian::type >);

      // replyto
      // 
      public:
      struct replyto
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const replyto::type&
      replyto () const;

      replyto::type&
      replyto ();

      void
      replyto (const replyto::type&);

      void
      replyto (::std::auto_ptr< replyto::type >);

      // prevhop
      // 
      public:
      struct prevhop
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const prevhop::type&
      prevhop () const;

      prevhop::type&
      prevhop ();

      void
      prevhop (const prevhop::type&);

      void
      prevhop (::std::auto_ptr< prevhop::type >);

      // length
      // 
      public:
      struct length
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const length::type&
      length () const;

      length::type&
      length ();

      void
      length (const length::type&);

      // location
      // 
      public:
      struct location
      {
        typedef ::dtn::rtrmessage::bundleLocationType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const location::type&
      location () const;

      location::type&
      location ();

      void
      location (const location::type&);

      void
      location (::std::auto_ptr< location::type >);

      // payload_file
      // 
      public:
      struct payload_file
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const payload_file::container&
      payload_file () const;

      payload_file::container&
      payload_file ();

      void
      payload_file (const payload_file::type&);

      void
      payload_file (const payload_file::container&);

      void
      payload_file (::std::auto_ptr< payload_file::type >);

      // bundleid
      // 
      public:
      struct bundleid
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const bundleid::type&
      bundleid () const;

      bundleid::type&
      bundleid ();

      void
      bundleid (const bundleid::type&);

      // is_fragment
      // 
      public:
      struct is_fragment
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const is_fragment::type&
      is_fragment () const;

      is_fragment::type&
      is_fragment ();

      void
      is_fragment (const is_fragment::type&);

      // is_admin
      // 
      public:
      struct is_admin
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const is_admin::type&
      is_admin () const;

      is_admin::type&
      is_admin ();

      void
      is_admin (const is_admin::type&);

      // do_not_fragment
      // 
      public:
      struct do_not_fragment
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const do_not_fragment::type&
      do_not_fragment () const;

      do_not_fragment::type&
      do_not_fragment ();

      void
      do_not_fragment (const do_not_fragment::type&);

      // priority
      // 
      public:
      struct priority
      {
        typedef ::dtn::rtrmessage::bundlePriorityType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const priority::type&
      priority () const;

      priority::type&
      priority ();

      void
      priority (const priority::type&);

      void
      priority (::std::auto_ptr< priority::type >);

      // custody_requested
      // 
      public:
      struct custody_requested
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const custody_requested::type&
      custody_requested () const;

      custody_requested::type&
      custody_requested ();

      void
      custody_requested (const custody_requested::type&);

      // local_custody
      // 
      public:
      struct local_custody
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const local_custody::type&
      local_custody () const;

      local_custody::type&
      local_custody ();

      void
      local_custody (const local_custody::type&);

      // singleton_dest
      // 
      public:
      struct singleton_dest
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const singleton_dest::type&
      singleton_dest () const;

      singleton_dest::type&
      singleton_dest ();

      void
      singleton_dest (const singleton_dest::type&);

      // custody_rcpt
      // 
      public:
      struct custody_rcpt
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const custody_rcpt::type&
      custody_rcpt () const;

      custody_rcpt::type&
      custody_rcpt ();

      void
      custody_rcpt (const custody_rcpt::type&);

      // receive_rcpt
      // 
      public:
      struct receive_rcpt
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const receive_rcpt::type&
      receive_rcpt () const;

      receive_rcpt::type&
      receive_rcpt ();

      void
      receive_rcpt (const receive_rcpt::type&);

      // forward_rcpt
      // 
      public:
      struct forward_rcpt
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const forward_rcpt::type&
      forward_rcpt () const;

      forward_rcpt::type&
      forward_rcpt ();

      void
      forward_rcpt (const forward_rcpt::type&);

      // delivery_rcpt
      // 
      public:
      struct delivery_rcpt
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const delivery_rcpt::type&
      delivery_rcpt () const;

      delivery_rcpt::type&
      delivery_rcpt ();

      void
      delivery_rcpt (const delivery_rcpt::type&);

      // deletion_rcpt
      // 
      public:
      struct deletion_rcpt
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const deletion_rcpt::type&
      deletion_rcpt () const;

      deletion_rcpt::type&
      deletion_rcpt ();

      void
      deletion_rcpt (const deletion_rcpt::type&);

      // app_acked_rcpt
      // 
      public:
      struct app_acked_rcpt
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const app_acked_rcpt::type&
      app_acked_rcpt () const;

      app_acked_rcpt::type&
      app_acked_rcpt ();

      void
      app_acked_rcpt (const app_acked_rcpt::type&);

      // creation_ts_seconds
      // 
      public:
      struct creation_ts_seconds
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const creation_ts_seconds::type&
      creation_ts_seconds () const;

      creation_ts_seconds::type&
      creation_ts_seconds ();

      void
      creation_ts_seconds (const creation_ts_seconds::type&);

      // creation_ts_seqno
      // 
      public:
      struct creation_ts_seqno
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const creation_ts_seqno::type&
      creation_ts_seqno () const;

      creation_ts_seqno::type&
      creation_ts_seqno ();

      void
      creation_ts_seqno (const creation_ts_seqno::type&);

      // expiration
      // 
      public:
      struct expiration
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const expiration::type&
      expiration () const;

      expiration::type&
      expiration ();

      void
      expiration (const expiration::type&);

      // orig_length
      // 
      public:
      struct orig_length
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const orig_length::type&
      orig_length () const;

      orig_length::type&
      orig_length ();

      void
      orig_length (const orig_length::type&);

      // frag_offset
      // 
      public:
      struct frag_offset
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const frag_offset::type&
      frag_offset () const;

      frag_offset::type&
      frag_offset ();

      void
      frag_offset (const frag_offset::type&);

      // owner
      // 
      public:
      struct owner
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const owner::type&
      owner () const;

      owner::type&
      owner ();

      void
      owner (const owner::type&);

      void
      owner (::std::auto_ptr< owner::type >);

      // Constructors.
      //
      public:
      bundleType_base ();

      bundleType_base (const source::type&,
                       const dest::type&,
                       const custodian::type&,
                       const replyto::type&,
                       const prevhop::type&,
                       const length::type&,
                       const location::type&,
                       const bundleid::type&,
                       const is_fragment::type&,
                       const is_admin::type&,
                       const do_not_fragment::type&,
                       const priority::type&,
                       const custody_requested::type&,
                       const local_custody::type&,
                       const singleton_dest::type&,
                       const custody_rcpt::type&,
                       const receive_rcpt::type&,
                       const forward_rcpt::type&,
                       const delivery_rcpt::type&,
                       const deletion_rcpt::type&,
                       const app_acked_rcpt::type&,
                       const creation_ts_seconds::type&,
                       const creation_ts_seqno::type&,
                       const expiration::type&,
                       const orig_length::type&,
                       const frag_offset::type&,
                       const owner::type&);

      bundleType_base (const ::xercesc::DOMElement&,
                       ::xml_schema::flags = 0,
                       ::xml_schema::type* = 0);

      bundleType_base (const bundleType_base&,
                       ::xml_schema::flags = 0,
                       ::xml_schema::type* = 0);

      virtual bundleType_base*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< source::type > _xsd_source_;
      ::xsd::cxx::tree::one< dest::type > _xsd_dest_;
      ::xsd::cxx::tree::one< custodian::type > _xsd_custodian_;
      ::xsd::cxx::tree::one< replyto::type > _xsd_replyto_;
      ::xsd::cxx::tree::one< prevhop::type > _xsd_prevhop_;
      ::xsd::cxx::tree::one< length::type > _xsd_length_;
      ::xsd::cxx::tree::one< location::type > _xsd_location_;
      ::xsd::cxx::tree::optional< payload_file::type > _xsd_payload_file_;
      ::xsd::cxx::tree::one< bundleid::type > _xsd_bundleid_;
      ::xsd::cxx::tree::one< is_fragment::type > _xsd_is_fragment_;
      ::xsd::cxx::tree::one< is_admin::type > _xsd_is_admin_;
      ::xsd::cxx::tree::one< do_not_fragment::type > _xsd_do_not_fragment_;
      ::xsd::cxx::tree::one< priority::type > _xsd_priority_;
      ::xsd::cxx::tree::one< custody_requested::type > _xsd_custody_requested_;
      ::xsd::cxx::tree::one< local_custody::type > _xsd_local_custody_;
      ::xsd::cxx::tree::one< singleton_dest::type > _xsd_singleton_dest_;
      ::xsd::cxx::tree::one< custody_rcpt::type > _xsd_custody_rcpt_;
      ::xsd::cxx::tree::one< receive_rcpt::type > _xsd_receive_rcpt_;
      ::xsd::cxx::tree::one< forward_rcpt::type > _xsd_forward_rcpt_;
      ::xsd::cxx::tree::one< delivery_rcpt::type > _xsd_delivery_rcpt_;
      ::xsd::cxx::tree::one< deletion_rcpt::type > _xsd_deletion_rcpt_;
      ::xsd::cxx::tree::one< app_acked_rcpt::type > _xsd_app_acked_rcpt_;
      ::xsd::cxx::tree::one< creation_ts_seconds::type > _xsd_creation_ts_seconds_;
      ::xsd::cxx::tree::one< creation_ts_seqno::type > _xsd_creation_ts_seqno_;
      ::xsd::cxx::tree::one< expiration::type > _xsd_expiration_;
      ::xsd::cxx::tree::one< orig_length::type > _xsd_orig_length_;
      ::xsd::cxx::tree::one< frag_offset::type > _xsd_frag_offset_;
      ::xsd::cxx::tree::one< owner::type > _xsd_owner_;
    };

    class contactType_base: public ::xml_schema::type
    {
      public:

      struct _xsd_contactType_base
      {
        typedef ::xml_schema::type base_;
      };

      // link_attr
      // 
      public:
      struct link_attr
      {
        typedef ::dtn::rtrmessage::linkType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link_attr::type&
      link_attr () const;

      link_attr::type&
      link_attr ();

      void
      link_attr (const link_attr::type&);

      void
      link_attr (::std::auto_ptr< link_attr::type >);

      // start_time_sec
      // 
      public:
      struct start_time_sec
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const start_time_sec::type&
      start_time_sec () const;

      start_time_sec::type&
      start_time_sec ();

      void
      start_time_sec (const start_time_sec::type&);

      // start_time_usec
      // 
      public:
      struct start_time_usec
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const start_time_usec::type&
      start_time_usec () const;

      start_time_usec::type&
      start_time_usec ();

      void
      start_time_usec (const start_time_usec::type&);

      // duration
      // 
      public:
      struct duration
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const duration::type&
      duration () const;

      duration::type&
      duration ();

      void
      duration (const duration::type&);

      // bps
      // 
      public:
      struct bps
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const bps::type&
      bps () const;

      bps::type&
      bps ();

      void
      bps (const bps::type&);

      // latency
      // 
      public:
      struct latency
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const latency::type&
      latency () const;

      latency::type&
      latency ();

      void
      latency (const latency::type&);

      // pkt_loss_prob
      // 
      public:
      struct pkt_loss_prob
      {
        typedef ::dtn::rtrmessage::percentType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const pkt_loss_prob::type&
      pkt_loss_prob () const;

      pkt_loss_prob::type&
      pkt_loss_prob ();

      void
      pkt_loss_prob (const pkt_loss_prob::type&);

      void
      pkt_loss_prob (::std::auto_ptr< pkt_loss_prob::type >);

      // Constructors.
      //
      public:
      contactType_base ();

      contactType_base (const link_attr::type&,
                        const start_time_sec::type&,
                        const start_time_usec::type&,
                        const duration::type&,
                        const bps::type&,
                        const latency::type&,
                        const pkt_loss_prob::type&);

      contactType_base (const ::xercesc::DOMElement&,
                        ::xml_schema::flags = 0,
                        ::xml_schema::type* = 0);

      contactType_base (const contactType_base&,
                        ::xml_schema::flags = 0,
                        ::xml_schema::type* = 0);

      virtual contactType_base*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< link_attr::type > _xsd_link_attr_;
      ::xsd::cxx::tree::one< start_time_sec::type > _xsd_start_time_sec_;
      ::xsd::cxx::tree::one< start_time_usec::type > _xsd_start_time_usec_;
      ::xsd::cxx::tree::one< duration::type > _xsd_duration_;
      ::xsd::cxx::tree::one< bps::type > _xsd_bps_;
      ::xsd::cxx::tree::one< latency::type > _xsd_latency_;
      ::xsd::cxx::tree::one< pkt_loss_prob::type > _xsd_pkt_loss_prob_;
    };

    class clInfoType: public ::xml_schema::type
    {
      public:

      struct _xsd_clInfoType
      {
        typedef ::xml_schema::type base_;
      };

      // local_addr
      // 
      public:
      struct local_addr
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const local_addr::container&
      local_addr () const;

      local_addr::container&
      local_addr ();

      void
      local_addr (const local_addr::type&);

      void
      local_addr (const local_addr::container&);

      void
      local_addr (::std::auto_ptr< local_addr::type >);

      // remote_addr
      // 
      public:
      struct remote_addr
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const remote_addr::container&
      remote_addr () const;

      remote_addr::container&
      remote_addr ();

      void
      remote_addr (const remote_addr::type&);

      void
      remote_addr (const remote_addr::container&);

      void
      remote_addr (::std::auto_ptr< remote_addr::type >);

      // local_port
      // 
      public:
      struct local_port
      {
        typedef ::xml_schema::unsigned_short type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const local_port::container&
      local_port () const;

      local_port::container&
      local_port ();

      void
      local_port (const local_port::type&);

      void
      local_port (const local_port::container&);

      // remote_port
      // 
      public:
      struct remote_port
      {
        typedef ::xml_schema::unsigned_short type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const remote_port::container&
      remote_port () const;

      remote_port::container&
      remote_port ();

      void
      remote_port (const remote_port::type&);

      void
      remote_port (const remote_port::container&);

      // segment_ack_enabled
      // 
      public:
      struct segment_ack_enabled
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const segment_ack_enabled::container&
      segment_ack_enabled () const;

      segment_ack_enabled::container&
      segment_ack_enabled ();

      void
      segment_ack_enabled (const segment_ack_enabled::type&);

      void
      segment_ack_enabled (const segment_ack_enabled::container&);

      // negative_ack_enabled
      // 
      public:
      struct negative_ack_enabled
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const negative_ack_enabled::container&
      negative_ack_enabled () const;

      negative_ack_enabled::container&
      negative_ack_enabled ();

      void
      negative_ack_enabled (const negative_ack_enabled::type&);

      void
      negative_ack_enabled (const negative_ack_enabled::container&);

      // keepalive_interval
      // 
      public:
      struct keepalive_interval
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const keepalive_interval::container&
      keepalive_interval () const;

      keepalive_interval::container&
      keepalive_interval ();

      void
      keepalive_interval (const keepalive_interval::type&);

      void
      keepalive_interval (const keepalive_interval::container&);

      // segment_length
      // 
      public:
      struct segment_length
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const segment_length::container&
      segment_length () const;

      segment_length::container&
      segment_length ();

      void
      segment_length (const segment_length::type&);

      void
      segment_length (const segment_length::container&);

      // busy_queue_depth
      // 
      public:
      struct busy_queue_depth
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const busy_queue_depth::container&
      busy_queue_depth () const;

      busy_queue_depth::container&
      busy_queue_depth ();

      void
      busy_queue_depth (const busy_queue_depth::type&);

      void
      busy_queue_depth (const busy_queue_depth::container&);

      // reactive_frag_enabled
      // 
      public:
      struct reactive_frag_enabled
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const reactive_frag_enabled::container&
      reactive_frag_enabled () const;

      reactive_frag_enabled::container&
      reactive_frag_enabled ();

      void
      reactive_frag_enabled (const reactive_frag_enabled::type&);

      void
      reactive_frag_enabled (const reactive_frag_enabled::container&);

      // sendbuf_length
      // 
      public:
      struct sendbuf_length
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const sendbuf_length::container&
      sendbuf_length () const;

      sendbuf_length::container&
      sendbuf_length ();

      void
      sendbuf_length (const sendbuf_length::type&);

      void
      sendbuf_length (const sendbuf_length::container&);

      // recvbuf_length
      // 
      public:
      struct recvbuf_length
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const recvbuf_length::container&
      recvbuf_length () const;

      recvbuf_length::container&
      recvbuf_length ();

      void
      recvbuf_length (const recvbuf_length::type&);

      void
      recvbuf_length (const recvbuf_length::container&);

      // data_timeout
      // 
      public:
      struct data_timeout
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const data_timeout::container&
      data_timeout () const;

      data_timeout::container&
      data_timeout ();

      void
      data_timeout (const data_timeout::type&);

      void
      data_timeout (const data_timeout::container&);

      // rate
      // 
      public:
      struct rate
      {
        typedef ::xml_schema::unsigned_byte type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const rate::container&
      rate () const;

      rate::container&
      rate ();

      void
      rate (const rate::type&);

      void
      rate (const rate::container&);

      // bucket_depth
      // 
      public:
      struct bucket_depth
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const bucket_depth::container&
      bucket_depth () const;

      bucket_depth::container&
      bucket_depth ();

      void
      bucket_depth (const bucket_depth::type&);

      void
      bucket_depth (const bucket_depth::container&);

      // channel
      // 
      public:
      struct channel
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const channel::container&
      channel () const;

      channel::container&
      channel ();

      void
      channel (const channel::type&);

      void
      channel (const channel::container&);

      // Constructors.
      //
      public:
      clInfoType ();

      clInfoType (const ::xercesc::DOMElement&,
                  ::xml_schema::flags = 0,
                  ::xml_schema::type* = 0);

      clInfoType (const clInfoType&,
                  ::xml_schema::flags = 0,
                  ::xml_schema::type* = 0);

      virtual clInfoType*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::optional< local_addr::type > _xsd_local_addr_;
      ::xsd::cxx::tree::optional< remote_addr::type > _xsd_remote_addr_;
      ::xsd::cxx::tree::optional< local_port::type > _xsd_local_port_;
      ::xsd::cxx::tree::optional< remote_port::type > _xsd_remote_port_;
      ::xsd::cxx::tree::optional< segment_ack_enabled::type > _xsd_segment_ack_enabled_;
      ::xsd::cxx::tree::optional< negative_ack_enabled::type > _xsd_negative_ack_enabled_;
      ::xsd::cxx::tree::optional< keepalive_interval::type > _xsd_keepalive_interval_;
      ::xsd::cxx::tree::optional< segment_length::type > _xsd_segment_length_;
      ::xsd::cxx::tree::optional< busy_queue_depth::type > _xsd_busy_queue_depth_;
      ::xsd::cxx::tree::optional< reactive_frag_enabled::type > _xsd_reactive_frag_enabled_;
      ::xsd::cxx::tree::optional< sendbuf_length::type > _xsd_sendbuf_length_;
      ::xsd::cxx::tree::optional< recvbuf_length::type > _xsd_recvbuf_length_;
      ::xsd::cxx::tree::optional< data_timeout::type > _xsd_data_timeout_;
      ::xsd::cxx::tree::optional< rate::type > _xsd_rate_;
      ::xsd::cxx::tree::optional< bucket_depth::type > _xsd_bucket_depth_;
      ::xsd::cxx::tree::optional< channel::type > _xsd_channel_;
    };

    class linkType_base: public ::xml_schema::type
    {
      public:

      struct _xsd_linkType_base
      {
        typedef ::xml_schema::type base_;
      };

      // Workaround for g++ bug# 23206.
      //
      public:
      struct type;

      // clinfo
      // 
      public:
      struct clinfo
      {
        typedef ::dtn::rtrmessage::clInfoType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const clinfo::container&
      clinfo () const;

      clinfo::container&
      clinfo ();

      void
      clinfo (const clinfo::type&);

      void
      clinfo (const clinfo::container&);

      void
      clinfo (::std::auto_ptr< clinfo::type >);

      // remote_eid
      // 
      public:
      struct remote_eid
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const remote_eid::type&
      remote_eid () const;

      remote_eid::type&
      remote_eid ();

      void
      remote_eid (const remote_eid::type&);

      void
      remote_eid (::std::auto_ptr< remote_eid::type >);

      // type
      // 
      public:
      struct type
      {
        typedef ::dtn::rtrmessage::linkTypeType type_;
        typedef ::xsd::cxx::tree::traits< type_, char > traits;
      };

      const type::type_&
      type () const;

      type::type_&
      type ();

      void
      type (const type::type_&);

      void
      type (::std::auto_ptr< type::type_ >);

      // nexthop
      // 
      public:
      struct nexthop
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const nexthop::type&
      nexthop () const;

      nexthop::type&
      nexthop ();

      void
      nexthop (const nexthop::type&);

      void
      nexthop (::std::auto_ptr< nexthop::type >);

      // state
      // 
      public:
      struct state
      {
        typedef ::dtn::rtrmessage::linkStateType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const state::type&
      state () const;

      state::type&
      state ();

      void
      state (const state::type&);

      void
      state (::std::auto_ptr< state::type >);

      // is_reachable
      // 
      public:
      struct is_reachable
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const is_reachable::type&
      is_reachable () const;

      is_reachable::type&
      is_reachable ();

      void
      is_reachable (const is_reachable::type&);

      // is_usable
      // 
      public:
      struct is_usable
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const is_usable::type&
      is_usable () const;

      is_usable::type&
      is_usable ();

      void
      is_usable (const is_usable::type&);

      // how_reliable
      // 
      public:
      struct how_reliable
      {
        typedef ::dtn::rtrmessage::percentType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const how_reliable::type&
      how_reliable () const;

      how_reliable::type&
      how_reliable ();

      void
      how_reliable (const how_reliable::type&);

      void
      how_reliable (::std::auto_ptr< how_reliable::type >);

      // how_available
      // 
      public:
      struct how_available
      {
        typedef ::dtn::rtrmessage::percentType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const how_available::type&
      how_available () const;

      how_available::type&
      how_available ();

      void
      how_available (const how_available::type&);

      void
      how_available (::std::auto_ptr< how_available::type >);

      // clayer
      // 
      public:
      struct clayer
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const clayer::type&
      clayer () const;

      clayer::type&
      clayer ();

      void
      clayer (const clayer::type&);

      void
      clayer (::std::auto_ptr< clayer::type >);

      // min_retry_interval
      // 
      public:
      struct min_retry_interval
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const min_retry_interval::type&
      min_retry_interval () const;

      min_retry_interval::type&
      min_retry_interval ();

      void
      min_retry_interval (const min_retry_interval::type&);

      // max_retry_interval
      // 
      public:
      struct max_retry_interval
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const max_retry_interval::type&
      max_retry_interval () const;

      max_retry_interval::type&
      max_retry_interval ();

      void
      max_retry_interval (const max_retry_interval::type&);

      // idle_close_time
      // 
      public:
      struct idle_close_time
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const idle_close_time::type&
      idle_close_time () const;

      idle_close_time::type&
      idle_close_time ();

      void
      idle_close_time (const idle_close_time::type&);

      // Constructors.
      //
      public:
      linkType_base ();

      linkType_base (const remote_eid::type&,
                     const type::type_&,
                     const nexthop::type&,
                     const state::type&,
                     const is_reachable::type&,
                     const is_usable::type&,
                     const how_reliable::type&,
                     const how_available::type&,
                     const clayer::type&,
                     const min_retry_interval::type&,
                     const max_retry_interval::type&,
                     const idle_close_time::type&);

      linkType_base (const ::xercesc::DOMElement&,
                     ::xml_schema::flags = 0,
                     ::xml_schema::type* = 0);

      linkType_base (const linkType_base&,
                     ::xml_schema::flags = 0,
                     ::xml_schema::type* = 0);

      virtual linkType_base*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::optional< clinfo::type > _xsd_clinfo_;
      ::xsd::cxx::tree::one< remote_eid::type > _xsd_remote_eid_;
      ::xsd::cxx::tree::one< type::type_ > _xsd_type_;
      ::xsd::cxx::tree::one< nexthop::type > _xsd_nexthop_;
      ::xsd::cxx::tree::one< state::type > _xsd_state_;
      ::xsd::cxx::tree::one< is_reachable::type > _xsd_is_reachable_;
      ::xsd::cxx::tree::one< is_usable::type > _xsd_is_usable_;
      ::xsd::cxx::tree::one< how_reliable::type > _xsd_how_reliable_;
      ::xsd::cxx::tree::one< how_available::type > _xsd_how_available_;
      ::xsd::cxx::tree::one< clayer::type > _xsd_clayer_;
      ::xsd::cxx::tree::one< min_retry_interval::type > _xsd_min_retry_interval_;
      ::xsd::cxx::tree::one< max_retry_interval::type > _xsd_max_retry_interval_;
      ::xsd::cxx::tree::one< idle_close_time::type > _xsd_idle_close_time_;
    };

    class routeEntryType_base: public ::xml_schema::type
    {
      public:

      struct _xsd_routeEntryType_base
      {
        typedef ::xml_schema::type base_;
      };

      // dest_pattern
      // 
      public:
      struct dest_pattern
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const dest_pattern::type&
      dest_pattern () const;

      dest_pattern::type&
      dest_pattern ();

      void
      dest_pattern (const dest_pattern::type&);

      void
      dest_pattern (::std::auto_ptr< dest_pattern::type >);

      // source_pattern
      // 
      public:
      struct source_pattern
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const source_pattern::type&
      source_pattern () const;

      source_pattern::type&
      source_pattern ();

      void
      source_pattern (const source_pattern::type&);

      void
      source_pattern (::std::auto_ptr< source_pattern::type >);

      // route_priority
      // 
      public:
      struct route_priority
      {
        typedef ::xml_schema::integer type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const route_priority::type&
      route_priority () const;

      route_priority::type&
      route_priority ();

      void
      route_priority (const route_priority::type&);

      // action
      // 
      public:
      struct action
      {
        typedef ::dtn::rtrmessage::bundleForwardActionType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const action::type&
      action () const;

      action::type&
      action ();

      void
      action (const action::type&);

      void
      action (::std::auto_ptr< action::type >);

      // link
      // 
      public:
      struct link
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link::type&
      link () const;

      link::type&
      link ();

      void
      link (const link::type&);

      void
      link (::std::auto_ptr< link::type >);

      // Constructors.
      //
      public:
      routeEntryType_base ();

      routeEntryType_base (const dest_pattern::type&,
                           const source_pattern::type&,
                           const route_priority::type&,
                           const action::type&,
                           const link::type&);

      routeEntryType_base (const ::xercesc::DOMElement&,
                           ::xml_schema::flags = 0,
                           ::xml_schema::type* = 0);

      routeEntryType_base (const routeEntryType_base&,
                           ::xml_schema::flags = 0,
                           ::xml_schema::type* = 0);

      virtual routeEntryType_base*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< dest_pattern::type > _xsd_dest_pattern_;
      ::xsd::cxx::tree::one< source_pattern::type > _xsd_source_pattern_;
      ::xsd::cxx::tree::one< route_priority::type > _xsd_route_priority_;
      ::xsd::cxx::tree::one< action::type > _xsd_action_;
      ::xsd::cxx::tree::one< link::type > _xsd_link_;
    };

    class custodySignalType: public ::xml_schema::type
    {
      public:

      struct _xsd_custodySignalType
      {
        typedef ::xml_schema::type base_;
      };

      // admin_type
      // 
      public:
      struct admin_type
      {
        typedef ::xml_schema::unsigned_byte type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const admin_type::type&
      admin_type () const;

      admin_type::type&
      admin_type ();

      void
      admin_type (const admin_type::type&);

      // admin_flags
      // 
      public:
      struct admin_flags
      {
        typedef ::xml_schema::unsigned_byte type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const admin_flags::type&
      admin_flags () const;

      admin_flags::type&
      admin_flags ();

      void
      admin_flags (const admin_flags::type&);

      // succeeded
      // 
      public:
      struct succeeded
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const succeeded::type&
      succeeded () const;

      succeeded::type&
      succeeded ();

      void
      succeeded (const succeeded::type&);

      // reason
      // 
      public:
      struct reason
      {
        typedef ::xml_schema::unsigned_byte type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const reason::type&
      reason () const;

      reason::type&
      reason ();

      void
      reason (const reason::type&);

      // orig_frag_offset
      // 
      public:
      struct orig_frag_offset
      {
        typedef ::xml_schema::unsigned_long type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const orig_frag_offset::type&
      orig_frag_offset () const;

      orig_frag_offset::type&
      orig_frag_offset ();

      void
      orig_frag_offset (const orig_frag_offset::type&);

      // orig_frag_length
      // 
      public:
      struct orig_frag_length
      {
        typedef ::xml_schema::unsigned_long type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const orig_frag_length::type&
      orig_frag_length () const;

      orig_frag_length::type&
      orig_frag_length ();

      void
      orig_frag_length (const orig_frag_length::type&);

      // custody_signal_seconds
      // 
      public:
      struct custody_signal_seconds
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const custody_signal_seconds::type&
      custody_signal_seconds () const;

      custody_signal_seconds::type&
      custody_signal_seconds ();

      void
      custody_signal_seconds (const custody_signal_seconds::type&);

      // custody_signal_seqno
      // 
      public:
      struct custody_signal_seqno
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const custody_signal_seqno::type&
      custody_signal_seqno () const;

      custody_signal_seqno::type&
      custody_signal_seqno ();

      void
      custody_signal_seqno (const custody_signal_seqno::type&);

      // orig_creation_seconds
      // 
      public:
      struct orig_creation_seconds
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const orig_creation_seconds::type&
      orig_creation_seconds () const;

      orig_creation_seconds::type&
      orig_creation_seconds ();

      void
      orig_creation_seconds (const orig_creation_seconds::type&);

      // orig_creation_seqno
      // 
      public:
      struct orig_creation_seqno
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const orig_creation_seqno::type&
      orig_creation_seqno () const;

      orig_creation_seqno::type&
      orig_creation_seqno ();

      void
      orig_creation_seqno (const orig_creation_seqno::type&);

      // Constructors.
      //
      public:
      custodySignalType ();

      custodySignalType (const admin_type::type&,
                         const admin_flags::type&,
                         const succeeded::type&,
                         const reason::type&,
                         const orig_frag_offset::type&,
                         const orig_frag_length::type&,
                         const custody_signal_seconds::type&,
                         const custody_signal_seqno::type&,
                         const orig_creation_seconds::type&,
                         const orig_creation_seqno::type&);

      custodySignalType (const ::xercesc::DOMElement&,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

      custodySignalType (const custodySignalType&,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

      virtual custodySignalType*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< admin_type::type > _xsd_admin_type_;
      ::xsd::cxx::tree::one< admin_flags::type > _xsd_admin_flags_;
      ::xsd::cxx::tree::one< succeeded::type > _xsd_succeeded_;
      ::xsd::cxx::tree::one< reason::type > _xsd_reason_;
      ::xsd::cxx::tree::one< orig_frag_offset::type > _xsd_orig_frag_offset_;
      ::xsd::cxx::tree::one< orig_frag_length::type > _xsd_orig_frag_length_;
      ::xsd::cxx::tree::one< custody_signal_seconds::type > _xsd_custody_signal_seconds_;
      ::xsd::cxx::tree::one< custody_signal_seqno::type > _xsd_custody_signal_seqno_;
      ::xsd::cxx::tree::one< orig_creation_seconds::type > _xsd_orig_creation_seconds_;
      ::xsd::cxx::tree::one< orig_creation_seqno::type > _xsd_orig_creation_seqno_;
    };

    class registrationType_base: public ::xml_schema::type
    {
      public:

      struct _xsd_registrationType_base
      {
        typedef ::xml_schema::type base_;
      };

      // endpoint
      // 
      public:
      struct endpoint
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const endpoint::type&
      endpoint () const;

      endpoint::type&
      endpoint ();

      void
      endpoint (const endpoint::type&);

      void
      endpoint (::std::auto_ptr< endpoint::type >);

      // regid
      // 
      public:
      struct regid
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const regid::type&
      regid () const;

      regid::type&
      regid ();

      void
      regid (const regid::type&);

      // action
      // 
      public:
      struct action
      {
        typedef ::dtn::rtrmessage::failureActionType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const action::type&
      action () const;

      action::type&
      action ();

      void
      action (const action::type&);

      void
      action (::std::auto_ptr< action::type >);

      // script
      // 
      public:
      struct script
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const script::type&
      script () const;

      script::type&
      script ();

      void
      script (const script::type&);

      void
      script (::std::auto_ptr< script::type >);

      // expiration
      // 
      public:
      struct expiration
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const expiration::type&
      expiration () const;

      expiration::type&
      expiration ();

      void
      expiration (const expiration::type&);

      // Constructors.
      //
      public:
      registrationType_base ();

      registrationType_base (const endpoint::type&,
                             const regid::type&,
                             const action::type&,
                             const script::type&,
                             const expiration::type&);

      registrationType_base (const ::xercesc::DOMElement&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

      registrationType_base (const registrationType_base&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

      virtual registrationType_base*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< endpoint::type > _xsd_endpoint_;
      ::xsd::cxx::tree::one< regid::type > _xsd_regid_;
      ::xsd::cxx::tree::one< action::type > _xsd_action_;
      ::xsd::cxx::tree::one< script::type > _xsd_script_;
      ::xsd::cxx::tree::one< expiration::type > _xsd_expiration_;
    };

    class linkConfigType: public ::xml_schema::type
    {
      public:

      struct _xsd_linkConfigType
      {
        typedef ::xml_schema::type base_;
      };

      // cl_params
      // 
      public:
      struct cl_params
      {
        typedef ::dtn::rtrmessage::key_value_pair type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::sequence< type > container;
        typedef container::iterator iterator;
        typedef container::const_iterator const_iterator;
      };

      const cl_params::container&
      cl_params () const;

      cl_params::container&
      cl_params ();

      void
      cl_params (const cl_params::container&);

      // is_usable
      // 
      public:
      struct is_usable
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const is_usable::container&
      is_usable () const;

      is_usable::container&
      is_usable ();

      void
      is_usable (const is_usable::type&);

      void
      is_usable (const is_usable::container&);

      // reactive_frag_enabled
      // 
      public:
      struct reactive_frag_enabled
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const reactive_frag_enabled::container&
      reactive_frag_enabled () const;

      reactive_frag_enabled::container&
      reactive_frag_enabled ();

      void
      reactive_frag_enabled (const reactive_frag_enabled::type&);

      void
      reactive_frag_enabled (const reactive_frag_enabled::container&);

      // nexthop
      // 
      public:
      struct nexthop
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const nexthop::container&
      nexthop () const;

      nexthop::container&
      nexthop ();

      void
      nexthop (const nexthop::type&);

      void
      nexthop (const nexthop::container&);

      void
      nexthop (::std::auto_ptr< nexthop::type >);

      // min_retry_interval
      // 
      public:
      struct min_retry_interval
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const min_retry_interval::container&
      min_retry_interval () const;

      min_retry_interval::container&
      min_retry_interval ();

      void
      min_retry_interval (const min_retry_interval::type&);

      void
      min_retry_interval (const min_retry_interval::container&);

      // max_retry_interval
      // 
      public:
      struct max_retry_interval
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const max_retry_interval::container&
      max_retry_interval () const;

      max_retry_interval::container&
      max_retry_interval ();

      void
      max_retry_interval (const max_retry_interval::type&);

      void
      max_retry_interval (const max_retry_interval::container&);

      // idle_close_time
      // 
      public:
      struct idle_close_time
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const idle_close_time::container&
      idle_close_time () const;

      idle_close_time::container&
      idle_close_time ();

      void
      idle_close_time (const idle_close_time::type&);

      void
      idle_close_time (const idle_close_time::container&);

      // Constructors.
      //
      public:
      linkConfigType ();

      linkConfigType (const ::xercesc::DOMElement&,
                      ::xml_schema::flags = 0,
                      ::xml_schema::type* = 0);

      linkConfigType (const linkConfigType&,
                      ::xml_schema::flags = 0,
                      ::xml_schema::type* = 0);

      virtual linkConfigType*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::sequence< cl_params::type > _xsd_cl_params_;
      ::xsd::cxx::tree::optional< is_usable::type > _xsd_is_usable_;
      ::xsd::cxx::tree::optional< reactive_frag_enabled::type > _xsd_reactive_frag_enabled_;
      ::xsd::cxx::tree::optional< nexthop::type > _xsd_nexthop_;
      ::xsd::cxx::tree::optional< min_retry_interval::type > _xsd_min_retry_interval_;
      ::xsd::cxx::tree::optional< max_retry_interval::type > _xsd_max_retry_interval_;
      ::xsd::cxx::tree::optional< idle_close_time::type > _xsd_idle_close_time_;
    };

    class key_value_pair_base: public ::xml_schema::type
    {
      public:

      struct _xsd_key_value_pair_base
      {
        typedef ::xml_schema::type base_;
      };

      // name
      // 
      public:
      struct name
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const name::type&
      name () const;

      name::type&
      name ();

      void
      name (const name::type&);

      void
      name (::std::auto_ptr< name::type >);

      // bool_value
      // 
      public:
      struct bool_value
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const bool_value::container&
      bool_value () const;

      bool_value::container&
      bool_value ();

      void
      bool_value (const bool_value::type&);

      void
      bool_value (const bool_value::container&);

      // u_int_value
      // 
      public:
      struct u_int_value
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const u_int_value::container&
      u_int_value () const;

      u_int_value::container&
      u_int_value ();

      void
      u_int_value (const u_int_value::type&);

      void
      u_int_value (const u_int_value::container&);

      // int_value
      // 
      public:
      struct int_value
      {
        typedef ::xml_schema::int_ type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const int_value::container&
      int_value () const;

      int_value::container&
      int_value ();

      void
      int_value (const int_value::type&);

      void
      int_value (const int_value::container&);

      // str_value
      // 
      public:
      struct str_value
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const str_value::container&
      str_value () const;

      str_value::container&
      str_value ();

      void
      str_value (const str_value::type&);

      void
      str_value (const str_value::container&);

      void
      str_value (::std::auto_ptr< str_value::type >);

      // Constructors.
      //
      public:
      key_value_pair_base ();

      key_value_pair_base (const name::type&);

      key_value_pair_base (const ::xercesc::DOMElement&,
                           ::xml_schema::flags = 0,
                           ::xml_schema::type* = 0);

      key_value_pair_base (const key_value_pair_base&,
                           ::xml_schema::flags = 0,
                           ::xml_schema::type* = 0);

      virtual key_value_pair_base*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< name::type > _xsd_name_;
      ::xsd::cxx::tree::optional< bool_value::type > _xsd_bool_value_;
      ::xsd::cxx::tree::optional< u_int_value::type > _xsd_u_int_value_;
      ::xsd::cxx::tree::optional< int_value::type > _xsd_int_value_;
      ::xsd::cxx::tree::optional< str_value::type > _xsd_str_value_;
    };

    class bundleAttributesSimpleQueryType: public ::xml_schema::string
    {
      public:
      enum _xsd_bundleAttributesSimpleQueryType
      {
        bundleid,
        is_admin,
        do_not_fragment,
        priority,
        custody_requested,
        local_custody,
        singleton_dest,
        custody_rcpt,
        receive_rcpt,
        forward_rcpt,
        delivery_rcpt,
        deletion_rcpt,
        app_acked_rcpt,
        expiration,
        orig_length,
        owner,
        source,
        dest,
        custodian,
        replyto,
        prevhop,
        location,
        payload_file,
        meta_block_list
      };

      bundleAttributesSimpleQueryType ();

      bundleAttributesSimpleQueryType (_xsd_bundleAttributesSimpleQueryType);

      bundleAttributesSimpleQueryType (const ::xml_schema::string&);

      bundleAttributesSimpleQueryType (const ::xercesc::DOMElement&,
                                       ::xml_schema::flags = 0,
                                       ::xml_schema::type* = 0);

      bundleAttributesSimpleQueryType (const ::xercesc::DOMAttr&,
                                       ::xml_schema::flags = 0,
                                       ::xml_schema::type* = 0);

      bundleAttributesSimpleQueryType (const ::std::basic_string< char >&,
                                       const ::xercesc::DOMElement*,
                                       ::xml_schema::flags = 0,
                                       ::xml_schema::type* = 0);

      bundleAttributesSimpleQueryType (const bundleAttributesSimpleQueryType&,
                                       ::xml_schema::flags = 0,
                                       ::xml_schema::type* = 0);

      virtual bundleAttributesSimpleQueryType*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      bundleAttributesSimpleQueryType&
      operator= (_xsd_bundleAttributesSimpleQueryType);

      virtual
      operator _xsd_bundleAttributesSimpleQueryType () const
      {
        return _xsd_bundleAttributesSimpleQueryType_convert ();
      }

      protected:
      _xsd_bundleAttributesSimpleQueryType
      _xsd_bundleAttributesSimpleQueryType_convert () const;

      public:
      static const char* const _xsd_bundleAttributesSimpleQueryType_literals_[24];
      static const _xsd_bundleAttributesSimpleQueryType _xsd_bundleAttributesSimpleQueryType_indexes_[24];
    };

    class bundleMetaBlockQueryType: public ::xml_schema::type
    {
      public:

      struct _xsd_bundleMetaBlockQueryType
      {
        typedef ::xml_schema::type base_;
      };

      // Workaround for g++ bug# 23206.
      //
      public:
      struct type;

      // type
      // 
      public:
      struct type
      {
        typedef ::xml_schema::long_ type_;
        typedef ::xsd::cxx::tree::traits< type_, char > traits;
        typedef ::xsd::cxx::tree::optional< type_ > container;
      };

      const type::container&
      type () const;

      type::container&
      type ();

      void
      type (const type::type_&);

      void
      type (const type::container&);

      // identifier
      // 
      public:
      struct identifier
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const identifier::container&
      identifier () const;

      identifier::container&
      identifier ();

      void
      identifier (const identifier::type&);

      void
      identifier (const identifier::container&);

      // Constructors.
      //
      public:
      bundleMetaBlockQueryType ();

      bundleMetaBlockQueryType (const ::xercesc::DOMElement&,
                                ::xml_schema::flags = 0,
                                ::xml_schema::type* = 0);

      bundleMetaBlockQueryType (const bundleMetaBlockQueryType&,
                                ::xml_schema::flags = 0,
                                ::xml_schema::type* = 0);

      virtual bundleMetaBlockQueryType*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::optional< type::type_ > _xsd_type_;
      ::xsd::cxx::tree::optional< identifier::type > _xsd_identifier_;
    };

    class bundleAttributesQueryType: public ::xml_schema::type
    {
      public:

      struct _xsd_bundleAttributesQueryType
      {
        typedef ::xml_schema::type base_;
      };

      // query
      // 
      public:
      struct query
      {
        typedef ::dtn::rtrmessage::bundleAttributesSimpleQueryType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const query::container&
      query () const;

      query::container&
      query ();

      void
      query (const query::type&);

      void
      query (const query::container&);

      void
      query (::std::auto_ptr< query::type >);

      // meta_blocks
      // 
      public:
      struct meta_blocks
      {
        typedef ::dtn::rtrmessage::bundleMetaBlockQueryType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const meta_blocks::container&
      meta_blocks () const;

      meta_blocks::container&
      meta_blocks ();

      void
      meta_blocks (const meta_blocks::type&);

      void
      meta_blocks (const meta_blocks::container&);

      void
      meta_blocks (::std::auto_ptr< meta_blocks::type >);

      // Constructors.
      //
      public:
      bundleAttributesQueryType ();

      bundleAttributesQueryType (const ::xercesc::DOMElement&,
                                 ::xml_schema::flags = 0,
                                 ::xml_schema::type* = 0);

      bundleAttributesQueryType (const bundleAttributesQueryType&,
                                 ::xml_schema::flags = 0,
                                 ::xml_schema::type* = 0);

      virtual bundleAttributesQueryType*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::optional< query::type > _xsd_query_;
      ::xsd::cxx::tree::optional< meta_blocks::type > _xsd_meta_blocks_;
    };

    class metadataBlockType: public ::xml_schema::type
    {
      public:

      struct _xsd_metadataBlockType
      {
        typedef ::xml_schema::type base_;
      };

      // Workaround for g++ bug# 23206.
      //
      public:
      struct type;

      // identifier
      // 
      public:
      struct identifier
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const identifier::type&
      identifier () const;

      identifier::type&
      identifier ();

      void
      identifier (const identifier::type&);

      // generated
      // 
      public:
      struct generated
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const generated::type&
      generated () const;

      generated::type&
      generated ();

      void
      generated (const generated::type&);

      // type
      // 
      public:
      struct type
      {
        typedef ::xml_schema::unsigned_int type_;
        typedef ::xsd::cxx::tree::traits< type_, char > traits;
      };

      const type::type_&
      type () const;

      type::type_&
      type ();

      void
      type (const type::type_&);

      // contents
      // 
      public:
      struct contents
      {
        typedef ::xml_schema::base64_binary type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const contents::type&
      contents () const;

      contents::type&
      contents ();

      void
      contents (const contents::type&);

      void
      contents (::std::auto_ptr< contents::type >);

      // Constructors.
      //
      public:
      metadataBlockType ();

      metadataBlockType (const identifier::type&,
                         const generated::type&,
                         const type::type_&,
                         const contents::type&);

      metadataBlockType (const ::xercesc::DOMElement&,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

      metadataBlockType (const metadataBlockType&,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

      virtual metadataBlockType*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< identifier::type > _xsd_identifier_;
      ::xsd::cxx::tree::one< generated::type > _xsd_generated_;
      ::xsd::cxx::tree::one< type::type_ > _xsd_type_;
      ::xsd::cxx::tree::one< contents::type > _xsd_contents_;
    };

    class bundleAttributesReportType: public ::xml_schema::type
    {
      public:

      struct _xsd_bundleAttributesReportType
      {
        typedef ::xml_schema::type base_;
      };

      // dest
      // 
      public:
      struct dest
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const dest::container&
      dest () const;

      dest::container&
      dest ();

      void
      dest (const dest::type&);

      void
      dest (const dest::container&);

      void
      dest (::std::auto_ptr< dest::type >);

      // custodian
      // 
      public:
      struct custodian
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const custodian::container&
      custodian () const;

      custodian::container&
      custodian ();

      void
      custodian (const custodian::type&);

      void
      custodian (const custodian::container&);

      void
      custodian (::std::auto_ptr< custodian::type >);

      // replyto
      // 
      public:
      struct replyto
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const replyto::container&
      replyto () const;

      replyto::container&
      replyto ();

      void
      replyto (const replyto::type&);

      void
      replyto (const replyto::container&);

      void
      replyto (::std::auto_ptr< replyto::type >);

      // prevhop
      // 
      public:
      struct prevhop
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const prevhop::container&
      prevhop () const;

      prevhop::container&
      prevhop ();

      void
      prevhop (const prevhop::type&);

      void
      prevhop (const prevhop::container&);

      void
      prevhop (::std::auto_ptr< prevhop::type >);

      // meta_blocks
      // 
      public:
      struct meta_blocks
      {
        typedef ::dtn::rtrmessage::metadataBlockType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::sequence< type > container;
        typedef container::iterator iterator;
        typedef container::const_iterator const_iterator;
      };

      const meta_blocks::container&
      meta_blocks () const;

      meta_blocks::container&
      meta_blocks ();

      void
      meta_blocks (const meta_blocks::container&);

      // bundleid
      // 
      public:
      struct bundleid
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const bundleid::container&
      bundleid () const;

      bundleid::container&
      bundleid ();

      void
      bundleid (const bundleid::type&);

      void
      bundleid (const bundleid::container&);

      // is_admin
      // 
      public:
      struct is_admin
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const is_admin::container&
      is_admin () const;

      is_admin::container&
      is_admin ();

      void
      is_admin (const is_admin::type&);

      void
      is_admin (const is_admin::container&);

      // do_not_fragment
      // 
      public:
      struct do_not_fragment
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const do_not_fragment::container&
      do_not_fragment () const;

      do_not_fragment::container&
      do_not_fragment ();

      void
      do_not_fragment (const do_not_fragment::type&);

      void
      do_not_fragment (const do_not_fragment::container&);

      // priority
      // 
      public:
      struct priority
      {
        typedef ::dtn::rtrmessage::bundlePriorityType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const priority::container&
      priority () const;

      priority::container&
      priority ();

      void
      priority (const priority::type&);

      void
      priority (const priority::container&);

      void
      priority (::std::auto_ptr< priority::type >);

      // custody_requested
      // 
      public:
      struct custody_requested
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const custody_requested::container&
      custody_requested () const;

      custody_requested::container&
      custody_requested ();

      void
      custody_requested (const custody_requested::type&);

      void
      custody_requested (const custody_requested::container&);

      // local_custody
      // 
      public:
      struct local_custody
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const local_custody::container&
      local_custody () const;

      local_custody::container&
      local_custody ();

      void
      local_custody (const local_custody::type&);

      void
      local_custody (const local_custody::container&);

      // singleton_dest
      // 
      public:
      struct singleton_dest
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const singleton_dest::container&
      singleton_dest () const;

      singleton_dest::container&
      singleton_dest ();

      void
      singleton_dest (const singleton_dest::type&);

      void
      singleton_dest (const singleton_dest::container&);

      // custody_rcpt
      // 
      public:
      struct custody_rcpt
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const custody_rcpt::container&
      custody_rcpt () const;

      custody_rcpt::container&
      custody_rcpt ();

      void
      custody_rcpt (const custody_rcpt::type&);

      void
      custody_rcpt (const custody_rcpt::container&);

      // receive_rcpt
      // 
      public:
      struct receive_rcpt
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const receive_rcpt::container&
      receive_rcpt () const;

      receive_rcpt::container&
      receive_rcpt ();

      void
      receive_rcpt (const receive_rcpt::type&);

      void
      receive_rcpt (const receive_rcpt::container&);

      // forward_rcpt
      // 
      public:
      struct forward_rcpt
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const forward_rcpt::container&
      forward_rcpt () const;

      forward_rcpt::container&
      forward_rcpt ();

      void
      forward_rcpt (const forward_rcpt::type&);

      void
      forward_rcpt (const forward_rcpt::container&);

      // delivery_rcpt
      // 
      public:
      struct delivery_rcpt
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const delivery_rcpt::container&
      delivery_rcpt () const;

      delivery_rcpt::container&
      delivery_rcpt ();

      void
      delivery_rcpt (const delivery_rcpt::type&);

      void
      delivery_rcpt (const delivery_rcpt::container&);

      // deletion_rcpt
      // 
      public:
      struct deletion_rcpt
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const deletion_rcpt::container&
      deletion_rcpt () const;

      deletion_rcpt::container&
      deletion_rcpt ();

      void
      deletion_rcpt (const deletion_rcpt::type&);

      void
      deletion_rcpt (const deletion_rcpt::container&);

      // app_acked_rcpt
      // 
      public:
      struct app_acked_rcpt
      {
        typedef ::xml_schema::boolean type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const app_acked_rcpt::container&
      app_acked_rcpt () const;

      app_acked_rcpt::container&
      app_acked_rcpt ();

      void
      app_acked_rcpt (const app_acked_rcpt::type&);

      void
      app_acked_rcpt (const app_acked_rcpt::container&);

      // expiration
      // 
      public:
      struct expiration
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const expiration::container&
      expiration () const;

      expiration::container&
      expiration ();

      void
      expiration (const expiration::type&);

      void
      expiration (const expiration::container&);

      // orig_length
      // 
      public:
      struct orig_length
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const orig_length::container&
      orig_length () const;

      orig_length::container&
      orig_length ();

      void
      orig_length (const orig_length::type&);

      void
      orig_length (const orig_length::container&);

      // owner
      // 
      public:
      struct owner
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const owner::container&
      owner () const;

      owner::container&
      owner ();

      void
      owner (const owner::type&);

      void
      owner (const owner::container&);

      void
      owner (::std::auto_ptr< owner::type >);

      // location
      // 
      public:
      struct location
      {
        typedef ::dtn::rtrmessage::bundleLocationType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const location::container&
      location () const;

      location::container&
      location ();

      void
      location (const location::type&);

      void
      location (const location::container&);

      void
      location (::std::auto_ptr< location::type >);

      // payload_file
      // 
      public:
      struct payload_file
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const payload_file::container&
      payload_file () const;

      payload_file::container&
      payload_file ();

      void
      payload_file (const payload_file::type&);

      void
      payload_file (const payload_file::container&);

      void
      payload_file (::std::auto_ptr< payload_file::type >);

      // Constructors.
      //
      public:
      bundleAttributesReportType ();

      bundleAttributesReportType (const ::xercesc::DOMElement&,
                                  ::xml_schema::flags = 0,
                                  ::xml_schema::type* = 0);

      bundleAttributesReportType (const bundleAttributesReportType&,
                                  ::xml_schema::flags = 0,
                                  ::xml_schema::type* = 0);

      virtual bundleAttributesReportType*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::optional< dest::type > _xsd_dest_;
      ::xsd::cxx::tree::optional< custodian::type > _xsd_custodian_;
      ::xsd::cxx::tree::optional< replyto::type > _xsd_replyto_;
      ::xsd::cxx::tree::optional< prevhop::type > _xsd_prevhop_;
      ::xsd::cxx::tree::sequence< meta_blocks::type > _xsd_meta_blocks_;
      ::xsd::cxx::tree::optional< bundleid::type > _xsd_bundleid_;
      ::xsd::cxx::tree::optional< is_admin::type > _xsd_is_admin_;
      ::xsd::cxx::tree::optional< do_not_fragment::type > _xsd_do_not_fragment_;
      ::xsd::cxx::tree::optional< priority::type > _xsd_priority_;
      ::xsd::cxx::tree::optional< custody_requested::type > _xsd_custody_requested_;
      ::xsd::cxx::tree::optional< local_custody::type > _xsd_local_custody_;
      ::xsd::cxx::tree::optional< singleton_dest::type > _xsd_singleton_dest_;
      ::xsd::cxx::tree::optional< custody_rcpt::type > _xsd_custody_rcpt_;
      ::xsd::cxx::tree::optional< receive_rcpt::type > _xsd_receive_rcpt_;
      ::xsd::cxx::tree::optional< forward_rcpt::type > _xsd_forward_rcpt_;
      ::xsd::cxx::tree::optional< delivery_rcpt::type > _xsd_delivery_rcpt_;
      ::xsd::cxx::tree::optional< deletion_rcpt::type > _xsd_deletion_rcpt_;
      ::xsd::cxx::tree::optional< app_acked_rcpt::type > _xsd_app_acked_rcpt_;
      ::xsd::cxx::tree::optional< expiration::type > _xsd_expiration_;
      ::xsd::cxx::tree::optional< orig_length::type > _xsd_orig_length_;
      ::xsd::cxx::tree::optional< owner::type > _xsd_owner_;
      ::xsd::cxx::tree::optional< location::type > _xsd_location_;
      ::xsd::cxx::tree::optional< payload_file::type > _xsd_payload_file_;
    };

    class bundle_received_event: public ::xml_schema::type
    {
      public:

      struct _xsd_bundle_received_event
      {
        typedef ::xml_schema::type base_;
      };

      // gbof_id
      // 
      public:
      struct gbof_id
      {
        typedef ::dtn::rtrmessage::gbofIdType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const gbof_id::type&
      gbof_id () const;

      gbof_id::type&
      gbof_id ();

      void
      gbof_id (const gbof_id::type&);

      void
      gbof_id (::std::auto_ptr< gbof_id::type >);

      // dest
      // 
      public:
      struct dest
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const dest::type&
      dest () const;

      dest::type&
      dest ();

      void
      dest (const dest::type&);

      void
      dest (::std::auto_ptr< dest::type >);

      // custodian
      // 
      public:
      struct custodian
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const custodian::type&
      custodian () const;

      custodian::type&
      custodian ();

      void
      custodian (const custodian::type&);

      void
      custodian (::std::auto_ptr< custodian::type >);

      // replyto
      // 
      public:
      struct replyto
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const replyto::type&
      replyto () const;

      replyto::type&
      replyto ();

      void
      replyto (const replyto::type&);

      void
      replyto (::std::auto_ptr< replyto::type >);

      // prevhop
      // 
      public:
      struct prevhop
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const prevhop::container&
      prevhop () const;

      prevhop::container&
      prevhop ();

      void
      prevhop (const prevhop::type&);

      void
      prevhop (const prevhop::container&);

      void
      prevhop (::std::auto_ptr< prevhop::type >);

      // local_id
      // 
      public:
      struct local_id
      {
        typedef ::xml_schema::long_ type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const local_id::type&
      local_id () const;

      local_id::type&
      local_id ();

      void
      local_id (const local_id::type&);

      // expiration
      // 
      public:
      struct expiration
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const expiration::type&
      expiration () const;

      expiration::type&
      expiration ();

      void
      expiration (const expiration::type&);

      // bytes_received
      // 
      public:
      struct bytes_received
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const bytes_received::type&
      bytes_received () const;

      bytes_received::type&
      bytes_received ();

      void
      bytes_received (const bytes_received::type&);

      // num_meta_blocks
      // 
      public:
      struct num_meta_blocks
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const num_meta_blocks::container&
      num_meta_blocks () const;

      num_meta_blocks::container&
      num_meta_blocks ();

      void
      num_meta_blocks (const num_meta_blocks::type&);

      void
      num_meta_blocks (const num_meta_blocks::container&);

      // Constructors.
      //
      public:
      bundle_received_event ();

      bundle_received_event (const gbof_id::type&,
                             const dest::type&,
                             const custodian::type&,
                             const replyto::type&,
                             const local_id::type&,
                             const expiration::type&,
                             const bytes_received::type&);

      bundle_received_event (const ::xercesc::DOMElement&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

      bundle_received_event (const bundle_received_event&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

      virtual bundle_received_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< gbof_id::type > _xsd_gbof_id_;
      ::xsd::cxx::tree::one< dest::type > _xsd_dest_;
      ::xsd::cxx::tree::one< custodian::type > _xsd_custodian_;
      ::xsd::cxx::tree::one< replyto::type > _xsd_replyto_;
      ::xsd::cxx::tree::optional< prevhop::type > _xsd_prevhop_;
      ::xsd::cxx::tree::one< local_id::type > _xsd_local_id_;
      ::xsd::cxx::tree::one< expiration::type > _xsd_expiration_;
      ::xsd::cxx::tree::one< bytes_received::type > _xsd_bytes_received_;
      ::xsd::cxx::tree::optional< num_meta_blocks::type > _xsd_num_meta_blocks_;
    };

    class data_transmitted_event: public ::xml_schema::type
    {
      public:

      struct _xsd_data_transmitted_event
      {
        typedef ::xml_schema::type base_;
      };

      // gbof_id
      // 
      public:
      struct gbof_id
      {
        typedef ::dtn::rtrmessage::gbofIdType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const gbof_id::type&
      gbof_id () const;

      gbof_id::type&
      gbof_id ();

      void
      gbof_id (const gbof_id::type&);

      void
      gbof_id (::std::auto_ptr< gbof_id::type >);

      // local_id
      // 
      public:
      struct local_id
      {
        typedef ::xml_schema::long_ type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const local_id::type&
      local_id () const;

      local_id::type&
      local_id ();

      void
      local_id (const local_id::type&);

      // link_id
      // 
      public:
      struct link_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link_id::type&
      link_id () const;

      link_id::type&
      link_id ();

      void
      link_id (const link_id::type&);

      void
      link_id (::std::auto_ptr< link_id::type >);

      // bytes_sent
      // 
      public:
      struct bytes_sent
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const bytes_sent::type&
      bytes_sent () const;

      bytes_sent::type&
      bytes_sent ();

      void
      bytes_sent (const bytes_sent::type&);

      // reliably_sent
      // 
      public:
      struct reliably_sent
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const reliably_sent::type&
      reliably_sent () const;

      reliably_sent::type&
      reliably_sent ();

      void
      reliably_sent (const reliably_sent::type&);

      // Constructors.
      //
      public:
      data_transmitted_event ();

      data_transmitted_event (const gbof_id::type&,
                              const local_id::type&,
                              const link_id::type&,
                              const bytes_sent::type&,
                              const reliably_sent::type&);

      data_transmitted_event (const ::xercesc::DOMElement&,
                              ::xml_schema::flags = 0,
                              ::xml_schema::type* = 0);

      data_transmitted_event (const data_transmitted_event&,
                              ::xml_schema::flags = 0,
                              ::xml_schema::type* = 0);

      virtual data_transmitted_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< gbof_id::type > _xsd_gbof_id_;
      ::xsd::cxx::tree::one< local_id::type > _xsd_local_id_;
      ::xsd::cxx::tree::one< link_id::type > _xsd_link_id_;
      ::xsd::cxx::tree::one< bytes_sent::type > _xsd_bytes_sent_;
      ::xsd::cxx::tree::one< reliably_sent::type > _xsd_reliably_sent_;
    };

    class bundle_delivered_event: public ::xml_schema::type
    {
      public:

      struct _xsd_bundle_delivered_event
      {
        typedef ::xml_schema::type base_;
      };

      // gbof_id
      // 
      public:
      struct gbof_id
      {
        typedef ::dtn::rtrmessage::gbofIdType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const gbof_id::type&
      gbof_id () const;

      gbof_id::type&
      gbof_id ();

      void
      gbof_id (const gbof_id::type&);

      void
      gbof_id (::std::auto_ptr< gbof_id::type >);

      // local_id
      // 
      public:
      struct local_id
      {
        typedef ::xml_schema::long_ type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const local_id::type&
      local_id () const;

      local_id::type&
      local_id ();

      void
      local_id (const local_id::type&);

      // Constructors.
      //
      public:
      bundle_delivered_event ();

      bundle_delivered_event (const gbof_id::type&,
                              const local_id::type&);

      bundle_delivered_event (const ::xercesc::DOMElement&,
                              ::xml_schema::flags = 0,
                              ::xml_schema::type* = 0);

      bundle_delivered_event (const bundle_delivered_event&,
                              ::xml_schema::flags = 0,
                              ::xml_schema::type* = 0);

      virtual bundle_delivered_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< gbof_id::type > _xsd_gbof_id_;
      ::xsd::cxx::tree::one< local_id::type > _xsd_local_id_;
    };

    class bundle_delivery_event: public ::xml_schema::type
    {
      public:

      struct _xsd_bundle_delivery_event
      {
        typedef ::xml_schema::type base_;
      };

      // gbof_id
      // 
      public:
      struct gbof_id
      {
        typedef ::dtn::rtrmessage::gbofIdType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const gbof_id::type&
      gbof_id () const;

      gbof_id::type&
      gbof_id ();

      void
      gbof_id (const gbof_id::type&);

      void
      gbof_id (::std::auto_ptr< gbof_id::type >);

      // bundle
      // 
      public:
      struct bundle
      {
        typedef ::dtn::rtrmessage::bundleType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const bundle::type&
      bundle () const;

      bundle::type&
      bundle ();

      void
      bundle (const bundle::type&);

      void
      bundle (::std::auto_ptr< bundle::type >);

      // local_id
      // 
      public:
      struct local_id
      {
        typedef ::xml_schema::long_ type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const local_id::type&
      local_id () const;

      local_id::type&
      local_id ();

      void
      local_id (const local_id::type&);

      // Constructors.
      //
      public:
      bundle_delivery_event ();

      bundle_delivery_event (const gbof_id::type&,
                             const bundle::type&,
                             const local_id::type&);

      bundle_delivery_event (const ::xercesc::DOMElement&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

      bundle_delivery_event (const bundle_delivery_event&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

      virtual bundle_delivery_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< gbof_id::type > _xsd_gbof_id_;
      ::xsd::cxx::tree::one< bundle::type > _xsd_bundle_;
      ::xsd::cxx::tree::one< local_id::type > _xsd_local_id_;
    };

    class bundle_send_cancelled_event: public ::xml_schema::type
    {
      public:

      struct _xsd_bundle_send_cancelled_event
      {
        typedef ::xml_schema::type base_;
      };

      // gbof_id
      // 
      public:
      struct gbof_id
      {
        typedef ::dtn::rtrmessage::gbofIdType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const gbof_id::type&
      gbof_id () const;

      gbof_id::type&
      gbof_id ();

      void
      gbof_id (const gbof_id::type&);

      void
      gbof_id (::std::auto_ptr< gbof_id::type >);

      // link_id
      // 
      public:
      struct link_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link_id::type&
      link_id () const;

      link_id::type&
      link_id ();

      void
      link_id (const link_id::type&);

      void
      link_id (::std::auto_ptr< link_id::type >);

      // local_id
      // 
      public:
      struct local_id
      {
        typedef ::xml_schema::long_ type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const local_id::type&
      local_id () const;

      local_id::type&
      local_id ();

      void
      local_id (const local_id::type&);

      // Constructors.
      //
      public:
      bundle_send_cancelled_event ();

      bundle_send_cancelled_event (const gbof_id::type&,
                                   const link_id::type&,
                                   const local_id::type&);

      bundle_send_cancelled_event (const ::xercesc::DOMElement&,
                                   ::xml_schema::flags = 0,
                                   ::xml_schema::type* = 0);

      bundle_send_cancelled_event (const bundle_send_cancelled_event&,
                                   ::xml_schema::flags = 0,
                                   ::xml_schema::type* = 0);

      virtual bundle_send_cancelled_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< gbof_id::type > _xsd_gbof_id_;
      ::xsd::cxx::tree::one< link_id::type > _xsd_link_id_;
      ::xsd::cxx::tree::one< local_id::type > _xsd_local_id_;
    };

    class bundle_expired_event: public ::xml_schema::type
    {
      public:

      struct _xsd_bundle_expired_event
      {
        typedef ::xml_schema::type base_;
      };

      // gbof_id
      // 
      public:
      struct gbof_id
      {
        typedef ::dtn::rtrmessage::gbofIdType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const gbof_id::type&
      gbof_id () const;

      gbof_id::type&
      gbof_id ();

      void
      gbof_id (const gbof_id::type&);

      void
      gbof_id (::std::auto_ptr< gbof_id::type >);

      // local_id
      // 
      public:
      struct local_id
      {
        typedef ::xml_schema::long_ type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const local_id::type&
      local_id () const;

      local_id::type&
      local_id ();

      void
      local_id (const local_id::type&);

      // Constructors.
      //
      public:
      bundle_expired_event ();

      bundle_expired_event (const gbof_id::type&,
                            const local_id::type&);

      bundle_expired_event (const ::xercesc::DOMElement&,
                            ::xml_schema::flags = 0,
                            ::xml_schema::type* = 0);

      bundle_expired_event (const bundle_expired_event&,
                            ::xml_schema::flags = 0,
                            ::xml_schema::type* = 0);

      virtual bundle_expired_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< gbof_id::type > _xsd_gbof_id_;
      ::xsd::cxx::tree::one< local_id::type > _xsd_local_id_;
    };

    class bundle_injected_event: public ::xml_schema::type
    {
      public:

      struct _xsd_bundle_injected_event
      {
        typedef ::xml_schema::type base_;
      };

      // request_id
      // 
      public:
      struct request_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const request_id::type&
      request_id () const;

      request_id::type&
      request_id ();

      void
      request_id (const request_id::type&);

      void
      request_id (::std::auto_ptr< request_id::type >);

      // gbof_id
      // 
      public:
      struct gbof_id
      {
        typedef ::dtn::rtrmessage::gbofIdType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const gbof_id::type&
      gbof_id () const;

      gbof_id::type&
      gbof_id ();

      void
      gbof_id (const gbof_id::type&);

      void
      gbof_id (::std::auto_ptr< gbof_id::type >);

      // local_id
      // 
      public:
      struct local_id
      {
        typedef ::xml_schema::long_ type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const local_id::type&
      local_id () const;

      local_id::type&
      local_id ();

      void
      local_id (const local_id::type&);

      // Constructors.
      //
      public:
      bundle_injected_event ();

      bundle_injected_event (const request_id::type&,
                             const gbof_id::type&,
                             const local_id::type&);

      bundle_injected_event (const ::xercesc::DOMElement&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

      bundle_injected_event (const bundle_injected_event&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

      virtual bundle_injected_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< request_id::type > _xsd_request_id_;
      ::xsd::cxx::tree::one< gbof_id::type > _xsd_gbof_id_;
      ::xsd::cxx::tree::one< local_id::type > _xsd_local_id_;
    };

    class link_opened_event: public ::xml_schema::type
    {
      public:

      struct _xsd_link_opened_event
      {
        typedef ::xml_schema::type base_;
      };

      // contact_attr
      // 
      public:
      struct contact_attr
      {
        typedef ::dtn::rtrmessage::contactType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const contact_attr::type&
      contact_attr () const;

      contact_attr::type&
      contact_attr ();

      void
      contact_attr (const contact_attr::type&);

      void
      contact_attr (::std::auto_ptr< contact_attr::type >);

      // link_id
      // 
      public:
      struct link_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link_id::type&
      link_id () const;

      link_id::type&
      link_id ();

      void
      link_id (const link_id::type&);

      void
      link_id (::std::auto_ptr< link_id::type >);

      // Constructors.
      //
      public:
      link_opened_event ();

      link_opened_event (const contact_attr::type&,
                         const link_id::type&);

      link_opened_event (const ::xercesc::DOMElement&,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

      link_opened_event (const link_opened_event&,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

      virtual link_opened_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< contact_attr::type > _xsd_contact_attr_;
      ::xsd::cxx::tree::one< link_id::type > _xsd_link_id_;
    };

    class link_closed_event: public ::xml_schema::type
    {
      public:

      struct _xsd_link_closed_event
      {
        typedef ::xml_schema::type base_;
      };

      // contact_attr
      // 
      public:
      struct contact_attr
      {
        typedef ::dtn::rtrmessage::contactType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const contact_attr::type&
      contact_attr () const;

      contact_attr::type&
      contact_attr ();

      void
      contact_attr (const contact_attr::type&);

      void
      contact_attr (::std::auto_ptr< contact_attr::type >);

      // link_id
      // 
      public:
      struct link_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link_id::type&
      link_id () const;

      link_id::type&
      link_id ();

      void
      link_id (const link_id::type&);

      void
      link_id (::std::auto_ptr< link_id::type >);

      // reason
      // 
      public:
      struct reason
      {
        typedef ::dtn::rtrmessage::contactReasonType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const reason::type&
      reason () const;

      reason::type&
      reason ();

      void
      reason (const reason::type&);

      void
      reason (::std::auto_ptr< reason::type >);

      // Constructors.
      //
      public:
      link_closed_event ();

      link_closed_event (const contact_attr::type&,
                         const link_id::type&,
                         const reason::type&);

      link_closed_event (const ::xercesc::DOMElement&,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

      link_closed_event (const link_closed_event&,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

      virtual link_closed_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< contact_attr::type > _xsd_contact_attr_;
      ::xsd::cxx::tree::one< link_id::type > _xsd_link_id_;
      ::xsd::cxx::tree::one< reason::type > _xsd_reason_;
    };

    class link_created_event: public ::xml_schema::type
    {
      public:

      struct _xsd_link_created_event
      {
        typedef ::xml_schema::type base_;
      };

      // link_attr
      // 
      public:
      struct link_attr
      {
        typedef ::dtn::rtrmessage::linkType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link_attr::type&
      link_attr () const;

      link_attr::type&
      link_attr ();

      void
      link_attr (const link_attr::type&);

      void
      link_attr (::std::auto_ptr< link_attr::type >);

      // link_id
      // 
      public:
      struct link_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link_id::type&
      link_id () const;

      link_id::type&
      link_id ();

      void
      link_id (const link_id::type&);

      void
      link_id (::std::auto_ptr< link_id::type >);

      // reason
      // 
      public:
      struct reason
      {
        typedef ::dtn::rtrmessage::contactReasonType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const reason::type&
      reason () const;

      reason::type&
      reason ();

      void
      reason (const reason::type&);

      void
      reason (::std::auto_ptr< reason::type >);

      // Constructors.
      //
      public:
      link_created_event ();

      link_created_event (const link_attr::type&,
                          const link_id::type&,
                          const reason::type&);

      link_created_event (const ::xercesc::DOMElement&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

      link_created_event (const link_created_event&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

      virtual link_created_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< link_attr::type > _xsd_link_attr_;
      ::xsd::cxx::tree::one< link_id::type > _xsd_link_id_;
      ::xsd::cxx::tree::one< reason::type > _xsd_reason_;
    };

    class link_deleted_event: public ::xml_schema::type
    {
      public:

      struct _xsd_link_deleted_event
      {
        typedef ::xml_schema::type base_;
      };

      // link_id
      // 
      public:
      struct link_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link_id::type&
      link_id () const;

      link_id::type&
      link_id ();

      void
      link_id (const link_id::type&);

      void
      link_id (::std::auto_ptr< link_id::type >);

      // reason
      // 
      public:
      struct reason
      {
        typedef ::dtn::rtrmessage::contactReasonType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const reason::type&
      reason () const;

      reason::type&
      reason ();

      void
      reason (const reason::type&);

      void
      reason (::std::auto_ptr< reason::type >);

      // Constructors.
      //
      public:
      link_deleted_event ();

      link_deleted_event (const link_id::type&,
                          const reason::type&);

      link_deleted_event (const ::xercesc::DOMElement&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

      link_deleted_event (const link_deleted_event&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

      virtual link_deleted_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< link_id::type > _xsd_link_id_;
      ::xsd::cxx::tree::one< reason::type > _xsd_reason_;
    };

    class link_available_event: public ::xml_schema::type
    {
      public:

      struct _xsd_link_available_event
      {
        typedef ::xml_schema::type base_;
      };

      // link_id
      // 
      public:
      struct link_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link_id::type&
      link_id () const;

      link_id::type&
      link_id ();

      void
      link_id (const link_id::type&);

      void
      link_id (::std::auto_ptr< link_id::type >);

      // reason
      // 
      public:
      struct reason
      {
        typedef ::dtn::rtrmessage::contactReasonType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const reason::type&
      reason () const;

      reason::type&
      reason ();

      void
      reason (const reason::type&);

      void
      reason (::std::auto_ptr< reason::type >);

      // Constructors.
      //
      public:
      link_available_event ();

      link_available_event (const link_id::type&,
                            const reason::type&);

      link_available_event (const ::xercesc::DOMElement&,
                            ::xml_schema::flags = 0,
                            ::xml_schema::type* = 0);

      link_available_event (const link_available_event&,
                            ::xml_schema::flags = 0,
                            ::xml_schema::type* = 0);

      virtual link_available_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< link_id::type > _xsd_link_id_;
      ::xsd::cxx::tree::one< reason::type > _xsd_reason_;
    };

    class link_unavailable_event: public ::xml_schema::type
    {
      public:

      struct _xsd_link_unavailable_event
      {
        typedef ::xml_schema::type base_;
      };

      // link_id
      // 
      public:
      struct link_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link_id::type&
      link_id () const;

      link_id::type&
      link_id ();

      void
      link_id (const link_id::type&);

      void
      link_id (::std::auto_ptr< link_id::type >);

      // reason
      // 
      public:
      struct reason
      {
        typedef ::dtn::rtrmessage::contactReasonType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const reason::type&
      reason () const;

      reason::type&
      reason ();

      void
      reason (const reason::type&);

      void
      reason (::std::auto_ptr< reason::type >);

      // Constructors.
      //
      public:
      link_unavailable_event ();

      link_unavailable_event (const link_id::type&,
                              const reason::type&);

      link_unavailable_event (const ::xercesc::DOMElement&,
                              ::xml_schema::flags = 0,
                              ::xml_schema::type* = 0);

      link_unavailable_event (const link_unavailable_event&,
                              ::xml_schema::flags = 0,
                              ::xml_schema::type* = 0);

      virtual link_unavailable_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< link_id::type > _xsd_link_id_;
      ::xsd::cxx::tree::one< reason::type > _xsd_reason_;
    };

    class link_attribute_changed_event: public ::xml_schema::type
    {
      public:

      struct _xsd_link_attribute_changed_event
      {
        typedef ::xml_schema::type base_;
      };

      // link_attr
      // 
      public:
      struct link_attr
      {
        typedef ::dtn::rtrmessage::linkType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link_attr::type&
      link_attr () const;

      link_attr::type&
      link_attr ();

      void
      link_attr (const link_attr::type&);

      void
      link_attr (::std::auto_ptr< link_attr::type >);

      // link_id
      // 
      public:
      struct link_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link_id::type&
      link_id () const;

      link_id::type&
      link_id ();

      void
      link_id (const link_id::type&);

      void
      link_id (::std::auto_ptr< link_id::type >);

      // reason
      // 
      public:
      struct reason
      {
        typedef ::dtn::rtrmessage::contactReasonType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const reason::type&
      reason () const;

      reason::type&
      reason ();

      void
      reason (const reason::type&);

      void
      reason (::std::auto_ptr< reason::type >);

      // Constructors.
      //
      public:
      link_attribute_changed_event ();

      link_attribute_changed_event (const link_attr::type&,
                                    const link_id::type&,
                                    const reason::type&);

      link_attribute_changed_event (const ::xercesc::DOMElement&,
                                    ::xml_schema::flags = 0,
                                    ::xml_schema::type* = 0);

      link_attribute_changed_event (const link_attribute_changed_event&,
                                    ::xml_schema::flags = 0,
                                    ::xml_schema::type* = 0);

      virtual link_attribute_changed_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< link_attr::type > _xsd_link_attr_;
      ::xsd::cxx::tree::one< link_id::type > _xsd_link_id_;
      ::xsd::cxx::tree::one< reason::type > _xsd_reason_;
    };

    class contact_attribute_changed_event: public ::xml_schema::type
    {
      public:

      struct _xsd_contact_attribute_changed_event
      {
        typedef ::xml_schema::type base_;
      };

      // contact_eid
      // 
      public:
      struct contact_eid
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const contact_eid::type&
      contact_eid () const;

      contact_eid::type&
      contact_eid ();

      void
      contact_eid (const contact_eid::type&);

      void
      contact_eid (::std::auto_ptr< contact_eid::type >);

      // contact_attr
      // 
      public:
      struct contact_attr
      {
        typedef ::dtn::rtrmessage::contactType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const contact_attr::type&
      contact_attr () const;

      contact_attr::type&
      contact_attr ();

      void
      contact_attr (const contact_attr::type&);

      void
      contact_attr (::std::auto_ptr< contact_attr::type >);

      // reason
      // 
      public:
      struct reason
      {
        typedef ::dtn::rtrmessage::contactReasonType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const reason::type&
      reason () const;

      reason::type&
      reason ();

      void
      reason (const reason::type&);

      void
      reason (::std::auto_ptr< reason::type >);

      // Constructors.
      //
      public:
      contact_attribute_changed_event ();

      contact_attribute_changed_event (const contact_eid::type&,
                                       const contact_attr::type&,
                                       const reason::type&);

      contact_attribute_changed_event (const ::xercesc::DOMElement&,
                                       ::xml_schema::flags = 0,
                                       ::xml_schema::type* = 0);

      contact_attribute_changed_event (const contact_attribute_changed_event&,
                                       ::xml_schema::flags = 0,
                                       ::xml_schema::type* = 0);

      virtual contact_attribute_changed_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< contact_eid::type > _xsd_contact_eid_;
      ::xsd::cxx::tree::one< contact_attr::type > _xsd_contact_attr_;
      ::xsd::cxx::tree::one< reason::type > _xsd_reason_;
    };

    class link_busy_event: public ::xml_schema::type
    {
      public:

      struct _xsd_link_busy_event
      {
        typedef ::xml_schema::type base_;
      };

      // link
      // 
      public:
      struct link
      {
        typedef ::dtn::rtrmessage::linkType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link::type&
      link () const;

      link::type&
      link ();

      void
      link (const link::type&);

      void
      link (::std::auto_ptr< link::type >);

      // Constructors.
      //
      public:
      link_busy_event ();

      link_busy_event (const link::type&);

      link_busy_event (const ::xercesc::DOMElement&,
                       ::xml_schema::flags = 0,
                       ::xml_schema::type* = 0);

      link_busy_event (const link_busy_event&,
                       ::xml_schema::flags = 0,
                       ::xml_schema::type* = 0);

      virtual link_busy_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< link::type > _xsd_link_;
    };

    class eid_reachable_event: public ::xml_schema::type
    {
      public:

      struct _xsd_eid_reachable_event
      {
        typedef ::xml_schema::type base_;
      };

      // peer_eid
      // 
      public:
      struct peer_eid
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const peer_eid::type&
      peer_eid () const;

      peer_eid::type&
      peer_eid ();

      void
      peer_eid (const peer_eid::type&);

      void
      peer_eid (::std::auto_ptr< peer_eid::type >);

      // interface_name
      // 
      public:
      struct interface_name
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const interface_name::type&
      interface_name () const;

      interface_name::type&
      interface_name ();

      void
      interface_name (const interface_name::type&);

      void
      interface_name (::std::auto_ptr< interface_name::type >);

      // Constructors.
      //
      public:
      eid_reachable_event ();

      eid_reachable_event (const peer_eid::type&,
                           const interface_name::type&);

      eid_reachable_event (const ::xercesc::DOMElement&,
                           ::xml_schema::flags = 0,
                           ::xml_schema::type* = 0);

      eid_reachable_event (const eid_reachable_event&,
                           ::xml_schema::flags = 0,
                           ::xml_schema::type* = 0);

      virtual eid_reachable_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< peer_eid::type > _xsd_peer_eid_;
      ::xsd::cxx::tree::one< interface_name::type > _xsd_interface_name_;
    };

    class route_add_event: public ::xml_schema::type
    {
      public:

      struct _xsd_route_add_event
      {
        typedef ::xml_schema::type base_;
      };

      // route_entry
      // 
      public:
      struct route_entry
      {
        typedef ::dtn::rtrmessage::routeEntryType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const route_entry::type&
      route_entry () const;

      route_entry::type&
      route_entry ();

      void
      route_entry (const route_entry::type&);

      void
      route_entry (::std::auto_ptr< route_entry::type >);

      // Constructors.
      //
      public:
      route_add_event ();

      route_add_event (const route_entry::type&);

      route_add_event (const ::xercesc::DOMElement&,
                       ::xml_schema::flags = 0,
                       ::xml_schema::type* = 0);

      route_add_event (const route_add_event&,
                       ::xml_schema::flags = 0,
                       ::xml_schema::type* = 0);

      virtual route_add_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< route_entry::type > _xsd_route_entry_;
    };

    class route_delete_event: public ::xml_schema::type
    {
      public:

      struct _xsd_route_delete_event
      {
        typedef ::xml_schema::type base_;
      };

      // dest
      // 
      public:
      struct dest
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const dest::type&
      dest () const;

      dest::type&
      dest ();

      void
      dest (const dest::type&);

      void
      dest (::std::auto_ptr< dest::type >);

      // Constructors.
      //
      public:
      route_delete_event ();

      route_delete_event (const dest::type&);

      route_delete_event (const ::xercesc::DOMElement&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

      route_delete_event (const route_delete_event&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

      virtual route_delete_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< dest::type > _xsd_dest_;
    };

    class custody_signal_event: public ::xml_schema::type
    {
      public:

      struct _xsd_custody_signal_event
      {
        typedef ::xml_schema::type base_;
      };

      // gbof_id
      // 
      public:
      struct gbof_id
      {
        typedef ::dtn::rtrmessage::gbofIdType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const gbof_id::type&
      gbof_id () const;

      gbof_id::type&
      gbof_id ();

      void
      gbof_id (const gbof_id::type&);

      void
      gbof_id (::std::auto_ptr< gbof_id::type >);

      // custody_signal_attr
      // 
      public:
      struct custody_signal_attr
      {
        typedef ::dtn::rtrmessage::custodySignalType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const custody_signal_attr::type&
      custody_signal_attr () const;

      custody_signal_attr::type&
      custody_signal_attr ();

      void
      custody_signal_attr (const custody_signal_attr::type&);

      void
      custody_signal_attr (::std::auto_ptr< custody_signal_attr::type >);

      // local_id
      // 
      public:
      struct local_id
      {
        typedef ::xml_schema::long_ type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const local_id::type&
      local_id () const;

      local_id::type&
      local_id ();

      void
      local_id (const local_id::type&);

      // Constructors.
      //
      public:
      custody_signal_event ();

      custody_signal_event (const gbof_id::type&,
                            const custody_signal_attr::type&,
                            const local_id::type&);

      custody_signal_event (const ::xercesc::DOMElement&,
                            ::xml_schema::flags = 0,
                            ::xml_schema::type* = 0);

      custody_signal_event (const custody_signal_event&,
                            ::xml_schema::flags = 0,
                            ::xml_schema::type* = 0);

      virtual custody_signal_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< gbof_id::type > _xsd_gbof_id_;
      ::xsd::cxx::tree::one< custody_signal_attr::type > _xsd_custody_signal_attr_;
      ::xsd::cxx::tree::one< local_id::type > _xsd_local_id_;
    };

    class custody_timeout_event: public ::xml_schema::type
    {
      public:

      struct _xsd_custody_timeout_event
      {
        typedef ::xml_schema::type base_;
      };

      // gbof_id
      // 
      public:
      struct gbof_id
      {
        typedef ::dtn::rtrmessage::gbofIdType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const gbof_id::type&
      gbof_id () const;

      gbof_id::type&
      gbof_id ();

      void
      gbof_id (const gbof_id::type&);

      void
      gbof_id (::std::auto_ptr< gbof_id::type >);

      // local_id
      // 
      public:
      struct local_id
      {
        typedef ::xml_schema::long_ type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const local_id::type&
      local_id () const;

      local_id::type&
      local_id ();

      void
      local_id (const local_id::type&);

      // Constructors.
      //
      public:
      custody_timeout_event ();

      custody_timeout_event (const gbof_id::type&,
                             const local_id::type&);

      custody_timeout_event (const ::xercesc::DOMElement&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

      custody_timeout_event (const custody_timeout_event&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

      virtual custody_timeout_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< gbof_id::type > _xsd_gbof_id_;
      ::xsd::cxx::tree::one< local_id::type > _xsd_local_id_;
    };

    class intentional_name_resolved_event: public ::xml_schema::type
    {
      public:

      struct _xsd_intentional_name_resolved_event
      {
        typedef ::xml_schema::type base_;
      };

      // request_id
      // 
      public:
      struct request_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const request_id::type&
      request_id () const;

      request_id::type&
      request_id ();

      void
      request_id (const request_id::type&);

      void
      request_id (::std::auto_ptr< request_id::type >);

      // response_id
      // 
      public:
      struct response_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const response_id::type&
      response_id () const;

      response_id::type&
      response_id ();

      void
      response_id (const response_id::type&);

      void
      response_id (::std::auto_ptr< response_id::type >);

      // router_eid
      // 
      public:
      struct router_eid
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const router_eid::type&
      router_eid () const;

      router_eid::type&
      router_eid ();

      void
      router_eid (const router_eid::type&);

      void
      router_eid (::std::auto_ptr< router_eid::type >);

      // lb_dp_eid
      // 
      public:
      struct lb_dp_eid
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const lb_dp_eid::container&
      lb_dp_eid () const;

      lb_dp_eid::container&
      lb_dp_eid ();

      void
      lb_dp_eid (const lb_dp_eid::type&);

      void
      lb_dp_eid (const lb_dp_eid::container&);

      void
      lb_dp_eid (::std::auto_ptr< lb_dp_eid::type >);

      // intentional_name
      // 
      public:
      struct intentional_name
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const intentional_name::type&
      intentional_name () const;

      intentional_name::type&
      intentional_name ();

      void
      intentional_name (const intentional_name::type&);

      void
      intentional_name (::std::auto_ptr< intentional_name::type >);

      // grain_state
      // 
      public:
      struct grain_state
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const grain_state::type&
      grain_state () const;

      grain_state::type&
      grain_state ();

      void
      grain_state (const grain_state::type&);

      void
      grain_state (::std::auto_ptr< grain_state::type >);

      // canonical_eids
      // 
      public:
      struct canonical_eids
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::sequence< type > container;
        typedef container::iterator iterator;
        typedef container::const_iterator const_iterator;
      };

      const canonical_eids::container&
      canonical_eids () const;

      canonical_eids::container&
      canonical_eids ();

      void
      canonical_eids (const canonical_eids::container&);

      // app_eids
      // 
      public:
      struct app_eids
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::sequence< type > container;
        typedef container::iterator iterator;
        typedef container::const_iterator const_iterator;
      };

      const app_eids::container&
      app_eids () const;

      app_eids::container&
      app_eids ();

      void
      app_eids (const app_eids::container&);

      // Constructors.
      //
      public:
      intentional_name_resolved_event ();

      intentional_name_resolved_event (const request_id::type&,
                                       const response_id::type&,
                                       const router_eid::type&,
                                       const intentional_name::type&,
                                       const grain_state::type&);

      intentional_name_resolved_event (const ::xercesc::DOMElement&,
                                       ::xml_schema::flags = 0,
                                       ::xml_schema::type* = 0);

      intentional_name_resolved_event (const intentional_name_resolved_event&,
                                       ::xml_schema::flags = 0,
                                       ::xml_schema::type* = 0);

      virtual intentional_name_resolved_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< request_id::type > _xsd_request_id_;
      ::xsd::cxx::tree::one< response_id::type > _xsd_response_id_;
      ::xsd::cxx::tree::one< router_eid::type > _xsd_router_eid_;
      ::xsd::cxx::tree::optional< lb_dp_eid::type > _xsd_lb_dp_eid_;
      ::xsd::cxx::tree::one< intentional_name::type > _xsd_intentional_name_;
      ::xsd::cxx::tree::one< grain_state::type > _xsd_grain_state_;
      ::xsd::cxx::tree::sequence< canonical_eids::type > _xsd_canonical_eids_;
      ::xsd::cxx::tree::sequence< app_eids::type > _xsd_app_eids_;
    };

    class registration_added_event: public ::xml_schema::type
    {
      public:

      struct _xsd_registration_added_event
      {
        typedef ::xml_schema::type base_;
      };

      // registration
      // 
      public:
      struct registration
      {
        typedef ::dtn::rtrmessage::registrationType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const registration::type&
      registration () const;

      registration::type&
      registration ();

      void
      registration (const registration::type&);

      void
      registration (::std::auto_ptr< registration::type >);

      // source
      // 
      public:
      struct source
      {
        typedef ::dtn::rtrmessage::eventSourceType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const source::type&
      source () const;

      source::type&
      source ();

      void
      source (const source::type&);

      void
      source (::std::auto_ptr< source::type >);

      // Constructors.
      //
      public:
      registration_added_event ();

      registration_added_event (const registration::type&,
                                const source::type&);

      registration_added_event (const ::xercesc::DOMElement&,
                                ::xml_schema::flags = 0,
                                ::xml_schema::type* = 0);

      registration_added_event (const registration_added_event&,
                                ::xml_schema::flags = 0,
                                ::xml_schema::type* = 0);

      virtual registration_added_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< registration::type > _xsd_registration_;
      ::xsd::cxx::tree::one< source::type > _xsd_source_;
    };

    class registration_removed_event: public ::xml_schema::type
    {
      public:

      struct _xsd_registration_removed_event
      {
        typedef ::xml_schema::type base_;
      };

      // registration
      // 
      public:
      struct registration
      {
        typedef ::dtn::rtrmessage::registrationType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const registration::type&
      registration () const;

      registration::type&
      registration ();

      void
      registration (const registration::type&);

      void
      registration (::std::auto_ptr< registration::type >);

      // Constructors.
      //
      public:
      registration_removed_event ();

      registration_removed_event (const registration::type&);

      registration_removed_event (const ::xercesc::DOMElement&,
                                  ::xml_schema::flags = 0,
                                  ::xml_schema::type* = 0);

      registration_removed_event (const registration_removed_event&,
                                  ::xml_schema::flags = 0,
                                  ::xml_schema::type* = 0);

      virtual registration_removed_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< registration::type > _xsd_registration_;
    };

    class registration_expired_event: public ::xml_schema::type
    {
      public:

      struct _xsd_registration_expired_event
      {
        typedef ::xml_schema::type base_;
      };

      // regid
      // 
      public:
      struct regid
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const regid::type&
      regid () const;

      regid::type&
      regid ();

      void
      regid (const regid::type&);

      // Constructors.
      //
      public:
      registration_expired_event ();

      registration_expired_event (const regid::type&);

      registration_expired_event (const ::xercesc::DOMElement&,
                                  ::xml_schema::flags = 0,
                                  ::xml_schema::type* = 0);

      registration_expired_event (const registration_expired_event&,
                                  ::xml_schema::flags = 0,
                                  ::xml_schema::type* = 0);

      virtual registration_expired_event*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< regid::type > _xsd_regid_;
    };

    class open_link_request: public ::xml_schema::type
    {
      public:

      struct _xsd_open_link_request
      {
        typedef ::xml_schema::type base_;
      };

      // link_id
      // 
      public:
      struct link_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link_id::type&
      link_id () const;

      link_id::type&
      link_id ();

      void
      link_id (const link_id::type&);

      void
      link_id (::std::auto_ptr< link_id::type >);

      // Constructors.
      //
      public:
      open_link_request ();

      open_link_request (const link_id::type&);

      open_link_request (const ::xercesc::DOMElement&,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

      open_link_request (const open_link_request&,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

      virtual open_link_request*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< link_id::type > _xsd_link_id_;
    };

    class close_link_request: public ::xml_schema::type
    {
      public:

      struct _xsd_close_link_request
      {
        typedef ::xml_schema::type base_;
      };

      // link_id
      // 
      public:
      struct link_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link_id::type&
      link_id () const;

      link_id::type&
      link_id ();

      void
      link_id (const link_id::type&);

      void
      link_id (::std::auto_ptr< link_id::type >);

      // Constructors.
      //
      public:
      close_link_request ();

      close_link_request (const link_id::type&);

      close_link_request (const ::xercesc::DOMElement&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

      close_link_request (const close_link_request&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

      virtual close_link_request*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< link_id::type > _xsd_link_id_;
    };

    class add_link_request: public ::xml_schema::type
    {
      public:

      struct _xsd_add_link_request
      {
        typedef ::xml_schema::type base_;
      };

      // link_config_params
      // 
      public:
      struct link_config_params
      {
        typedef ::dtn::rtrmessage::linkConfigType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const link_config_params::container&
      link_config_params () const;

      link_config_params::container&
      link_config_params ();

      void
      link_config_params (const link_config_params::type&);

      void
      link_config_params (const link_config_params::container&);

      void
      link_config_params (::std::auto_ptr< link_config_params::type >);

      // remote_eid
      // 
      public:
      struct remote_eid
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const remote_eid::type&
      remote_eid () const;

      remote_eid::type&
      remote_eid ();

      void
      remote_eid (const remote_eid::type&);

      void
      remote_eid (::std::auto_ptr< remote_eid::type >);

      // link_id
      // 
      public:
      struct link_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link_id::type&
      link_id () const;

      link_id::type&
      link_id ();

      void
      link_id (const link_id::type&);

      void
      link_id (::std::auto_ptr< link_id::type >);

      // link_type
      // 
      public:
      struct link_type
      {
        typedef ::dtn::rtrmessage::linkTypeType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link_type::type&
      link_type () const;

      link_type::type&
      link_type ();

      void
      link_type (const link_type::type&);

      void
      link_type (::std::auto_ptr< link_type::type >);

      // clayer
      // 
      public:
      struct clayer
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const clayer::type&
      clayer () const;

      clayer::type&
      clayer ();

      void
      clayer (const clayer::type&);

      void
      clayer (::std::auto_ptr< clayer::type >);

      // Constructors.
      //
      public:
      add_link_request ();

      add_link_request (const remote_eid::type&,
                        const link_id::type&,
                        const link_type::type&,
                        const clayer::type&);

      add_link_request (const ::xercesc::DOMElement&,
                        ::xml_schema::flags = 0,
                        ::xml_schema::type* = 0);

      add_link_request (const add_link_request&,
                        ::xml_schema::flags = 0,
                        ::xml_schema::type* = 0);

      virtual add_link_request*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::optional< link_config_params::type > _xsd_link_config_params_;
      ::xsd::cxx::tree::one< remote_eid::type > _xsd_remote_eid_;
      ::xsd::cxx::tree::one< link_id::type > _xsd_link_id_;
      ::xsd::cxx::tree::one< link_type::type > _xsd_link_type_;
      ::xsd::cxx::tree::one< clayer::type > _xsd_clayer_;
    };

    class delete_link_request: public ::xml_schema::type
    {
      public:

      struct _xsd_delete_link_request
      {
        typedef ::xml_schema::type base_;
      };

      // link_id
      // 
      public:
      struct link_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link_id::type&
      link_id () const;

      link_id::type&
      link_id ();

      void
      link_id (const link_id::type&);

      void
      link_id (::std::auto_ptr< link_id::type >);

      // Constructors.
      //
      public:
      delete_link_request ();

      delete_link_request (const link_id::type&);

      delete_link_request (const ::xercesc::DOMElement&,
                           ::xml_schema::flags = 0,
                           ::xml_schema::type* = 0);

      delete_link_request (const delete_link_request&,
                           ::xml_schema::flags = 0,
                           ::xml_schema::type* = 0);

      virtual delete_link_request*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< link_id::type > _xsd_link_id_;
    };

    class reconfigure_link_request: public ::xml_schema::type
    {
      public:

      struct _xsd_reconfigure_link_request
      {
        typedef ::xml_schema::type base_;
      };

      // link_config_params
      // 
      public:
      struct link_config_params
      {
        typedef ::dtn::rtrmessage::linkConfigType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link_config_params::type&
      link_config_params () const;

      link_config_params::type&
      link_config_params ();

      void
      link_config_params (const link_config_params::type&);

      void
      link_config_params (::std::auto_ptr< link_config_params::type >);

      // link_id
      // 
      public:
      struct link_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link_id::type&
      link_id () const;

      link_id::type&
      link_id ();

      void
      link_id (const link_id::type&);

      void
      link_id (::std::auto_ptr< link_id::type >);

      // Constructors.
      //
      public:
      reconfigure_link_request ();

      reconfigure_link_request (const link_config_params::type&,
                                const link_id::type&);

      reconfigure_link_request (const ::xercesc::DOMElement&,
                                ::xml_schema::flags = 0,
                                ::xml_schema::type* = 0);

      reconfigure_link_request (const reconfigure_link_request&,
                                ::xml_schema::flags = 0,
                                ::xml_schema::type* = 0);

      virtual reconfigure_link_request*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< link_config_params::type > _xsd_link_config_params_;
      ::xsd::cxx::tree::one< link_id::type > _xsd_link_id_;
    };

    class send_bundle_request: public ::xml_schema::type
    {
      public:

      struct _xsd_send_bundle_request
      {
        typedef ::xml_schema::type base_;
      };

      // gbof_id
      // 
      public:
      struct gbof_id
      {
        typedef ::dtn::rtrmessage::gbofIdType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const gbof_id::type&
      gbof_id () const;

      gbof_id::type&
      gbof_id ();

      void
      gbof_id (const gbof_id::type&);

      void
      gbof_id (::std::auto_ptr< gbof_id::type >);

      // metadata_block
      // 
      public:
      struct metadata_block
      {
        typedef ::dtn::rtrmessage::metadataBlockType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::sequence< type > container;
        typedef container::iterator iterator;
        typedef container::const_iterator const_iterator;
      };

      const metadata_block::container&
      metadata_block () const;

      metadata_block::container&
      metadata_block ();

      void
      metadata_block (const metadata_block::container&);

      // local_id
      // 
      public:
      struct local_id
      {
        typedef ::xml_schema::long_ type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const local_id::type&
      local_id () const;

      local_id::type&
      local_id ();

      void
      local_id (const local_id::type&);

      // link_id
      // 
      public:
      struct link_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link_id::type&
      link_id () const;

      link_id::type&
      link_id ();

      void
      link_id (const link_id::type&);

      void
      link_id (::std::auto_ptr< link_id::type >);

      // fwd_action
      // 
      public:
      struct fwd_action
      {
        typedef ::dtn::rtrmessage::bundleForwardActionType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const fwd_action::type&
      fwd_action () const;

      fwd_action::type&
      fwd_action ();

      void
      fwd_action (const fwd_action::type&);

      void
      fwd_action (::std::auto_ptr< fwd_action::type >);

      // frag_size
      // 
      public:
      struct frag_size
      {
        typedef ::xml_schema::unsigned_long type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const frag_size::container&
      frag_size () const;

      frag_size::container&
      frag_size ();

      void
      frag_size (const frag_size::type&);

      void
      frag_size (const frag_size::container&);

      // frag_offset
      // 
      public:
      struct frag_offset
      {
        typedef ::xml_schema::unsigned_long type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const frag_offset::container&
      frag_offset () const;

      frag_offset::container&
      frag_offset ();

      void
      frag_offset (const frag_offset::type&);

      void
      frag_offset (const frag_offset::container&);

      // Constructors.
      //
      public:
      send_bundle_request ();

      send_bundle_request (const gbof_id::type&,
                           const local_id::type&,
                           const link_id::type&,
                           const fwd_action::type&);

      send_bundle_request (const ::xercesc::DOMElement&,
                           ::xml_schema::flags = 0,
                           ::xml_schema::type* = 0);

      send_bundle_request (const send_bundle_request&,
                           ::xml_schema::flags = 0,
                           ::xml_schema::type* = 0);

      virtual send_bundle_request*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< gbof_id::type > _xsd_gbof_id_;
      ::xsd::cxx::tree::sequence< metadata_block::type > _xsd_metadata_block_;
      ::xsd::cxx::tree::one< local_id::type > _xsd_local_id_;
      ::xsd::cxx::tree::one< link_id::type > _xsd_link_id_;
      ::xsd::cxx::tree::one< fwd_action::type > _xsd_fwd_action_;
      ::xsd::cxx::tree::optional< frag_size::type > _xsd_frag_size_;
      ::xsd::cxx::tree::optional< frag_offset::type > _xsd_frag_offset_;
    };

    class send_bundle_broadcast_request: public ::xml_schema::type
    {
      public:

      struct _xsd_send_bundle_broadcast_request
      {
        typedef ::xml_schema::type base_;
      };

      // gbof_id
      // 
      public:
      struct gbof_id
      {
        typedef ::dtn::rtrmessage::gbofIdType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const gbof_id::type&
      gbof_id () const;

      gbof_id::type&
      gbof_id ();

      void
      gbof_id (const gbof_id::type&);

      void
      gbof_id (::std::auto_ptr< gbof_id::type >);

      // metadata_block
      // 
      public:
      struct metadata_block
      {
        typedef ::dtn::rtrmessage::metadataBlockType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::sequence< type > container;
        typedef container::iterator iterator;
        typedef container::const_iterator const_iterator;
      };

      const metadata_block::container&
      metadata_block () const;

      metadata_block::container&
      metadata_block ();

      void
      metadata_block (const metadata_block::container&);

      // local_id
      // 
      public:
      struct local_id
      {
        typedef ::xml_schema::long_ type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const local_id::type&
      local_id () const;

      local_id::type&
      local_id ();

      void
      local_id (const local_id::type&);

      // fwd_action
      // 
      public:
      struct fwd_action
      {
        typedef ::dtn::rtrmessage::bundleForwardActionType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const fwd_action::type&
      fwd_action () const;

      fwd_action::type&
      fwd_action ();

      void
      fwd_action (const fwd_action::type&);

      void
      fwd_action (::std::auto_ptr< fwd_action::type >);

      // frag_size
      // 
      public:
      struct frag_size
      {
        typedef ::xml_schema::unsigned_long type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const frag_size::container&
      frag_size () const;

      frag_size::container&
      frag_size ();

      void
      frag_size (const frag_size::type&);

      void
      frag_size (const frag_size::container&);

      // frag_offset
      // 
      public:
      struct frag_offset
      {
        typedef ::xml_schema::unsigned_long type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const frag_offset::container&
      frag_offset () const;

      frag_offset::container&
      frag_offset ();

      void
      frag_offset (const frag_offset::type&);

      void
      frag_offset (const frag_offset::container&);

      // Constructors.
      //
      public:
      send_bundle_broadcast_request ();

      send_bundle_broadcast_request (const gbof_id::type&,
                                     const local_id::type&,
                                     const fwd_action::type&);

      send_bundle_broadcast_request (const ::xercesc::DOMElement&,
                                     ::xml_schema::flags = 0,
                                     ::xml_schema::type* = 0);

      send_bundle_broadcast_request (const send_bundle_broadcast_request&,
                                     ::xml_schema::flags = 0,
                                     ::xml_schema::type* = 0);

      virtual send_bundle_broadcast_request*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< gbof_id::type > _xsd_gbof_id_;
      ::xsd::cxx::tree::sequence< metadata_block::type > _xsd_metadata_block_;
      ::xsd::cxx::tree::one< local_id::type > _xsd_local_id_;
      ::xsd::cxx::tree::one< fwd_action::type > _xsd_fwd_action_;
      ::xsd::cxx::tree::optional< frag_size::type > _xsd_frag_size_;
      ::xsd::cxx::tree::optional< frag_offset::type > _xsd_frag_offset_;
    };

    class cancel_bundle_request: public ::xml_schema::type
    {
      public:

      struct _xsd_cancel_bundle_request
      {
        typedef ::xml_schema::type base_;
      };

      // gbof_id
      // 
      public:
      struct gbof_id
      {
        typedef ::dtn::rtrmessage::gbofIdType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const gbof_id::type&
      gbof_id () const;

      gbof_id::type&
      gbof_id ();

      void
      gbof_id (const gbof_id::type&);

      void
      gbof_id (::std::auto_ptr< gbof_id::type >);

      // local_id
      // 
      public:
      struct local_id
      {
        typedef ::xml_schema::long_ type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const local_id::type&
      local_id () const;

      local_id::type&
      local_id ();

      void
      local_id (const local_id::type&);

      // link_id
      // 
      public:
      struct link_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link_id::type&
      link_id () const;

      link_id::type&
      link_id ();

      void
      link_id (const link_id::type&);

      void
      link_id (::std::auto_ptr< link_id::type >);

      // Constructors.
      //
      public:
      cancel_bundle_request ();

      cancel_bundle_request (const gbof_id::type&,
                             const local_id::type&,
                             const link_id::type&);

      cancel_bundle_request (const ::xercesc::DOMElement&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

      cancel_bundle_request (const cancel_bundle_request&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

      virtual cancel_bundle_request*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< gbof_id::type > _xsd_gbof_id_;
      ::xsd::cxx::tree::one< local_id::type > _xsd_local_id_;
      ::xsd::cxx::tree::one< link_id::type > _xsd_link_id_;
    };

    class inject_bundle_request: public ::xml_schema::type
    {
      public:

      struct _xsd_inject_bundle_request
      {
        typedef ::xml_schema::type base_;
      };

      // source
      // 
      public:
      struct source
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const source::type&
      source () const;

      source::type&
      source ();

      void
      source (const source::type&);

      void
      source (::std::auto_ptr< source::type >);

      // dest
      // 
      public:
      struct dest
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const dest::type&
      dest () const;

      dest::type&
      dest ();

      void
      dest (const dest::type&);

      void
      dest (::std::auto_ptr< dest::type >);

      // replyto
      // 
      public:
      struct replyto
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const replyto::container&
      replyto () const;

      replyto::container&
      replyto ();

      void
      replyto (const replyto::type&);

      void
      replyto (const replyto::container&);

      void
      replyto (::std::auto_ptr< replyto::type >);

      // custodian
      // 
      public:
      struct custodian
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const custodian::container&
      custodian () const;

      custodian::container&
      custodian ();

      void
      custodian (const custodian::type&);

      void
      custodian (const custodian::container&);

      void
      custodian (::std::auto_ptr< custodian::type >);

      // request_id
      // 
      public:
      struct request_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const request_id::type&
      request_id () const;

      request_id::type&
      request_id ();

      void
      request_id (const request_id::type&);

      void
      request_id (::std::auto_ptr< request_id::type >);

      // link_id
      // 
      public:
      struct link_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link_id::type&
      link_id () const;

      link_id::type&
      link_id ();

      void
      link_id (const link_id::type&);

      void
      link_id (::std::auto_ptr< link_id::type >);

      // fwd_action
      // 
      public:
      struct fwd_action
      {
        typedef ::dtn::rtrmessage::bundleForwardActionType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const fwd_action::container&
      fwd_action () const;

      fwd_action::container&
      fwd_action ();

      void
      fwd_action (const fwd_action::type&);

      void
      fwd_action (const fwd_action::container&);

      void
      fwd_action (::std::auto_ptr< fwd_action::type >);

      // priority
      // 
      public:
      struct priority
      {
        typedef ::dtn::rtrmessage::bundlePriorityType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const priority::container&
      priority () const;

      priority::container&
      priority ();

      void
      priority (const priority::type&);

      void
      priority (const priority::container&);

      void
      priority (::std::auto_ptr< priority::type >);

      // expiration
      // 
      public:
      struct expiration
      {
        typedef ::xml_schema::unsigned_int type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const expiration::container&
      expiration () const;

      expiration::container&
      expiration ();

      void
      expiration (const expiration::type&);

      void
      expiration (const expiration::container&);

      // payload_file
      // 
      public:
      struct payload_file
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const payload_file::type&
      payload_file () const;

      payload_file::type&
      payload_file ();

      void
      payload_file (const payload_file::type&);

      void
      payload_file (::std::auto_ptr< payload_file::type >);

      // Constructors.
      //
      public:
      inject_bundle_request ();

      inject_bundle_request (const source::type&,
                             const dest::type&,
                             const request_id::type&,
                             const link_id::type&,
                             const payload_file::type&);

      inject_bundle_request (const ::xercesc::DOMElement&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

      inject_bundle_request (const inject_bundle_request&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

      virtual inject_bundle_request*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< source::type > _xsd_source_;
      ::xsd::cxx::tree::one< dest::type > _xsd_dest_;
      ::xsd::cxx::tree::optional< replyto::type > _xsd_replyto_;
      ::xsd::cxx::tree::optional< custodian::type > _xsd_custodian_;
      ::xsd::cxx::tree::one< request_id::type > _xsd_request_id_;
      ::xsd::cxx::tree::one< link_id::type > _xsd_link_id_;
      ::xsd::cxx::tree::optional< fwd_action::type > _xsd_fwd_action_;
      ::xsd::cxx::tree::optional< priority::type > _xsd_priority_;
      ::xsd::cxx::tree::optional< expiration::type > _xsd_expiration_;
      ::xsd::cxx::tree::one< payload_file::type > _xsd_payload_file_;
    };

    class delete_bundle_request: public ::xml_schema::type
    {
      public:

      struct _xsd_delete_bundle_request
      {
        typedef ::xml_schema::type base_;
      };

      // gbof_id
      // 
      public:
      struct gbof_id
      {
        typedef ::dtn::rtrmessage::gbofIdType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const gbof_id::type&
      gbof_id () const;

      gbof_id::type&
      gbof_id ();

      void
      gbof_id (const gbof_id::type&);

      void
      gbof_id (::std::auto_ptr< gbof_id::type >);

      // local_id
      // 
      public:
      struct local_id
      {
        typedef ::xml_schema::long_ type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const local_id::type&
      local_id () const;

      local_id::type&
      local_id ();

      void
      local_id (const local_id::type&);

      // Constructors.
      //
      public:
      delete_bundle_request ();

      delete_bundle_request (const gbof_id::type&,
                             const local_id::type&);

      delete_bundle_request (const ::xercesc::DOMElement&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

      delete_bundle_request (const delete_bundle_request&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

      virtual delete_bundle_request*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< gbof_id::type > _xsd_gbof_id_;
      ::xsd::cxx::tree::one< local_id::type > _xsd_local_id_;
    };

    class set_cl_params_request: public ::xml_schema::type
    {
      public:

      struct _xsd_set_cl_params_request
      {
        typedef ::xml_schema::type base_;
      };

      // cl_params
      // 
      public:
      struct cl_params
      {
        typedef ::dtn::rtrmessage::key_value_pair type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::sequence< type > container;
        typedef container::iterator iterator;
        typedef container::const_iterator const_iterator;
      };

      const cl_params::container&
      cl_params () const;

      cl_params::container&
      cl_params ();

      void
      cl_params (const cl_params::container&);

      // clayer
      // 
      public:
      struct clayer
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const clayer::type&
      clayer () const;

      clayer::type&
      clayer ();

      void
      clayer (const clayer::type&);

      void
      clayer (::std::auto_ptr< clayer::type >);

      // Constructors.
      //
      public:
      set_cl_params_request ();

      set_cl_params_request (const clayer::type&);

      set_cl_params_request (const ::xercesc::DOMElement&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

      set_cl_params_request (const set_cl_params_request&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

      virtual set_cl_params_request*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::sequence< cl_params::type > _xsd_cl_params_;
      ::xsd::cxx::tree::one< clayer::type > _xsd_clayer_;
    };

    class intentional_name_resolution_request: public ::xml_schema::type
    {
      public:

      struct _xsd_intentional_name_resolution_request
      {
        typedef ::xml_schema::type base_;
      };

      // gbof_id
      // 
      public:
      struct gbof_id
      {
        typedef ::dtn::rtrmessage::gbofIdType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const gbof_id::type&
      gbof_id () const;

      gbof_id::type&
      gbof_id ();

      void
      gbof_id (const gbof_id::type&);

      void
      gbof_id (::std::auto_ptr< gbof_id::type >);

      // request_id
      // 
      public:
      struct request_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const request_id::type&
      request_id () const;

      request_id::type&
      request_id ();

      void
      request_id (const request_id::type&);

      void
      request_id (::std::auto_ptr< request_id::type >);

      // router_eid
      // 
      public:
      struct router_eid
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const router_eid::type&
      router_eid () const;

      router_eid::type&
      router_eid ();

      void
      router_eid (const router_eid::type&);

      void
      router_eid (::std::auto_ptr< router_eid::type >);

      // intentional_name
      // 
      public:
      struct intentional_name
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const intentional_name::type&
      intentional_name () const;

      intentional_name::type&
      intentional_name ();

      void
      intentional_name (const intentional_name::type&);

      void
      intentional_name (::std::auto_ptr< intentional_name::type >);

      // grain_state
      // 
      public:
      struct grain_state
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const grain_state::type&
      grain_state () const;

      grain_state::type&
      grain_state ();

      void
      grain_state (const grain_state::type&);

      void
      grain_state (::std::auto_ptr< grain_state::type >);

      // Constructors.
      //
      public:
      intentional_name_resolution_request ();

      intentional_name_resolution_request (const gbof_id::type&,
                                           const request_id::type&,
                                           const router_eid::type&,
                                           const intentional_name::type&,
                                           const grain_state::type&);

      intentional_name_resolution_request (const ::xercesc::DOMElement&,
                                           ::xml_schema::flags = 0,
                                           ::xml_schema::type* = 0);

      intentional_name_resolution_request (const intentional_name_resolution_request&,
                                           ::xml_schema::flags = 0,
                                           ::xml_schema::type* = 0);

      virtual intentional_name_resolution_request*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< gbof_id::type > _xsd_gbof_id_;
      ::xsd::cxx::tree::one< request_id::type > _xsd_request_id_;
      ::xsd::cxx::tree::one< router_eid::type > _xsd_router_eid_;
      ::xsd::cxx::tree::one< intentional_name::type > _xsd_intentional_name_;
      ::xsd::cxx::tree::one< grain_state::type > _xsd_grain_state_;
    };

    class deliver_bundle_to_app_request: public ::xml_schema::type
    {
      public:

      struct _xsd_deliver_bundle_to_app_request
      {
        typedef ::xml_schema::type base_;
      };

      // endpoint
      // 
      public:
      struct endpoint
      {
        typedef ::dtn::rtrmessage::eidType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const endpoint::type&
      endpoint () const;

      endpoint::type&
      endpoint ();

      void
      endpoint (const endpoint::type&);

      void
      endpoint (::std::auto_ptr< endpoint::type >);

      // gbof_id
      // 
      public:
      struct gbof_id
      {
        typedef ::dtn::rtrmessage::gbofIdType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const gbof_id::type&
      gbof_id () const;

      gbof_id::type&
      gbof_id ();

      void
      gbof_id (const gbof_id::type&);

      void
      gbof_id (::std::auto_ptr< gbof_id::type >);

      // local_id
      // 
      public:
      struct local_id
      {
        typedef ::xml_schema::long_ type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const local_id::type&
      local_id () const;

      local_id::type&
      local_id ();

      void
      local_id (const local_id::type&);

      // Constructors.
      //
      public:
      deliver_bundle_to_app_request ();

      deliver_bundle_to_app_request (const endpoint::type&,
                                     const gbof_id::type&,
                                     const local_id::type&);

      deliver_bundle_to_app_request (const ::xercesc::DOMElement&,
                                     ::xml_schema::flags = 0,
                                     ::xml_schema::type* = 0);

      deliver_bundle_to_app_request (const deliver_bundle_to_app_request&,
                                     ::xml_schema::flags = 0,
                                     ::xml_schema::type* = 0);

      virtual deliver_bundle_to_app_request*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< endpoint::type > _xsd_endpoint_;
      ::xsd::cxx::tree::one< gbof_id::type > _xsd_gbof_id_;
      ::xsd::cxx::tree::one< local_id::type > _xsd_local_id_;
    };

    class link_report: public ::xml_schema::type
    {
      public:

      struct _xsd_link_report
      {
        typedef ::xml_schema::type base_;
      };

      // link
      // 
      public:
      struct link
      {
        typedef ::dtn::rtrmessage::linkType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::sequence< type > container;
        typedef container::iterator iterator;
        typedef container::const_iterator const_iterator;
      };

      const link::container&
      link () const;

      link::container&
      link ();

      void
      link (const link::container&);

      // Constructors.
      //
      public:
      link_report ();

      link_report (const ::xercesc::DOMElement&,
                   ::xml_schema::flags = 0,
                   ::xml_schema::type* = 0);

      link_report (const link_report&,
                   ::xml_schema::flags = 0,
                   ::xml_schema::type* = 0);

      virtual link_report*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::sequence< link::type > _xsd_link_;
    };

    class link_attributes_query: public ::xml_schema::type
    {
      public:

      struct _xsd_link_attributes_query
      {
        typedef ::xml_schema::type base_;
      };

      // query_id
      // 
      public:
      struct query_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const query_id::type&
      query_id () const;

      query_id::type&
      query_id ();

      void
      query_id (const query_id::type&);

      void
      query_id (::std::auto_ptr< query_id::type >);

      // link_id
      // 
      public:
      struct link_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const link_id::type&
      link_id () const;

      link_id::type&
      link_id ();

      void
      link_id (const link_id::type&);

      void
      link_id (::std::auto_ptr< link_id::type >);

      // query_params
      // 
      public:
      struct query_params
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::sequence< type > container;
        typedef container::iterator iterator;
        typedef container::const_iterator const_iterator;
      };

      const query_params::container&
      query_params () const;

      query_params::container&
      query_params ();

      void
      query_params (const query_params::container&);

      // Constructors.
      //
      public:
      link_attributes_query ();

      link_attributes_query (const query_id::type&,
                             const link_id::type&);

      link_attributes_query (const ::xercesc::DOMElement&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

      link_attributes_query (const link_attributes_query&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

      virtual link_attributes_query*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< query_id::type > _xsd_query_id_;
      ::xsd::cxx::tree::one< link_id::type > _xsd_link_id_;
      ::xsd::cxx::tree::sequence< query_params::type > _xsd_query_params_;
    };

    class link_attributes_report: public ::xml_schema::type
    {
      public:

      struct _xsd_link_attributes_report
      {
        typedef ::xml_schema::type base_;
      };

      // query_id
      // 
      public:
      struct query_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const query_id::type&
      query_id () const;

      query_id::type&
      query_id ();

      void
      query_id (const query_id::type&);

      void
      query_id (::std::auto_ptr< query_id::type >);

      // report_params
      // 
      public:
      struct report_params
      {
        typedef ::dtn::rtrmessage::key_value_pair type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::sequence< type > container;
        typedef container::iterator iterator;
        typedef container::const_iterator const_iterator;
      };

      const report_params::container&
      report_params () const;

      report_params::container&
      report_params ();

      void
      report_params (const report_params::container&);

      // Constructors.
      //
      public:
      link_attributes_report ();

      link_attributes_report (const query_id::type&);

      link_attributes_report (const ::xercesc::DOMElement&,
                              ::xml_schema::flags = 0,
                              ::xml_schema::type* = 0);

      link_attributes_report (const link_attributes_report&,
                              ::xml_schema::flags = 0,
                              ::xml_schema::type* = 0);

      virtual link_attributes_report*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< query_id::type > _xsd_query_id_;
      ::xsd::cxx::tree::sequence< report_params::type > _xsd_report_params_;
    };

    class contact_report: public ::xml_schema::type
    {
      public:

      struct _xsd_contact_report
      {
        typedef ::xml_schema::type base_;
      };

      // contact
      // 
      public:
      struct contact
      {
        typedef ::dtn::rtrmessage::contactType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::sequence< type > container;
        typedef container::iterator iterator;
        typedef container::const_iterator const_iterator;
      };

      const contact::container&
      contact () const;

      contact::container&
      contact ();

      void
      contact (const contact::container&);

      // Constructors.
      //
      public:
      contact_report ();

      contact_report (const ::xercesc::DOMElement&,
                      ::xml_schema::flags = 0,
                      ::xml_schema::type* = 0);

      contact_report (const contact_report&,
                      ::xml_schema::flags = 0,
                      ::xml_schema::type* = 0);

      virtual contact_report*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::sequence< contact::type > _xsd_contact_;
    };

    class route_report: public ::xml_schema::type
    {
      public:

      struct _xsd_route_report
      {
        typedef ::xml_schema::type base_;
      };

      // route_entry
      // 
      public:
      struct route_entry
      {
        typedef ::dtn::rtrmessage::routeEntryType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::sequence< type > container;
        typedef container::iterator iterator;
        typedef container::const_iterator const_iterator;
      };

      const route_entry::container&
      route_entry () const;

      route_entry::container&
      route_entry ();

      void
      route_entry (const route_entry::container&);

      // Constructors.
      //
      public:
      route_report ();

      route_report (const ::xercesc::DOMElement&,
                    ::xml_schema::flags = 0,
                    ::xml_schema::type* = 0);

      route_report (const route_report&,
                    ::xml_schema::flags = 0,
                    ::xml_schema::type* = 0);

      virtual route_report*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::sequence< route_entry::type > _xsd_route_entry_;
    };

    class bundle_report: public ::xml_schema::type
    {
      public:

      struct _xsd_bundle_report
      {
        typedef ::xml_schema::type base_;
      };

      // bundle
      // 
      public:
      struct bundle
      {
        typedef ::dtn::rtrmessage::bundleType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::sequence< type > container;
        typedef container::iterator iterator;
        typedef container::const_iterator const_iterator;
      };

      const bundle::container&
      bundle () const;

      bundle::container&
      bundle ();

      void
      bundle (const bundle::container&);

      // Constructors.
      //
      public:
      bundle_report ();

      bundle_report (const ::xercesc::DOMElement&,
                     ::xml_schema::flags = 0,
                     ::xml_schema::type* = 0);

      bundle_report (const bundle_report&,
                     ::xml_schema::flags = 0,
                     ::xml_schema::type* = 0);

      virtual bundle_report*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::sequence< bundle::type > _xsd_bundle_;
    };

    class bundle_attributes_query: public ::xml_schema::type
    {
      public:

      struct _xsd_bundle_attributes_query
      {
        typedef ::xml_schema::type base_;
      };

      // query_id
      // 
      public:
      struct query_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const query_id::type&
      query_id () const;

      query_id::type&
      query_id ();

      void
      query_id (const query_id::type&);

      void
      query_id (::std::auto_ptr< query_id::type >);

      // gbof_id
      // 
      public:
      struct gbof_id
      {
        typedef ::dtn::rtrmessage::gbofIdType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const gbof_id::type&
      gbof_id () const;

      gbof_id::type&
      gbof_id ();

      void
      gbof_id (const gbof_id::type&);

      void
      gbof_id (::std::auto_ptr< gbof_id::type >);

      // query_params
      // 
      public:
      struct query_params
      {
        typedef ::dtn::rtrmessage::bundleAttributesQueryType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::sequence< type > container;
        typedef container::iterator iterator;
        typedef container::const_iterator const_iterator;
      };

      const query_params::container&
      query_params () const;

      query_params::container&
      query_params ();

      void
      query_params (const query_params::container&);

      // local_id
      // 
      public:
      struct local_id
      {
        typedef ::xml_schema::long_ type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const local_id::type&
      local_id () const;

      local_id::type&
      local_id ();

      void
      local_id (const local_id::type&);

      // Constructors.
      //
      public:
      bundle_attributes_query ();

      bundle_attributes_query (const query_id::type&,
                               const gbof_id::type&,
                               const local_id::type&);

      bundle_attributes_query (const ::xercesc::DOMElement&,
                               ::xml_schema::flags = 0,
                               ::xml_schema::type* = 0);

      bundle_attributes_query (const bundle_attributes_query&,
                               ::xml_schema::flags = 0,
                               ::xml_schema::type* = 0);

      virtual bundle_attributes_query*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< query_id::type > _xsd_query_id_;
      ::xsd::cxx::tree::one< gbof_id::type > _xsd_gbof_id_;
      ::xsd::cxx::tree::sequence< query_params::type > _xsd_query_params_;
      ::xsd::cxx::tree::one< local_id::type > _xsd_local_id_;
    };

    class bundle_attributes_report: public ::xml_schema::type
    {
      public:

      struct _xsd_bundle_attributes_report
      {
        typedef ::xml_schema::type base_;
      };

      // query_id
      // 
      public:
      struct query_id
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const query_id::type&
      query_id () const;

      query_id::type&
      query_id ();

      void
      query_id (const query_id::type&);

      void
      query_id (::std::auto_ptr< query_id::type >);

      // report_params
      // 
      public:
      struct report_params
      {
        typedef ::dtn::rtrmessage::bundleAttributesReportType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
      };

      const report_params::type&
      report_params () const;

      report_params::type&
      report_params ();

      void
      report_params (const report_params::type&);

      void
      report_params (::std::auto_ptr< report_params::type >);

      // Constructors.
      //
      public:
      bundle_attributes_report ();

      bundle_attributes_report (const query_id::type&,
                                const report_params::type&);

      bundle_attributes_report (const ::xercesc::DOMElement&,
                                ::xml_schema::flags = 0,
                                ::xml_schema::type* = 0);

      bundle_attributes_report (const bundle_attributes_report&,
                                ::xml_schema::flags = 0,
                                ::xml_schema::type* = 0);

      virtual bundle_attributes_report*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::one< query_id::type > _xsd_query_id_;
      ::xsd::cxx::tree::one< report_params::type > _xsd_report_params_;
    };

    class bpa: public ::xml_schema::type
    {
      public:

      struct _xsd_bpa
      {
        typedef ::xml_schema::type base_;
      };

      // bundle_received_event
      // 
      public:
      struct bundle_received_event
      {
        typedef ::dtn::rtrmessage::bundle_received_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const bundle_received_event::container&
      bundle_received_event () const;

      bundle_received_event::container&
      bundle_received_event ();

      void
      bundle_received_event (const bundle_received_event::type&);

      void
      bundle_received_event (const bundle_received_event::container&);

      void
      bundle_received_event (::std::auto_ptr< bundle_received_event::type >);

      // data_transmitted_event
      // 
      public:
      struct data_transmitted_event
      {
        typedef ::dtn::rtrmessage::data_transmitted_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const data_transmitted_event::container&
      data_transmitted_event () const;

      data_transmitted_event::container&
      data_transmitted_event ();

      void
      data_transmitted_event (const data_transmitted_event::type&);

      void
      data_transmitted_event (const data_transmitted_event::container&);

      void
      data_transmitted_event (::std::auto_ptr< data_transmitted_event::type >);

      // bundle_delivered_event
      // 
      public:
      struct bundle_delivered_event
      {
        typedef ::dtn::rtrmessage::bundle_delivered_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const bundle_delivered_event::container&
      bundle_delivered_event () const;

      bundle_delivered_event::container&
      bundle_delivered_event ();

      void
      bundle_delivered_event (const bundle_delivered_event::type&);

      void
      bundle_delivered_event (const bundle_delivered_event::container&);

      void
      bundle_delivered_event (::std::auto_ptr< bundle_delivered_event::type >);

      // bundle_delivery_event
      // 
      public:
      struct bundle_delivery_event
      {
        typedef ::dtn::rtrmessage::bundle_delivery_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const bundle_delivery_event::container&
      bundle_delivery_event () const;

      bundle_delivery_event::container&
      bundle_delivery_event ();

      void
      bundle_delivery_event (const bundle_delivery_event::type&);

      void
      bundle_delivery_event (const bundle_delivery_event::container&);

      void
      bundle_delivery_event (::std::auto_ptr< bundle_delivery_event::type >);

      // bundle_expired_event
      // 
      public:
      struct bundle_expired_event
      {
        typedef ::dtn::rtrmessage::bundle_expired_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const bundle_expired_event::container&
      bundle_expired_event () const;

      bundle_expired_event::container&
      bundle_expired_event ();

      void
      bundle_expired_event (const bundle_expired_event::type&);

      void
      bundle_expired_event (const bundle_expired_event::container&);

      void
      bundle_expired_event (::std::auto_ptr< bundle_expired_event::type >);

      // bundle_send_cancelled_event
      // 
      public:
      struct bundle_send_cancelled_event
      {
        typedef ::dtn::rtrmessage::bundle_send_cancelled_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const bundle_send_cancelled_event::container&
      bundle_send_cancelled_event () const;

      bundle_send_cancelled_event::container&
      bundle_send_cancelled_event ();

      void
      bundle_send_cancelled_event (const bundle_send_cancelled_event::type&);

      void
      bundle_send_cancelled_event (const bundle_send_cancelled_event::container&);

      void
      bundle_send_cancelled_event (::std::auto_ptr< bundle_send_cancelled_event::type >);

      // bundle_injected_event
      // 
      public:
      struct bundle_injected_event
      {
        typedef ::dtn::rtrmessage::bundle_injected_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const bundle_injected_event::container&
      bundle_injected_event () const;

      bundle_injected_event::container&
      bundle_injected_event ();

      void
      bundle_injected_event (const bundle_injected_event::type&);

      void
      bundle_injected_event (const bundle_injected_event::container&);

      void
      bundle_injected_event (::std::auto_ptr< bundle_injected_event::type >);

      // link_opened_event
      // 
      public:
      struct link_opened_event
      {
        typedef ::dtn::rtrmessage::link_opened_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const link_opened_event::container&
      link_opened_event () const;

      link_opened_event::container&
      link_opened_event ();

      void
      link_opened_event (const link_opened_event::type&);

      void
      link_opened_event (const link_opened_event::container&);

      void
      link_opened_event (::std::auto_ptr< link_opened_event::type >);

      // link_closed_event
      // 
      public:
      struct link_closed_event
      {
        typedef ::dtn::rtrmessage::link_closed_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const link_closed_event::container&
      link_closed_event () const;

      link_closed_event::container&
      link_closed_event ();

      void
      link_closed_event (const link_closed_event::type&);

      void
      link_closed_event (const link_closed_event::container&);

      void
      link_closed_event (::std::auto_ptr< link_closed_event::type >);

      // link_created_event
      // 
      public:
      struct link_created_event
      {
        typedef ::dtn::rtrmessage::link_created_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const link_created_event::container&
      link_created_event () const;

      link_created_event::container&
      link_created_event ();

      void
      link_created_event (const link_created_event::type&);

      void
      link_created_event (const link_created_event::container&);

      void
      link_created_event (::std::auto_ptr< link_created_event::type >);

      // link_deleted_event
      // 
      public:
      struct link_deleted_event
      {
        typedef ::dtn::rtrmessage::link_deleted_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const link_deleted_event::container&
      link_deleted_event () const;

      link_deleted_event::container&
      link_deleted_event ();

      void
      link_deleted_event (const link_deleted_event::type&);

      void
      link_deleted_event (const link_deleted_event::container&);

      void
      link_deleted_event (::std::auto_ptr< link_deleted_event::type >);

      // link_available_event
      // 
      public:
      struct link_available_event
      {
        typedef ::dtn::rtrmessage::link_available_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const link_available_event::container&
      link_available_event () const;

      link_available_event::container&
      link_available_event ();

      void
      link_available_event (const link_available_event::type&);

      void
      link_available_event (const link_available_event::container&);

      void
      link_available_event (::std::auto_ptr< link_available_event::type >);

      // link_unavailable_event
      // 
      public:
      struct link_unavailable_event
      {
        typedef ::dtn::rtrmessage::link_unavailable_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const link_unavailable_event::container&
      link_unavailable_event () const;

      link_unavailable_event::container&
      link_unavailable_event ();

      void
      link_unavailable_event (const link_unavailable_event::type&);

      void
      link_unavailable_event (const link_unavailable_event::container&);

      void
      link_unavailable_event (::std::auto_ptr< link_unavailable_event::type >);

      // link_attribute_changed_event
      // 
      public:
      struct link_attribute_changed_event
      {
        typedef ::dtn::rtrmessage::link_attribute_changed_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const link_attribute_changed_event::container&
      link_attribute_changed_event () const;

      link_attribute_changed_event::container&
      link_attribute_changed_event ();

      void
      link_attribute_changed_event (const link_attribute_changed_event::type&);

      void
      link_attribute_changed_event (const link_attribute_changed_event::container&);

      void
      link_attribute_changed_event (::std::auto_ptr< link_attribute_changed_event::type >);

      // contact_attribute_changed_event
      // 
      public:
      struct contact_attribute_changed_event
      {
        typedef ::dtn::rtrmessage::contact_attribute_changed_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const contact_attribute_changed_event::container&
      contact_attribute_changed_event () const;

      contact_attribute_changed_event::container&
      contact_attribute_changed_event ();

      void
      contact_attribute_changed_event (const contact_attribute_changed_event::type&);

      void
      contact_attribute_changed_event (const contact_attribute_changed_event::container&);

      void
      contact_attribute_changed_event (::std::auto_ptr< contact_attribute_changed_event::type >);

      // link_busy_event
      // 
      public:
      struct link_busy_event
      {
        typedef ::dtn::rtrmessage::link_busy_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const link_busy_event::container&
      link_busy_event () const;

      link_busy_event::container&
      link_busy_event ();

      void
      link_busy_event (const link_busy_event::type&);

      void
      link_busy_event (const link_busy_event::container&);

      void
      link_busy_event (::std::auto_ptr< link_busy_event::type >);

      // eid_reachable_event
      // 
      public:
      struct eid_reachable_event
      {
        typedef ::dtn::rtrmessage::eid_reachable_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const eid_reachable_event::container&
      eid_reachable_event () const;

      eid_reachable_event::container&
      eid_reachable_event ();

      void
      eid_reachable_event (const eid_reachable_event::type&);

      void
      eid_reachable_event (const eid_reachable_event::container&);

      void
      eid_reachable_event (::std::auto_ptr< eid_reachable_event::type >);

      // route_add_event
      // 
      public:
      struct route_add_event
      {
        typedef ::dtn::rtrmessage::route_add_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const route_add_event::container&
      route_add_event () const;

      route_add_event::container&
      route_add_event ();

      void
      route_add_event (const route_add_event::type&);

      void
      route_add_event (const route_add_event::container&);

      void
      route_add_event (::std::auto_ptr< route_add_event::type >);

      // route_delete_event
      // 
      public:
      struct route_delete_event
      {
        typedef ::dtn::rtrmessage::route_delete_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const route_delete_event::container&
      route_delete_event () const;

      route_delete_event::container&
      route_delete_event ();

      void
      route_delete_event (const route_delete_event::type&);

      void
      route_delete_event (const route_delete_event::container&);

      void
      route_delete_event (::std::auto_ptr< route_delete_event::type >);

      // custody_signal_event
      // 
      public:
      struct custody_signal_event
      {
        typedef ::dtn::rtrmessage::custody_signal_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const custody_signal_event::container&
      custody_signal_event () const;

      custody_signal_event::container&
      custody_signal_event ();

      void
      custody_signal_event (const custody_signal_event::type&);

      void
      custody_signal_event (const custody_signal_event::container&);

      void
      custody_signal_event (::std::auto_ptr< custody_signal_event::type >);

      // custody_timeout_event
      // 
      public:
      struct custody_timeout_event
      {
        typedef ::dtn::rtrmessage::custody_timeout_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const custody_timeout_event::container&
      custody_timeout_event () const;

      custody_timeout_event::container&
      custody_timeout_event ();

      void
      custody_timeout_event (const custody_timeout_event::type&);

      void
      custody_timeout_event (const custody_timeout_event::container&);

      void
      custody_timeout_event (::std::auto_ptr< custody_timeout_event::type >);

      // intentional_name_resolved_event
      // 
      public:
      struct intentional_name_resolved_event
      {
        typedef ::dtn::rtrmessage::intentional_name_resolved_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const intentional_name_resolved_event::container&
      intentional_name_resolved_event () const;

      intentional_name_resolved_event::container&
      intentional_name_resolved_event ();

      void
      intentional_name_resolved_event (const intentional_name_resolved_event::type&);

      void
      intentional_name_resolved_event (const intentional_name_resolved_event::container&);

      void
      intentional_name_resolved_event (::std::auto_ptr< intentional_name_resolved_event::type >);

      // registration_added_event
      // 
      public:
      struct registration_added_event
      {
        typedef ::dtn::rtrmessage::registration_added_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const registration_added_event::container&
      registration_added_event () const;

      registration_added_event::container&
      registration_added_event ();

      void
      registration_added_event (const registration_added_event::type&);

      void
      registration_added_event (const registration_added_event::container&);

      void
      registration_added_event (::std::auto_ptr< registration_added_event::type >);

      // registration_removed_event
      // 
      public:
      struct registration_removed_event
      {
        typedef ::dtn::rtrmessage::registration_removed_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const registration_removed_event::container&
      registration_removed_event () const;

      registration_removed_event::container&
      registration_removed_event ();

      void
      registration_removed_event (const registration_removed_event::type&);

      void
      registration_removed_event (const registration_removed_event::container&);

      void
      registration_removed_event (::std::auto_ptr< registration_removed_event::type >);

      // registration_expired_event
      // 
      public:
      struct registration_expired_event
      {
        typedef ::dtn::rtrmessage::registration_expired_event type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const registration_expired_event::container&
      registration_expired_event () const;

      registration_expired_event::container&
      registration_expired_event ();

      void
      registration_expired_event (const registration_expired_event::type&);

      void
      registration_expired_event (const registration_expired_event::container&);

      void
      registration_expired_event (::std::auto_ptr< registration_expired_event::type >);

      // open_link_request
      // 
      public:
      struct open_link_request
      {
        typedef ::dtn::rtrmessage::open_link_request type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const open_link_request::container&
      open_link_request () const;

      open_link_request::container&
      open_link_request ();

      void
      open_link_request (const open_link_request::type&);

      void
      open_link_request (const open_link_request::container&);

      void
      open_link_request (::std::auto_ptr< open_link_request::type >);

      // close_link_request
      // 
      public:
      struct close_link_request
      {
        typedef ::dtn::rtrmessage::close_link_request type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const close_link_request::container&
      close_link_request () const;

      close_link_request::container&
      close_link_request ();

      void
      close_link_request (const close_link_request::type&);

      void
      close_link_request (const close_link_request::container&);

      void
      close_link_request (::std::auto_ptr< close_link_request::type >);

      // add_link_request
      // 
      public:
      struct add_link_request
      {
        typedef ::dtn::rtrmessage::add_link_request type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const add_link_request::container&
      add_link_request () const;

      add_link_request::container&
      add_link_request ();

      void
      add_link_request (const add_link_request::type&);

      void
      add_link_request (const add_link_request::container&);

      void
      add_link_request (::std::auto_ptr< add_link_request::type >);

      // delete_link_request
      // 
      public:
      struct delete_link_request
      {
        typedef ::dtn::rtrmessage::delete_link_request type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const delete_link_request::container&
      delete_link_request () const;

      delete_link_request::container&
      delete_link_request ();

      void
      delete_link_request (const delete_link_request::type&);

      void
      delete_link_request (const delete_link_request::container&);

      void
      delete_link_request (::std::auto_ptr< delete_link_request::type >);

      // reconfigure_link_request
      // 
      public:
      struct reconfigure_link_request
      {
        typedef ::dtn::rtrmessage::reconfigure_link_request type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const reconfigure_link_request::container&
      reconfigure_link_request () const;

      reconfigure_link_request::container&
      reconfigure_link_request ();

      void
      reconfigure_link_request (const reconfigure_link_request::type&);

      void
      reconfigure_link_request (const reconfigure_link_request::container&);

      void
      reconfigure_link_request (::std::auto_ptr< reconfigure_link_request::type >);

      // send_bundle_request
      // 
      public:
      struct send_bundle_request
      {
        typedef ::dtn::rtrmessage::send_bundle_request type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const send_bundle_request::container&
      send_bundle_request () const;

      send_bundle_request::container&
      send_bundle_request ();

      void
      send_bundle_request (const send_bundle_request::type&);

      void
      send_bundle_request (const send_bundle_request::container&);

      void
      send_bundle_request (::std::auto_ptr< send_bundle_request::type >);

      // send_bundle_broadcast_request
      // 
      public:
      struct send_bundle_broadcast_request
      {
        typedef ::dtn::rtrmessage::send_bundle_broadcast_request type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const send_bundle_broadcast_request::container&
      send_bundle_broadcast_request () const;

      send_bundle_broadcast_request::container&
      send_bundle_broadcast_request ();

      void
      send_bundle_broadcast_request (const send_bundle_broadcast_request::type&);

      void
      send_bundle_broadcast_request (const send_bundle_broadcast_request::container&);

      void
      send_bundle_broadcast_request (::std::auto_ptr< send_bundle_broadcast_request::type >);

      // cancel_bundle_request
      // 
      public:
      struct cancel_bundle_request
      {
        typedef ::dtn::rtrmessage::cancel_bundle_request type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const cancel_bundle_request::container&
      cancel_bundle_request () const;

      cancel_bundle_request::container&
      cancel_bundle_request ();

      void
      cancel_bundle_request (const cancel_bundle_request::type&);

      void
      cancel_bundle_request (const cancel_bundle_request::container&);

      void
      cancel_bundle_request (::std::auto_ptr< cancel_bundle_request::type >);

      // inject_bundle_request
      // 
      public:
      struct inject_bundle_request
      {
        typedef ::dtn::rtrmessage::inject_bundle_request type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const inject_bundle_request::container&
      inject_bundle_request () const;

      inject_bundle_request::container&
      inject_bundle_request ();

      void
      inject_bundle_request (const inject_bundle_request::type&);

      void
      inject_bundle_request (const inject_bundle_request::container&);

      void
      inject_bundle_request (::std::auto_ptr< inject_bundle_request::type >);

      // delete_bundle_request
      // 
      public:
      struct delete_bundle_request
      {
        typedef ::dtn::rtrmessage::delete_bundle_request type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const delete_bundle_request::container&
      delete_bundle_request () const;

      delete_bundle_request::container&
      delete_bundle_request ();

      void
      delete_bundle_request (const delete_bundle_request::type&);

      void
      delete_bundle_request (const delete_bundle_request::container&);

      void
      delete_bundle_request (::std::auto_ptr< delete_bundle_request::type >);

      // set_cl_params_request
      // 
      public:
      struct set_cl_params_request
      {
        typedef ::dtn::rtrmessage::set_cl_params_request type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const set_cl_params_request::container&
      set_cl_params_request () const;

      set_cl_params_request::container&
      set_cl_params_request ();

      void
      set_cl_params_request (const set_cl_params_request::type&);

      void
      set_cl_params_request (const set_cl_params_request::container&);

      void
      set_cl_params_request (::std::auto_ptr< set_cl_params_request::type >);

      // intentional_name_resolution_request
      // 
      public:
      struct intentional_name_resolution_request
      {
        typedef ::dtn::rtrmessage::intentional_name_resolution_request type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const intentional_name_resolution_request::container&
      intentional_name_resolution_request () const;

      intentional_name_resolution_request::container&
      intentional_name_resolution_request ();

      void
      intentional_name_resolution_request (const intentional_name_resolution_request::type&);

      void
      intentional_name_resolution_request (const intentional_name_resolution_request::container&);

      void
      intentional_name_resolution_request (::std::auto_ptr< intentional_name_resolution_request::type >);

      // deliver_bundle_to_app_request
      // 
      public:
      struct deliver_bundle_to_app_request
      {
        typedef ::dtn::rtrmessage::deliver_bundle_to_app_request type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const deliver_bundle_to_app_request::container&
      deliver_bundle_to_app_request () const;

      deliver_bundle_to_app_request::container&
      deliver_bundle_to_app_request ();

      void
      deliver_bundle_to_app_request (const deliver_bundle_to_app_request::type&);

      void
      deliver_bundle_to_app_request (const deliver_bundle_to_app_request::container&);

      void
      deliver_bundle_to_app_request (::std::auto_ptr< deliver_bundle_to_app_request::type >);

      // link_query
      // 
      public:
      struct link_query
      {
        typedef ::xml_schema::type type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const link_query::container&
      link_query () const;

      link_query::container&
      link_query ();

      void
      link_query (const link_query::type&);

      void
      link_query (const link_query::container&);

      void
      link_query (::std::auto_ptr< link_query::type >);

      // link_report
      // 
      public:
      struct link_report
      {
        typedef ::dtn::rtrmessage::link_report type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const link_report::container&
      link_report () const;

      link_report::container&
      link_report ();

      void
      link_report (const link_report::type&);

      void
      link_report (const link_report::container&);

      void
      link_report (::std::auto_ptr< link_report::type >);

      // link_attributes_query
      // 
      public:
      struct link_attributes_query
      {
        typedef ::dtn::rtrmessage::link_attributes_query type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const link_attributes_query::container&
      link_attributes_query () const;

      link_attributes_query::container&
      link_attributes_query ();

      void
      link_attributes_query (const link_attributes_query::type&);

      void
      link_attributes_query (const link_attributes_query::container&);

      void
      link_attributes_query (::std::auto_ptr< link_attributes_query::type >);

      // link_attributes_report
      // 
      public:
      struct link_attributes_report
      {
        typedef ::dtn::rtrmessage::link_attributes_report type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const link_attributes_report::container&
      link_attributes_report () const;

      link_attributes_report::container&
      link_attributes_report ();

      void
      link_attributes_report (const link_attributes_report::type&);

      void
      link_attributes_report (const link_attributes_report::container&);

      void
      link_attributes_report (::std::auto_ptr< link_attributes_report::type >);

      // contact_query
      // 
      public:
      struct contact_query
      {
        typedef ::xml_schema::type type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const contact_query::container&
      contact_query () const;

      contact_query::container&
      contact_query ();

      void
      contact_query (const contact_query::type&);

      void
      contact_query (const contact_query::container&);

      void
      contact_query (::std::auto_ptr< contact_query::type >);

      // contact_report
      // 
      public:
      struct contact_report
      {
        typedef ::dtn::rtrmessage::contact_report type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const contact_report::container&
      contact_report () const;

      contact_report::container&
      contact_report ();

      void
      contact_report (const contact_report::type&);

      void
      contact_report (const contact_report::container&);

      void
      contact_report (::std::auto_ptr< contact_report::type >);

      // route_query
      // 
      public:
      struct route_query
      {
        typedef ::xml_schema::type type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const route_query::container&
      route_query () const;

      route_query::container&
      route_query ();

      void
      route_query (const route_query::type&);

      void
      route_query (const route_query::container&);

      void
      route_query (::std::auto_ptr< route_query::type >);

      // route_report
      // 
      public:
      struct route_report
      {
        typedef ::dtn::rtrmessage::route_report type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const route_report::container&
      route_report () const;

      route_report::container&
      route_report ();

      void
      route_report (const route_report::type&);

      void
      route_report (const route_report::container&);

      void
      route_report (::std::auto_ptr< route_report::type >);

      // bundle_query
      // 
      public:
      struct bundle_query
      {
        typedef ::xml_schema::type type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const bundle_query::container&
      bundle_query () const;

      bundle_query::container&
      bundle_query ();

      void
      bundle_query (const bundle_query::type&);

      void
      bundle_query (const bundle_query::container&);

      void
      bundle_query (::std::auto_ptr< bundle_query::type >);

      // bundle_report
      // 
      public:
      struct bundle_report
      {
        typedef ::dtn::rtrmessage::bundle_report type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const bundle_report::container&
      bundle_report () const;

      bundle_report::container&
      bundle_report ();

      void
      bundle_report (const bundle_report::type&);

      void
      bundle_report (const bundle_report::container&);

      void
      bundle_report (::std::auto_ptr< bundle_report::type >);

      // bundle_attributes_query
      // 
      public:
      struct bundle_attributes_query
      {
        typedef ::dtn::rtrmessage::bundle_attributes_query type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const bundle_attributes_query::container&
      bundle_attributes_query () const;

      bundle_attributes_query::container&
      bundle_attributes_query ();

      void
      bundle_attributes_query (const bundle_attributes_query::type&);

      void
      bundle_attributes_query (const bundle_attributes_query::container&);

      void
      bundle_attributes_query (::std::auto_ptr< bundle_attributes_query::type >);

      // bundle_attributes_report
      // 
      public:
      struct bundle_attributes_report
      {
        typedef ::dtn::rtrmessage::bundle_attributes_report type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const bundle_attributes_report::container&
      bundle_attributes_report () const;

      bundle_attributes_report::container&
      bundle_attributes_report ();

      void
      bundle_attributes_report (const bundle_attributes_report::type&);

      void
      bundle_attributes_report (const bundle_attributes_report::container&);

      void
      bundle_attributes_report (::std::auto_ptr< bundle_attributes_report::type >);

      // eid
      // 
      public:
      struct eid
      {
        typedef ::xml_schema::string type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const eid::container&
      eid () const;

      eid::container&
      eid ();

      void
      eid (const eid::type&);

      void
      eid (const eid::container&);

      void
      eid (::std::auto_ptr< eid::type >);

      // hello_interval
      // 
      public:
      struct hello_interval
      {
        typedef ::xml_schema::unsigned_short type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const hello_interval::container&
      hello_interval () const;

      hello_interval::container&
      hello_interval ();

      void
      hello_interval (const hello_interval::type&);

      void
      hello_interval (const hello_interval::container&);

      // alert
      // 
      public:
      struct alert
      {
        typedef ::dtn::rtrmessage::dtnStatusType type;
        typedef ::xsd::cxx::tree::traits< type, char > traits;
        typedef ::xsd::cxx::tree::optional< type > container;
      };

      const alert::container&
      alert () const;

      alert::container&
      alert ();

      void
      alert (const alert::type&);

      void
      alert (const alert::container&);

      void
      alert (::std::auto_ptr< alert::type >);

      // Constructors.
      //
      public:
      bpa ();

      bpa (const ::xercesc::DOMElement&,
           ::xml_schema::flags = 0,
           ::xml_schema::type* = 0);

      bpa (const bpa&,
           ::xml_schema::flags = 0,
           ::xml_schema::type* = 0);

      virtual bpa*
      _clone (::xml_schema::flags = 0,
              ::xml_schema::type* = 0) const;

      // Implementation.
      //
      private:
      void
      parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

      ::xsd::cxx::tree::optional< bundle_received_event::type > _xsd_bundle_received_event_;
      ::xsd::cxx::tree::optional< data_transmitted_event::type > _xsd_data_transmitted_event_;
      ::xsd::cxx::tree::optional< bundle_delivered_event::type > _xsd_bundle_delivered_event_;
      ::xsd::cxx::tree::optional< bundle_delivery_event::type > _xsd_bundle_delivery_event_;
      ::xsd::cxx::tree::optional< bundle_expired_event::type > _xsd_bundle_expired_event_;
      ::xsd::cxx::tree::optional< bundle_send_cancelled_event::type > _xsd_bundle_send_cancelled_event_;
      ::xsd::cxx::tree::optional< bundle_injected_event::type > _xsd_bundle_injected_event_;
      ::xsd::cxx::tree::optional< link_opened_event::type > _xsd_link_opened_event_;
      ::xsd::cxx::tree::optional< link_closed_event::type > _xsd_link_closed_event_;
      ::xsd::cxx::tree::optional< link_created_event::type > _xsd_link_created_event_;
      ::xsd::cxx::tree::optional< link_deleted_event::type > _xsd_link_deleted_event_;
      ::xsd::cxx::tree::optional< link_available_event::type > _xsd_link_available_event_;
      ::xsd::cxx::tree::optional< link_unavailable_event::type > _xsd_link_unavailable_event_;
      ::xsd::cxx::tree::optional< link_attribute_changed_event::type > _xsd_link_attribute_changed_event_;
      ::xsd::cxx::tree::optional< contact_attribute_changed_event::type > _xsd_contact_attribute_changed_event_;
      ::xsd::cxx::tree::optional< link_busy_event::type > _xsd_link_busy_event_;
      ::xsd::cxx::tree::optional< eid_reachable_event::type > _xsd_eid_reachable_event_;
      ::xsd::cxx::tree::optional< route_add_event::type > _xsd_route_add_event_;
      ::xsd::cxx::tree::optional< route_delete_event::type > _xsd_route_delete_event_;
      ::xsd::cxx::tree::optional< custody_signal_event::type > _xsd_custody_signal_event_;
      ::xsd::cxx::tree::optional< custody_timeout_event::type > _xsd_custody_timeout_event_;
      ::xsd::cxx::tree::optional< intentional_name_resolved_event::type > _xsd_intentional_name_resolved_event_;
      ::xsd::cxx::tree::optional< registration_added_event::type > _xsd_registration_added_event_;
      ::xsd::cxx::tree::optional< registration_removed_event::type > _xsd_registration_removed_event_;
      ::xsd::cxx::tree::optional< registration_expired_event::type > _xsd_registration_expired_event_;
      ::xsd::cxx::tree::optional< open_link_request::type > _xsd_open_link_request_;
      ::xsd::cxx::tree::optional< close_link_request::type > _xsd_close_link_request_;
      ::xsd::cxx::tree::optional< add_link_request::type > _xsd_add_link_request_;
      ::xsd::cxx::tree::optional< delete_link_request::type > _xsd_delete_link_request_;
      ::xsd::cxx::tree::optional< reconfigure_link_request::type > _xsd_reconfigure_link_request_;
      ::xsd::cxx::tree::optional< send_bundle_request::type > _xsd_send_bundle_request_;
      ::xsd::cxx::tree::optional< send_bundle_broadcast_request::type > _xsd_send_bundle_broadcast_request_;
      ::xsd::cxx::tree::optional< cancel_bundle_request::type > _xsd_cancel_bundle_request_;
      ::xsd::cxx::tree::optional< inject_bundle_request::type > _xsd_inject_bundle_request_;
      ::xsd::cxx::tree::optional< delete_bundle_request::type > _xsd_delete_bundle_request_;
      ::xsd::cxx::tree::optional< set_cl_params_request::type > _xsd_set_cl_params_request_;
      ::xsd::cxx::tree::optional< intentional_name_resolution_request::type > _xsd_intentional_name_resolution_request_;
      ::xsd::cxx::tree::optional< deliver_bundle_to_app_request::type > _xsd_deliver_bundle_to_app_request_;
      ::xsd::cxx::tree::optional< link_query::type > _xsd_link_query_;
      ::xsd::cxx::tree::optional< link_report::type > _xsd_link_report_;
      ::xsd::cxx::tree::optional< link_attributes_query::type > _xsd_link_attributes_query_;
      ::xsd::cxx::tree::optional< link_attributes_report::type > _xsd_link_attributes_report_;
      ::xsd::cxx::tree::optional< contact_query::type > _xsd_contact_query_;
      ::xsd::cxx::tree::optional< contact_report::type > _xsd_contact_report_;
      ::xsd::cxx::tree::optional< route_query::type > _xsd_route_query_;
      ::xsd::cxx::tree::optional< route_report::type > _xsd_route_report_;
      ::xsd::cxx::tree::optional< bundle_query::type > _xsd_bundle_query_;
      ::xsd::cxx::tree::optional< bundle_report::type > _xsd_bundle_report_;
      ::xsd::cxx::tree::optional< bundle_attributes_query::type > _xsd_bundle_attributes_query_;
      ::xsd::cxx::tree::optional< bundle_attributes_report::type > _xsd_bundle_attributes_report_;
      ::xsd::cxx::tree::optional< eid::type > _xsd_eid_;
      ::xsd::cxx::tree::optional< hello_interval::type > _xsd_hello_interval_;
      ::xsd::cxx::tree::optional< alert::type > _xsd_alert_;
    };
  }
}

#include <iosfwd>

#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMInputSource.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>

namespace dtn
{
  namespace rtrmessage
  {
    // Read from a URI or a local file.
    //

    ::std::auto_ptr< ::dtn::rtrmessage::bpa >
    bpa_ (const ::std::basic_string< char >&,
          ::xml_schema::flags = 0,
          const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

    ::std::auto_ptr< ::dtn::rtrmessage::bpa >
    bpa_ (const ::std::basic_string< char >&,
          ::xsd::cxx::xml::error_handler< char >&,
          ::xml_schema::flags = 0,
          const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

    ::std::auto_ptr< ::dtn::rtrmessage::bpa >
    bpa_ (const ::std::basic_string< char >&,
          ::xercesc::DOMErrorHandler&,
          ::xml_schema::flags = 0,
          const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


    // Read from std::istream.
    //

    ::std::auto_ptr< ::dtn::rtrmessage::bpa >
    bpa_ (::std::istream&,
          ::xml_schema::flags = 0,
          const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

    ::std::auto_ptr< ::dtn::rtrmessage::bpa >
    bpa_ (::std::istream&,
          ::xsd::cxx::xml::error_handler< char >&,
          ::xml_schema::flags = 0,
          const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

    ::std::auto_ptr< ::dtn::rtrmessage::bpa >
    bpa_ (::std::istream&,
          ::xercesc::DOMErrorHandler&,
          ::xml_schema::flags = 0,
          const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


    ::std::auto_ptr< ::dtn::rtrmessage::bpa >
    bpa_ (::std::istream&,
          const ::std::basic_string< char >& id,
          ::xml_schema::flags = 0,
          const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

    ::std::auto_ptr< ::dtn::rtrmessage::bpa >
    bpa_ (::std::istream&,
          const ::std::basic_string< char >& id,
          ::xsd::cxx::xml::error_handler< char >&,
          ::xml_schema::flags = 0,
          const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

    ::std::auto_ptr< ::dtn::rtrmessage::bpa >
    bpa_ (::std::istream&,
          const ::std::basic_string< char >& id,
          ::xercesc::DOMErrorHandler&,
          ::xml_schema::flags = 0,
          const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


    // Read from InputSource.
    //

    ::std::auto_ptr< ::dtn::rtrmessage::bpa >
    bpa_ (const ::xercesc::DOMInputSource&,
          ::xml_schema::flags = 0,
          const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

    ::std::auto_ptr< ::dtn::rtrmessage::bpa >
    bpa_ (const ::xercesc::DOMInputSource&,
          ::xsd::cxx::xml::error_handler< char >&,
          ::xml_schema::flags = 0,
          const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

    ::std::auto_ptr< ::dtn::rtrmessage::bpa >
    bpa_ (const ::xercesc::DOMInputSource&,
          ::xercesc::DOMErrorHandler&,
          ::xml_schema::flags = 0,
          const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


    // Read from DOM.
    //

    ::std::auto_ptr< ::dtn::rtrmessage::bpa >
    bpa_ (const ::xercesc::DOMDocument&,
          ::xml_schema::flags = 0,
          const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());
  }
}

#include <iosfwd> // std::ostream&

#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>
#include <xercesc/framework/XMLFormatter.hpp>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

namespace dtn
{
  namespace rtrmessage
  {
    void
    operator<< (::xercesc::DOMElement&,
                dtnStatusType);

    void
    operator<< (::xercesc::DOMAttr&,
                dtnStatusType);

    void
    operator<< (::xsd::cxx::tree::list_stream< char >&,
                dtnStatusType);

    void
    operator<< (::xercesc::DOMElement&,
                bundlePriorityType);

    void
    operator<< (::xercesc::DOMAttr&,
                bundlePriorityType);

    void
    operator<< (::xsd::cxx::tree::list_stream< char >&,
                bundlePriorityType);

    void
    operator<< (::xercesc::DOMElement&,
                eventSourceType);

    void
    operator<< (::xercesc::DOMAttr&,
                eventSourceType);

    void
    operator<< (::xsd::cxx::tree::list_stream< char >&,
                eventSourceType);

    void
    operator<< (::xercesc::DOMElement&,
                bundleForwardActionType);

    void
    operator<< (::xercesc::DOMAttr&,
                bundleForwardActionType);

    void
    operator<< (::xsd::cxx::tree::list_stream< char >&,
                bundleForwardActionType);

    void
    operator<< (::xercesc::DOMElement&,
                contactReasonType);

    void
    operator<< (::xercesc::DOMAttr&,
                contactReasonType);

    void
    operator<< (::xsd::cxx::tree::list_stream< char >&,
                contactReasonType);

    void
    operator<< (::xercesc::DOMElement&,
                linkTypeType);

    void
    operator<< (::xercesc::DOMAttr&,
                linkTypeType);

    void
    operator<< (::xsd::cxx::tree::list_stream< char >&,
                linkTypeType);

    void
    operator<< (::xercesc::DOMElement&,
                linkStateType);

    void
    operator<< (::xercesc::DOMAttr&,
                linkStateType);

    void
    operator<< (::xsd::cxx::tree::list_stream< char >&,
                linkStateType);

    void
    operator<< (::xercesc::DOMElement&,
                const eidTypeType&);

    void
    operator<< (::xercesc::DOMAttr&,
                const eidTypeType&);

    void
    operator<< (::xsd::cxx::tree::list_stream< char >&,
                const eidTypeType&);

    void
    operator<< (::xercesc::DOMElement&,
                const percentType&);

    void
    operator<< (::xercesc::DOMAttr&,
                const percentType&);

    void
    operator<< (::xsd::cxx::tree::list_stream< char >&,
                const percentType&);

    void
    operator<< (::xercesc::DOMElement&,
                failureActionType);

    void
    operator<< (::xercesc::DOMAttr&,
                failureActionType);

    void
    operator<< (::xsd::cxx::tree::list_stream< char >&,
                failureActionType);

    void
    operator<< (::xercesc::DOMElement&,
                bundleLocationType);

    void
    operator<< (::xercesc::DOMAttr&,
                bundleLocationType);

    void
    operator<< (::xsd::cxx::tree::list_stream< char >&,
                bundleLocationType);

    void
    operator<< (::xercesc::DOMElement&,
                const eidType_base&);

    void
    operator<< (::xercesc::DOMElement&,
                const gbofIdType_base&);

    void
    operator<< (::xercesc::DOMElement&,
                const bundleType_base&);

    void
    operator<< (::xercesc::DOMElement&,
                const contactType_base&);

    void
    operator<< (::xercesc::DOMElement&,
                const clInfoType&);

    void
    operator<< (::xercesc::DOMElement&,
                const linkType_base&);

    void
    operator<< (::xercesc::DOMElement&,
                const routeEntryType_base&);

    void
    operator<< (::xercesc::DOMElement&,
                const custodySignalType&);

    void
    operator<< (::xercesc::DOMElement&,
                const registrationType_base&);

    void
    operator<< (::xercesc::DOMElement&,
                const linkConfigType&);

    void
    operator<< (::xercesc::DOMElement&,
                const key_value_pair_base&);

    void
    operator<< (::xercesc::DOMElement&,
                bundleAttributesSimpleQueryType);

    void
    operator<< (::xercesc::DOMAttr&,
                bundleAttributesSimpleQueryType);

    void
    operator<< (::xsd::cxx::tree::list_stream< char >&,
                bundleAttributesSimpleQueryType);

    void
    operator<< (::xercesc::DOMElement&,
                const bundleMetaBlockQueryType&);

    void
    operator<< (::xercesc::DOMElement&,
                const bundleAttributesQueryType&);

    void
    operator<< (::xercesc::DOMElement&,
                const metadataBlockType&);

    void
    operator<< (::xercesc::DOMElement&,
                const bundleAttributesReportType&);

    // Serialize to an existing DOM instance.
    //
    void
    bpa_ (::xercesc::DOMDocument&,
          const ::dtn::rtrmessage::bpa&,
          ::xml_schema::flags = 0);


    // Serialize to a new DOM instance.
    //
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument >
    bpa_ (const ::dtn::rtrmessage::bpa&, 
          const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
          ::xml_schema::flags = 0);


    // Serialize to XMLFormatTarget.
    //
    void
    bpa_ (::xercesc::XMLFormatTarget&,
          const ::dtn::rtrmessage::bpa&, 
          const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
          const ::std::basic_string< char >& = "UTF-8",
          ::xml_schema::flags = 0);


    void
    bpa_ (::xercesc::XMLFormatTarget&,
          const ::dtn::rtrmessage::bpa&, 
          const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
          ::xsd::cxx::xml::error_handler< char >&,
          const ::std::basic_string< char >& = "UTF-8",
          ::xml_schema::flags = 0);

    void
    bpa_ (::xercesc::XMLFormatTarget&,
          const ::dtn::rtrmessage::bpa&, 
          const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
          ::xercesc::DOMErrorHandler&,
          const ::std::basic_string< char >& = "UTF-8",
          ::xml_schema::flags = 0);


    // Serialize to std::ostream.
    //
    void
    bpa_ (::std::ostream&,
          const ::dtn::rtrmessage::bpa&, 
          const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
          const ::std::basic_string< char >& = "UTF-8",
          ::xml_schema::flags = 0);


    void
    bpa_ (::std::ostream&,
          const ::dtn::rtrmessage::bpa&, 
          const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
          ::xsd::cxx::xml::error_handler< char >&,
          const ::std::basic_string< char >& = "UTF-8",
          ::xml_schema::flags = 0);

    void
    bpa_ (::std::ostream&,
          const ::dtn::rtrmessage::bpa&, 
          const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
          ::xercesc::DOMErrorHandler&,
          const ::std::basic_string< char >& = "UTF-8",
          ::xml_schema::flags = 0);


    void
    operator<< (::xercesc::DOMElement&,
                const bundle_received_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const data_transmitted_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const bundle_delivered_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const bundle_delivery_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const bundle_send_cancelled_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const bundle_expired_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const bundle_injected_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const link_opened_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const link_closed_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const link_created_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const link_deleted_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const link_available_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const link_unavailable_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const link_attribute_changed_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const contact_attribute_changed_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const link_busy_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const eid_reachable_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const route_add_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const route_delete_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const custody_signal_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const custody_timeout_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const intentional_name_resolved_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const registration_added_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const registration_removed_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const registration_expired_event&);

    void
    operator<< (::xercesc::DOMElement&,
                const open_link_request&);

    void
    operator<< (::xercesc::DOMElement&,
                const close_link_request&);

    void
    operator<< (::xercesc::DOMElement&,
                const add_link_request&);

    void
    operator<< (::xercesc::DOMElement&,
                const delete_link_request&);

    void
    operator<< (::xercesc::DOMElement&,
                const reconfigure_link_request&);

    void
    operator<< (::xercesc::DOMElement&,
                const send_bundle_request&);

    void
    operator<< (::xercesc::DOMElement&,
                const send_bundle_broadcast_request&);

    void
    operator<< (::xercesc::DOMElement&,
                const cancel_bundle_request&);

    void
    operator<< (::xercesc::DOMElement&,
                const inject_bundle_request&);

    void
    operator<< (::xercesc::DOMElement&,
                const delete_bundle_request&);

    void
    operator<< (::xercesc::DOMElement&,
                const set_cl_params_request&);

    void
    operator<< (::xercesc::DOMElement&,
                const intentional_name_resolution_request&);

    void
    operator<< (::xercesc::DOMElement&,
                const deliver_bundle_to_app_request&);

    void
    operator<< (::xercesc::DOMElement&,
                const link_report&);

    void
    operator<< (::xercesc::DOMElement&,
                const link_attributes_query&);

    void
    operator<< (::xercesc::DOMElement&,
                const link_attributes_report&);

    void
    operator<< (::xercesc::DOMElement&,
                const contact_report&);

    void
    operator<< (::xercesc::DOMElement&,
                const route_report&);

    void
    operator<< (::xercesc::DOMElement&,
                const bundle_report&);

    void
    operator<< (::xercesc::DOMElement&,
                const bundle_attributes_query&);

    void
    operator<< (::xercesc::DOMElement&,
                const bundle_attributes_report&);

    void
    operator<< (::xercesc::DOMElement&,
                const bpa&);
  }
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
#include "router-custom.h"
//
// End epilogue.

#endif // ROUTER_H
