#include "diagram.h"
#include "ui_diagram.h"
#include "alcohol.h"

Diagram::Diagram(QMainWindow *parent, Alcohol *alc) :
    QMainWindow(parent),
    ui(new Ui::Diagram)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif
    m_alc = alc;
    showDiagram();
}

Diagram::~Diagram()
{
    delete ui;
}

void Diagram::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void Diagram::resizeEvent(QResizeEvent* event) {
    showDiagram();
}

void Diagram::showDiagram()
{
    const int border = 20;
    QPixmap *pix;

    m_alc->calcTimeLine();
    if(m_alc->getTimeLineCount()<1)
        return;

    ui->lblDiagram->setGeometry(border,border,this->width()-2*border,this->height()-2*border);
    pix = m_alc->drawDiagram(ui->lblDiagram->width(), ui->lblDiagram->height());
    ui->lblDiagram->setPixmap(*pix);
    delete pix; pix=0;

    if(m_alc->getTimeToDrive()<=0)
        ui->lblDriveInfo->setText("You are maybe allowed to drive your car");
    else {
        QTime driveTime=QTime::currentTime();
        driveTime = driveTime.addSecs(m_alc->getTimeToDrive()*60);
        ui->lblDriveInfo->setText("You are not allowed to drive your car.\nWait until " + driveTime.toString("hh:mm") );
    }
    ui->lblDriveInfo->setGeometry(0,this->height()-80, this->width(), 60);
}


