#include "alcohol.h"
#include <QPainter>
#include <QTime>
#include <QPen>

Alcohol::Alcohol(QVector<drink> *drinks, QVector<drinkDefinition> *drinkDefs, QVector<float> *timeLine, settingsStruct *sett)
{
    m_drinks = drinks;
    m_drinkDefs = drinkDefs;
    m_timeLine = timeLine;
    m_sett = sett;
}

//returns additive permill
float Alcohol::calcAlc(int drinkType) {
    float gkw;
    float A;
    float c;

    float amountMl = m_drinkDefs->at(drinkType).amountMl;
    float percentage = m_drinkDefs->at(drinkType).percentage;


    // http://de.wikipedia.org/wiki/Blutalkoholkonzentration
    if(m_sett->bodyGenderIsFemale)
        gkw = 0.203 - 0.07 * m_sett->bodyAge + 0.1069 * m_sett->bodyHeight + 0.2466 * m_sett->bodyWeight;
    else
        gkw = 2.447 - 0.09516 * m_sett->bodyAge + 0.1074 * m_sett->bodyHeight + 0.3362 * m_sett->bodyWeight;

    A = amountMl * percentage * 0.8;
    c = 0.8 * A / (1.055 * gkw);

    return c/100;
}


void Alcohol::calcTimeLine() {
    float permillPerMin=m_sett->permillePerHour/60;
    time_t startTime, curTime, drinkTime;//daytime in minutes

    m_timeLine->clear();

    if(m_drinks->count()<=0)
        return;

    startTime = m_drinks->at(0).unixTime/60 - 1;//m_drinks->at(0).time.hour()*60 + m_drinks->at(0).time.minute()-1;
    curTime = time(NULL)/60;//QTime::currentTime().hour()*60 + QTime::currentTime().minute();

    //if(curTime<startTime) // if time goes over 0:00, add 24h
    //    curTime+=(24*60);

    for(int i=startTime; i<=curTime; i++) {
        float additivePermill=0;

        for(int j=0; j<m_drinks->count(); j++) {
            drinkTime = m_drinks->at(j).unixTime/60;//m_drinks->at(j).time.hour()*60 + m_drinks->at(j).time.minute();

            //if(drinkTime<startTime)
            //    drinkTime+=(24*60);

            if(drinkTime==i && m_drinks->at(j).addsPermill)
                additivePermill += m_drinks->at(j).additivePermill;
        }

        m_timeLine->append(additivePermill);
    }

    //Decrement the alcohol value, your liver is your friend
    for(int i=1; i<m_timeLine->count(); i++) {
        m_timeLine->replace(i, m_timeLine->at(i) + m_timeLine->at(i-1) - permillPerMin);

        if(m_timeLine->at(i)<0)// negative vals are not allowed
            m_timeLine->replace(i,0);
    }

}


QPixmap *Alcohol::drawDiagram(int width, int height) {
    float percentMax=0;
    int scaleVal;
    float scaleTime;
    QPixmap *diagram = new QPixmap(width, height);
    diagram->fill(Qt::black);
    QPainter painter(diagram);


    if(m_timeLine->count()<2)
        return diagram;

    //Find maximum of percent to scale the diagram
    for(int i=0; i<m_timeLine->count(); i++) {
        if(m_timeLine->at(i) > percentMax)
            percentMax=m_timeLine->at(i);
    }

    scaleVal=(float)diagram->height()*0.85/((int)percentMax+1);
    scaleTime=(float)diagram->width()/(float)m_timeLine->count();


    //Draw horizontal lines
    painter.setPen(Qt::lightGray);
    for(int i=1; i<(int)percentMax+2; i++) {
        painter.drawText(0, diagram->height()-scaleVal*i-2, QString::number(i) + " per mill blood alcohol");
        painter.drawLine(0, diagram->height()-scaleVal*i, diagram->width(), diagram->height()-scaleVal*i);
    }

    //Draw vertical lines (time)
    QTime time=m_drinks->at(0).time;
    int hour=time.hour();
    int min=time.minute();
    int reducer=m_timeLine->count()/500;
    if(reducer<1)
        reducer=1;

    for(int i=0; i<m_timeLine->count(); i++) {

        if(min==0 && hour%reducer==0) {
            painter.drawLine(((float)i*scaleTime), 0, ((float)i*scaleTime), diagram->height());
            painter.drawText(((float)i*scaleTime), 20, QString::number(hour) + ":00");
        }

        min++;
        if(min==60) {
            hour++;
            min=0;
        }
        if(hour==24)
            hour=0;
    }



    //draw percentline
    QPen pen;
    pen.setWidth(3);
    pen.setColor(Qt::green);
    painter.setPen(pen);

    for(int i=1; i<m_timeLine->count(); i++) {
        int v1, v2;
        v1 = (int)(m_timeLine->at(i-1)*scaleVal);
        v2 = (int)(m_timeLine->at(i)*scaleVal);

        float x1, x2;
        x1=((float)(i-1)*scaleTime);
        x2=((float)i*scaleTime);

        painter.drawLine((int)x1, diagram->height()-v1, (int)x2, diagram->height()-v2);
    }


    return diagram;
}

int Alcohol::getTimeLineCount()
{
    return m_timeLine->count();
}

int Alcohol::getTimeToDrive() {
    if(m_timeLine->count()<1)
        return 0;
    if(m_sett->permillePerHour==0)
        return 0;

    return (m_timeLine->back()-m_sett->driveLimit)/(m_sett->permillePerHour/60);
}
