#ifndef DRINKCOUNTER_H
#define DRINKCOUNTER_H

#include <QMainWindow>
#include <QTimer>
#include <QPushButton>
#include <QButtonGroup>
#include <QTime>
#include <QSettings>
#include <QLabel>
#include "alcohol.h"


namespace Ui {
    class DrinkCounter;
}

class DrinkCounter : public QMainWindow {
    Q_OBJECT
public:
    DrinkCounter(QWidget *parent = 0);

    ~DrinkCounter();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::DrinkCounter *ui;
    QTimer *dragNdropTimer;
    QTimer *dropDelayTimer;
    QTimer *calcTimer;
    QTimer *trashTimer;
    QTimer *slideTimer;

    QButtonGroup *drinkButtons;
    QButtonGroup *drinkButtonsDone;
    QLabel *trashLabel;
    QLabel *editLabel;
    QPushButton *animatedButton;
    int activeButton;
    int posX, posY;
    bool slideTrashIn;
    Alcohol *alc;

    //animation variables
    int xPos;
    int yPos;
    int stepsX[9];
    int stepsY[9];

    QVector<drink> drinks;
    QVector<drinkDefinition> drinkDefs;
    QVector<float> timeLine;
    settingsStruct sett;

    void addDrink(int btnNr, QTime time, time_t unixTime, bool addsPermill, bool haveToPay);
    void loadDefinitions();
    void saveDefinitions();
    void reloadDefinitions();
    void deleteDefinition(int btnNr);
    void editDefinition(int btnNr);
    void deleteDrinks();
    void loadDrinks();
    void saveDrinks();
    void reloadDrinks();
    void addDef(drinkDefinition def);

    void setToStartPos(QPushButton *btn, int btnNr, bool animation);
    void slideTo(QPushButton *but, int xTo, int yTo);
    void showAlc();


private slots:
    void on_actionAbout_triggered();
    void on_btnNewDrink_clicked();
    void btnPressed(int btnNr);
    void btnReleased(int btnNr);
    void btnDoneClicked(int btnNr);
    void dragNdropTimer_timeout();
    void dropDelayTimer_timeout();
    void calcTimer_timeout();
    void trashTimer_timeout();
    void slideTimer_timeout();

    void on_btnDiagram_clicked();
    void on_btnNewParty_clicked();

    void on_actionSettings_triggered();
};

#endif
